/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.individuals;

import edu.stanford.smi.protege.action.DeleteInstancesAction;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.individuals.InstancesList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.Action;
import javax.swing.JScrollPane;

public class InferredInstancesListPanel
extends SelectableContainer {
    private AllowableAction deleteAction;
    private OWLLabeledComponent lc;
    private InstancesList list = new InstancesList(null);
    private Collection types;

    public InferredInstancesListPanel() {
        this.lc = new OWLLabeledComponent("Inferred Instances", new JScrollPane((Component)((Object)this.list)));
        this.deleteAction = new DeleteInstancesAction((Selectable)this){

            protected void onAfterDelete(Object object) {
                InferredInstancesListPanel.this.refill();
            }
        };
        this.deleteAction.putValue("SmallIcon", (Object)OWLIcons.getDeleteIcon("RDFIndividual"));
        this.lc.addHeaderButton((Action)this.deleteAction);
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)((Object)this.lc));
        this.setSelectable(this.list);
    }

    public void dispose() {
    }

    private void refill() {
        HashSet hashSet = new HashSet();
        for (RDFSClass rDFSClass : this.types) {
            hashSet.addAll(rDFSClass.getInferredInstances(false));
        }
        ArrayList arrayList = new ArrayList(hashSet);
        Collections.sort(arrayList, new FrameComparator());
        this.list.setListData(arrayList.toArray());
    }

    public void setTypes(Collection collection) {
        this.types = collection;
        this.refill();
    }
}

