/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.dialogs;

import edu.stanford.smi.protege.ui.ParentChildRoot;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.LazyTreeRoot;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.cls.ClassNameTreeCellEditor;
import edu.stanford.smi.protegex.owl.ui.cls.ClassTree;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.search.ClassTreeFinder;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;

public class SelectClassPanel
extends SelectableContainer {
    private final ClassTree tree;
    private final OWLModel owlModel;
    private final Collection defaultRoots;
    private static final String SHOW_ALL = "Show all classes";
    private static final String SHOW_LIMITED = "Show sensible classes";

    public SelectClassPanel(OWLModel oWLModel, Collection collection, boolean bl, boolean bl2) {
        this.owlModel = oWLModel;
        this.defaultRoots = collection;
        this.tree = new ClassTree(null, (LazyTreeRoot)new ParentChildRoot(collection));
        this.setSelectable(this.tree);
        this.tree.setSelectionRow(0);
        this.tree.setLargeModel(true);
        this.tree.setAutoscrolls(true);
        this.tree.setEditable(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setCellRenderer((TreeCellRenderer)ResourceRenderer.createInstance());
        if (bl) {
            this.tree.getSelectionModel().setSelectionMode(2);
        } else {
            this.tree.getSelectionModel().setSelectionMode(1);
        }
        LabeledComponent labeledComponent = new LabeledComponent(null, new JScrollPane((Component)((Object)this.tree)));
        labeledComponent.setPreferredSize(new Dimension(400, 300));
        if (!collection.contains(oWLModel.getOWLThingClass())) {
            labeledComponent.addHeaderToggleButton((Action)new AbstractAction(SHOW_ALL, OWLIcons.getImageIcon("Top")){
                boolean showingAll;
                {
                    this.showingAll = false;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ParentChildRoot parentChildRoot = null;
                    JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
                    if (this.showingAll) {
                        parentChildRoot = new ParentChildRoot(SelectClassPanel.this.defaultRoots);
                        jToggleButton.setToolTipText(SelectClassPanel.SHOW_ALL);
                    } else {
                        OWLNamedClass oWLNamedClass = SelectClassPanel.this.owlModel.getOWLThingClass();
                        Set<OWLNamedClass> set = Collections.singleton(oWLNamedClass);
                        parentChildRoot = new ParentChildRoot(set);
                        jToggleButton.setToolTipText(SelectClassPanel.SHOW_LIMITED);
                    }
                    SelectClassPanel.this.tree.setRoot((LazyTreeRoot)parentChildRoot);
                    SelectClassPanel.this.tree.setSelectionRow(0);
                    this.showingAll = !this.showingAll;
                }
            });
            if (bl2) {
                labeledComponent.addHeaderSeparator();
            }
        }
        if (bl2) {
            this.tree.setCellEditor(new ClassNameTreeCellEditor());
            this.tree.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent focusEvent) {
                    SelectClassPanel.this.tree.stopEditing();
                }
            });
            labeledComponent.addHeaderButton((Action)((Object)new CreateSubclassAction(this.tree)));
            labeledComponent.addHeaderButton((Action)((Object)new CreateSiblingClassAction(this.tree)));
        }
        ClassTreeFinder classTreeFinder = new ClassTreeFinder(oWLModel, (JTree)((Object)this.tree));
        labeledComponent.add("South", (Component)((Object)classTreeFinder));
        this.add((Component)labeledComponent);
    }

    public Selectable getSelectable() {
        return this.tree;
    }

    public Collection getSelection() {
        return this.tree.getSelection();
    }

    class CreateSiblingClassAction
    extends AllowableAction {
        public CreateSiblingClassAction(ClassTree classTree) {
            super("Create Sibling Class", OWLIcons.getCreateIcon("SiblingClass"), (Selectable)classTree);
            this.onSelectionChange();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OWLNamedClass oWLNamedClass = (OWLNamedClass)CollectionUtilities.getFirstItem((Collection)this.getSelection());
            Collection collection = oWLNamedClass.getNamedSuperclasses();
            if (!collection.isEmpty()) {
                OWLModel oWLModel = oWLNamedClass.getOWLModel();
                try {
                    RDFSNamedClass rDFSNamedClass;
                    String string = oWLModel.createNewResourceName("Class");
                    oWLModel.beginTransaction("Create sibling of class " + oWLNamedClass.getBrowserText(), string);
                    RDFSClass rDFSClass = oWLNamedClass.getRDFType();
                    if (rDFSClass == null) {
                        rDFSClass = oWLNamedClass.getProtegeType();
                    }
                    if ((rDFSNamedClass = oWLModel.createRDFSNamedClass(string, collection, rDFSClass)) instanceof OWLNamedClass) {
                        for (RDFSNamedClass rDFSNamedClass2 : collection) {
                            ((OWLNamedClass)rDFSNamedClass).addInferredSuperclass(rDFSNamedClass2);
                        }
                    }
                    ClassTree classTree = (ClassTree)this.getSelectable();
                    OWLUI.selectResource(rDFSNamedClass, classTree);
                    int n = classTree.getSelectionRows()[0];
                    classTree.setEditable(true);
                    classTree.startEditingAtPath(classTree.getPathForRow(n));
                    oWLModel.commitTransaction();
                }
                catch (Exception exception) {
                    oWLModel.rollbackTransaction();
                    OWLUI.handleError(oWLModel, exception);
                }
            }
        }

        public void onSelectionChange() {
            RDFSClass rDFSClass = (RDFSClass)CollectionUtilities.getFirstItem((Collection)this.getSelection());
            ClassTree classTree = (ClassTree)this.getSelectable();
            LazyTreeRoot lazyTreeRoot = (LazyTreeRoot)classTree.getModel().getRoot();
            Collection collection = (Collection)lazyTreeRoot.getUserObject();
            this.setAllowed(rDFSClass instanceof RDFSNamedClass && !collection.contains(rDFSClass));
        }
    }

    class CreateSubclassAction
    extends AllowableAction {
        public CreateSubclassAction(ClassTree classTree) {
            super("Create Subclass", OWLIcons.getCreateIcon("SubClass"), (Selectable)classTree);
            this.onSelectionChange();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OWLNamedClass oWLNamedClass = (OWLNamedClass)CollectionUtilities.getFirstItem((Collection)this.getSelection());
            OWLModel oWLModel = oWLNamedClass.getOWLModel();
            try {
                String string = oWLModel.createNewResourceName("Class");
                oWLModel.beginTransaction("Create subclass of class " + oWLNamedClass.getBrowserText(), string);
                RDFSClass rDFSClass = oWLNamedClass.getRDFType();
                if (rDFSClass == null) {
                    rDFSClass = oWLNamedClass.getProtegeType();
                }
                RDFSNamedClass rDFSNamedClass = oWLModel.createRDFSNamedClass(string, Collections.singleton(oWLNamedClass), rDFSClass);
                ClassTree classTree = (ClassTree)this.getSelectable();
                OWLUI.selectResource(rDFSNamedClass, classTree);
                int n = classTree.getSelectionRows()[0];
                classTree.setEditable(true);
                classTree.startEditingAtPath(classTree.getPathForRow(n));
                oWLModel.commitTransaction();
            }
            catch (Exception exception) {
                oWLModel.rollbackTransaction();
                OWLUI.handleError(oWLModel, exception);
            }
        }

        public void onSelectionChange() {
            RDFSClass rDFSClass = (RDFSClass)CollectionUtilities.getFirstItem((Collection)this.getSelection());
            this.setAllowed(rDFSClass instanceof RDFSNamedClass);
        }
    }
}

