/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.conditions;

import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLCardinalityBase;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParseException;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParser;
import edu.stanford.smi.protegex.owl.model.event.ClassAdapter;
import edu.stanford.smi.protegex.owl.model.event.ClassListener;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLIntersectionClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.conditions.ConditionsTableConstants;
import edu.stanford.smi.protegex.owl.ui.conditions.ConditionsTableItem;
import edu.stanford.smi.protegex.owl.ui.conditions.OWLClassUtil;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTableModel;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.table.AbstractTableModel;

public class ConditionsTableModel
extends AbstractTableModel
implements ConditionsTableConstants,
OWLTableModel {
    private static final String SHOW_INHERITED_RESTRICTIONS = "restriction.show.inherited";
    private ClassListener classListener = new ClassAdapter(){

        public void subclassAdded(RDFSClass rDFSClass, RDFSClass rDFSClass2) {
            ConditionsTableModel.this.refill();
        }

        public void subclassRemoved(RDFSClass rDFSClass, RDFSClass rDFSClass2) {
            ConditionsTableModel.this.refill();
        }

        public void superclassAdded(RDFSClass rDFSClass, RDFSClass rDFSClass2) {
            ConditionsTableModel.this.refill();
        }

        public void superclassRemoved(RDFSClass rDFSClass, RDFSClass rDFSClass2) {
            ConditionsTableModel.this.refill();
        }
    };
    private FrameListener frameListener = new FrameAdapter(){

        public void ownSlotValueChanged(FrameEvent frameEvent) {
            if (frameEvent.getSlot().equals(ConditionsTableModel.this.superclassesSlot)) {
                ConditionsTableModel.this.refill();
            }
        }
    };
    private OWLNamedClass hostClass;
    private List<ConditionsTableItem> items = new ArrayList<ConditionsTableItem>();
    private Collection<RDFSClass> listenedToClses = new ArrayList<RDFSClass>();
    private OWLModel owlModel;
    public Cls previouslyEditedCls;
    private Slot superclassesSlot;
    private boolean inEditing = false;

    public ConditionsTableModel(OWLModel oWLModel) {
        this(oWLModel.getSlot(":DIRECT-SUPERCLASSES"));
    }

    public ConditionsTableModel(Slot slot) {
        this.superclassesSlot = slot;
        this.owlModel = (OWLModel)slot.getKnowledgeBase();
    }

    public ConditionsTableModel(OWLNamedClass oWLNamedClass, Slot slot) {
        this(slot);
        this.setCls(oWLNamedClass);
    }

    public int addEmptyDefinitionBlock() {
        int n = this.getType(0) + 1;
        ConditionsTableItem conditionsTableItem = ConditionsTableItem.createSeparator(n);
        int n2 = 0;
        this.items.add(n2, conditionsTableItem);
        this.fireTableRowsInserted(n2, n2);
        return n2;
    }

    public int addEmptyRow(int n) {
        ConditionsTableItem conditionsTableItem = ConditionsTableItem.createNew(this.getType(n));
        int n2 = n + 1;
        this.addItem(n2, conditionsTableItem);
        this.fireTableRowsInserted(n2, n2);
        return n2;
    }

    private void addItem(int n, ConditionsTableItem conditionsTableItem) {
        this.items.add(n, conditionsTableItem);
    }

    private void addItemUnlessOverloaded(RDFSClass rDFSClass, OWLNamedClass oWLNamedClass) {
        if (rDFSClass instanceof OWLRestriction) {
            RDFSClass rDFSClass2 = rDFSClass.getProtegeType();
            RDFProperty rDFProperty = ((OWLRestriction)rDFSClass).getOnProperty();
            if (rDFSClass instanceof OWLHasValue) {
                String string = rDFSClass.getBrowserText();
                for (ConditionsTableItem conditionsTableItem : this.items) {
                    if (conditionsTableItem.isSeparator() || !string.equals(conditionsTableItem.aClass.getBrowserText())) continue;
                    return;
                }
            } else if (rDFSClass instanceof OWLSomeValuesFrom) {
                OWLSomeValuesFrom oWLSomeValuesFrom = (OWLSomeValuesFrom)rDFSClass;
                if (oWLSomeValuesFrom.getFiller() instanceof RDFSClass) {
                    RDFSClass rDFSClass3 = (RDFSClass)oWLSomeValuesFrom.getFiller();
                    String string = rDFSClass.getBrowserText();
                    for (ConditionsTableItem conditionsTableItem : this.items) {
                        RDFSClass rDFSClass4;
                        if (conditionsTableItem.isSeparator() || !(conditionsTableItem.aClass instanceof OWLSomeValuesFrom)) continue;
                        if (string.equals(conditionsTableItem.aClass.getBrowserText())) {
                            return;
                        }
                        OWLSomeValuesFrom oWLSomeValuesFrom2 = (OWLSomeValuesFrom)conditionsTableItem.aClass;
                        if (!oWLSomeValuesFrom2.getOnProperty().equals(rDFProperty) || !(oWLSomeValuesFrom2.getFiller() instanceof RDFSClass) || !(rDFSClass4 = (RDFSClass)oWLSomeValuesFrom2.getFiller()).isSubclassOf(rDFSClass3)) continue;
                        return;
                    }
                }
            } else if (rDFSClass instanceof OWLAllValuesFrom && ((OWLAllValuesFrom)rDFSClass).getFiller() instanceof RDFSClass) {
                OWLAllValuesFrom oWLAllValuesFrom = (OWLAllValuesFrom)rDFSClass;
                OWLNamedClass oWLNamedClass2 = oWLAllValuesFrom.getOwner();
                for (ConditionsTableItem conditionsTableItem : this.items) {
                    if (conditionsTableItem.isSeparator() || !rDFSClass2.equals(conditionsTableItem.aClass.getProtegeType()) || !rDFProperty.equals(((OWLRestriction)conditionsTableItem.aClass).getOnProperty())) continue;
                    OWLAllValuesFrom oWLAllValuesFrom2 = (OWLAllValuesFrom)conditionsTableItem.aClass;
                    OWLNamedClass oWLNamedClass3 = oWLAllValuesFrom2.getOwner();
                    if (!((RDFSClass)oWLAllValuesFrom2.getFiller()).isSubclassOf((RDFSClass)oWLAllValuesFrom.getFiller()) || oWLNamedClass3.equals(oWLNamedClass2)) continue;
                    return;
                }
            } else {
                boolean bl = false;
                if (rDFSClass instanceof OWLCardinalityBase) {
                    OWLCardinalityBase oWLCardinalityBase = (OWLCardinalityBase)rDFSClass;
                    bl = oWLCardinalityBase.isQualified();
                }
                if (!bl) {
                    for (ConditionsTableItem conditionsTableItem : this.items) {
                        if (conditionsTableItem.isSeparator() || !rDFSClass2.equals(conditionsTableItem.aClass.getProtegeType()) || !rDFProperty.equals(((OWLRestriction)conditionsTableItem.aClass).getOnProperty())) continue;
                        return;
                    }
                }
            }
        }
        this.addInheritedSeparator();
        this.items.add(ConditionsTableItem.createInherited(rDFSClass, oWLNamedClass));
    }

    private void addInheritedSeparator() {
        for (ConditionsTableItem conditionsTableItem : this.items) {
            if (!conditionsTableItem.isSeparator() || conditionsTableItem.getType() != -2) continue;
            return;
        }
        this.items.add(ConditionsTableItem.createSeparator(-2));
    }

    public boolean addRow(RDFSClass rDFSClass, int n) {
        return this.addRowAllowMove(rDFSClass, n);
    }

    public boolean addRowAllowMove(RDFSClass rDFSClass, int n) {
        if (rDFSClass.equals(this.hostClass) || !this.isCreateEnabledAt(n) && rDFSClass instanceof OWLAnonymousClass || !this.isAddEnabledAt(n) && rDFSClass instanceof OWLNamedClass) {
            return false;
        }
        this.inEditing = true;
        boolean bl = this.handleAddRestriction(rDFSClass, n);
        this.inEditing = false;
        this.refill();
        return bl;
    }

    private boolean handleAddRestriction(RDFSClass rDFSClass, int n) {
        if (this.getType(n) == -1) {
            this.hostClass.addSuperclass(rDFSClass);
            if (this.isSeparator(n)) {
                ++n;
            }
            return true;
        }
        if (this.isDefinition(n)) {
            DefaultOWLIntersectionClass defaultOWLIntersectionClass;
            if (rDFSClass.equals(this.owlModel.getOWLThingClass())) {
                return false;
            }
            if (this.isSeparator(n)) {
                ++n;
            }
            if ((defaultOWLIntersectionClass = (DefaultOWLIntersectionClass)this.getDefinition(n)) != null) {
                String string = rDFSClass.getBrowserText();
                if (defaultOWLIntersectionClass.hasOperandWithBrowserText(string)) {
                    return false;
                }
                defaultOWLIntersectionClass.addOperand(rDFSClass);
                if (rDFSClass instanceof OWLNamedClass) {
                    this.hostClass.addDirectSuperclass(rDFSClass);
                }
            } else {
                RDFSClass rDFSClass2 = this.getClass(n);
                if (rDFSClass2 != null) {
                    RDFSClass rDFSClass3 = rDFSClass2;
                    if (rDFSClass2 instanceof OWLAnonymousClass) {
                        rDFSClass3 = rDFSClass2.createClone();
                    }
                    OWLIntersectionClass oWLIntersectionClass = this.owlModel.createOWLIntersectionClass();
                    oWLIntersectionClass.addOperand(rDFSClass3);
                    oWLIntersectionClass.addOperand(rDFSClass);
                    this.hostClass.addEquivalentClass(oWLIntersectionClass);
                    this.hostClass.removeEquivalentClass(rDFSClass2);
                    if (rDFSClass3 instanceof OWLNamedClass) {
                        this.hostClass.addDirectSuperclass(rDFSClass3);
                    }
                } else {
                    this.hostClass.addEquivalentClass(rDFSClass);
                }
            }
        }
        return true;
    }

    private boolean deleteDefinitionRow(int n) {
        if (!this.isDefinition(n)) {
            return false;
        }
        RDFSClass rDFSClass = this.getClass(n);
        OWLIntersectionClass oWLIntersectionClass = this.getDefinition(n);
        if (oWLIntersectionClass == null) {
            this.hostClass.removeEquivalentClass(rDFSClass);
            rDFSClass.addSuperclass(this.hostClass);
            return true;
        }
        ArrayList arrayList = new ArrayList(oWLIntersectionClass.getOperands());
        if (arrayList.size() == 2) {
            arrayList.remove(rDFSClass);
            RDFSClass rDFSClass2 = (RDFSClass)arrayList.iterator().next();
            RDFSClass rDFSClass3 = rDFSClass2.createClone();
            this.hostClass.addEquivalentClass(rDFSClass3);
            oWLIntersectionClass.delete();
        } else {
            oWLIntersectionClass.removeOperand(rDFSClass);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRow(int n) {
        try {
            OWLNamedClass oWLNamedClass = this.getEditedCls();
            this.owlModel.beginTransaction("Delete condition " + this.getClass(n).getBrowserText() + " from " + oWLNamedClass.getBrowserText(), oWLNamedClass.getName());
            this.inEditing = true;
            this.deleteRow(n, false);
            this.inEditing = false;
            this.owlModel.commitTransaction();
        }
        catch (Exception exception) {
            this.owlModel.rollbackTransaction();
            this.inEditing = false;
            OWLUI.handleError(this.owlModel, exception);
        }
        finally {
            this.refill();
        }
    }

    public void deleteRow(int n, boolean bl) {
        RDFSClass rDFSClass = this.getClass(n);
        boolean bl2 = this.getDefinition(n) != null;
        boolean bl3 = this.isDefinition(n);
        boolean bl4 = this.deleteDefinitionRow(n);
        if (!bl4 && bl3 && rDFSClass instanceof OWLNamedClass && bl) {
            rDFSClass.removeSuperclass(this.hostClass);
        } else if (this.hostClass.isSubclassOf(rDFSClass) && (!this.getNamedDefinitionClses(bl2).contains(rDFSClass) || bl)) {
            if (rDFSClass instanceof RDFSNamedClass) {
                this.hostClass.removeSuperclass(rDFSClass);
            } else {
                this.hostClass.removeSuperclass(rDFSClass);
            }
        }
        this.ensureHasOneNamedSuperclass(this.hostClass);
        if (rDFSClass instanceof RDFSNamedClass) {
            this.ensureHasOneNamedSuperclass((RDFSNamedClass)rDFSClass);
        }
    }

    public void displaySemanticError(String string) {
        ProtegeUI.getModalDialogFactory().showErrorMessageDialog(this.owlModel, string);
    }

    public void dispose() {
        if (this.hostClass != null) {
            this.hostClass.removeClassListener(this.classListener);
            this.hostClass.removeFrameListener(this.frameListener);
        }
        this.removeListeners();
    }

    public void dumpItems() {
        System.err.println("Items:");
        for (ConditionsTableItem conditionsTableItem : this.items) {
            System.err.println(" - " + conditionsTableItem + " (" + conditionsTableItem.getType() + ")");
        }
    }

    private void fillItems() {
        HashSet hashSet = new HashSet();
        int n = this.getEditedCls().getClassificationStatus();
        if (this.superclassesSlot.getName().equals(":DIRECT-SUPERCLASSES") || n != 0) {
            this.fillDefinitionItems(hashSet);
            this.fillDirectSuperclassItems(hashSet);
            String string = ApplicationProperties.getApplicationOrSystemProperty((String)SHOW_INHERITED_RESTRICTIONS, (String)"true");
            boolean bl = string.equals("true");
            if (bl) {
                this.fillInheritedItems(hashSet);
            }
            this.sortItems();
        }
    }

    private void fillDefinitionItems(Collection collection) {
        Slot slot = this.hostClass.getOWLModel().getSlot(":DIRECT-SUPERCLASSES");
        int n = 0;
        ConditionsTableItem conditionsTableItem = ConditionsTableItem.createSeparator(n);
        this.items.add(conditionsTableItem);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(conditionsTableItem);
        boolean bl = true;
        for (Cls cls : this.hostClass.getDirectOwnSlotValues(slot)) {
            Object object;
            if (!(cls instanceof RDFSClass) || !cls.getDirectOwnSlotValues(slot).contains(this.hostClass)) continue;
            if (!bl) {
                object = ConditionsTableItem.createSeparator(n);
                this.items.add((ConditionsTableItem)object);
                arrayList.add(object);
            }
            bl = false;
            object = (RDFSClass)cls;
            collection.add(object);
            if (object instanceof OWLIntersectionClass) {
                OWLIntersectionClass oWLIntersectionClass = (OWLIntersectionClass)object;
                Collection collection2 = ((OWLIntersectionClass)object).getOperands();
                for (RDFSClass rDFSClass : collection2) {
                    collection.add(rDFSClass);
                    this.items.add(ConditionsTableItem.createSufficient(rDFSClass, n, oWLIntersectionClass));
                }
            } else {
                this.items.add(ConditionsTableItem.create((RDFSClass)object, n));
            }
            ++n;
        }
        if (arrayList.size() > 1) {
            this.sortItems();
            this.sortSufficientBlocks(arrayList);
        }
    }

    private void fillDirectSuperclassItems(Collection collection) {
        RDFSClass rDFSClass;
        this.items.add(ConditionsTableItem.createSeparator(-1));
        for (Cls cls : this.hostClass.getDirectOwnSlotValues(this.superclassesSlot)) {
            if (!(cls instanceof RDFSNamedClass) || collection.contains(cls)) continue;
            rDFSClass = (RDFSClass)cls;
            collection.add(rDFSClass);
            this.items.add(ConditionsTableItem.create(rDFSClass, -1));
        }
        for (Cls cls : this.hostClass.getSuperclasses(false)) {
            if (!(cls instanceof OWLAnonymousClass) || collection.contains(cls)) continue;
            rDFSClass = (RDFSClass)cls;
            collection.add(rDFSClass);
            this.items.add(ConditionsTableItem.create(rDFSClass, -1));
        }
    }

    private void fillInheritedItems(Collection collection) {
        collection.removeAll(this.getNamedDefinitionClses(false));
        for (Cls cls : this.hostClass.getDirectOwnSlotValues(this.superclassesSlot)) {
            if (!(cls instanceof OWLNamedClass) || cls.equals(this.hostClass)) continue;
            OWLNamedClass oWLNamedClass = (OWLNamedClass)cls;
            this.fillInheritedItems(oWLNamedClass, collection);
            this.listenedToClses.add((RDFSClass)cls);
            oWLNamedClass.addClassListener(this.classListener);
            oWLNamedClass.addFrameListener(this.frameListener);
        }
    }

    private void fillInheritedItems(OWLNamedClass oWLNamedClass, Collection collection) {
        this.fillInheritedAnonymousClses(oWLNamedClass, collection);
        for (Cls cls : oWLNamedClass.getDirectOwnSlotValues(this.superclassesSlot)) {
            if (!(cls instanceof OWLNamedClass) || collection.contains(cls)) continue;
            collection.add(cls);
            this.fillInheritedItems((OWLNamedClass)cls, collection);
        }
    }

    private void fillInheritedAnonymousClses(OWLNamedClass oWLNamedClass, Collection collection) {
        for (Cls cls : oWLNamedClass.getSuperclasses(false)) {
            if (!(cls instanceof OWLAnonymousClass)) continue;
            if (cls instanceof OWLIntersectionClass) {
                Collection collection2 = ((OWLIntersectionClass)cls).getOperands();
                for (RDFSClass rDFSClass : collection2) {
                    if (!(rDFSClass instanceof OWLAnonymousClass)) continue;
                    this.addItemUnlessOverloaded(rDFSClass, oWLNamedClass);
                }
                continue;
            }
            if (collection.contains(cls)) continue;
            this.addItemUnlessOverloaded((OWLAnonymousClass)cls, oWLNamedClass);
        }
    }

    public int getBlockSize(int n) {
        int n2 = 0;
        int n3 = this.getType(n - 1);
        for (int i = n; i < this.items.size() && this.getItem(i).getType() == n3; ++i) {
            ++n2;
        }
        return n2;
    }

    public String getBlockText(int n) {
        int n2 = 0;
        while (this.isSeparator(n2) || this.getType(n2) != n) {
            ++n2;
        }
        String string = this.getClass(n2++).getBrowserText();
        while (n2 < this.getRowCount() && this.getType(n2) == n) {
            string = string + " & " + this.getClass(n2++).getBrowserText();
        }
        return string;
    }

    public int getClassRow(RDFSClass rDFSClass) {
        if (rDFSClass != null) {
            int n = 0;
            for (ConditionsTableItem conditionsTableItem : this.items) {
                if (conditionsTableItem != null && rDFSClass.equals(conditionsTableItem.aClass)) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public RDFSClass getClass(int n) {
        ConditionsTableItem conditionsTableItem = this.getItem(n);
        if (conditionsTableItem != null) {
            return conditionsTableItem.aClass;
        }
        return null;
    }

    public int getColumnCount() {
        return 1;
    }

    public Class getColumnClass(int n) {
        if (n == 0) {
            return String.class;
        }
        return null;
    }

    public OWLIntersectionClass getDefinition(int n) {
        return this.getItem(n).getDefinition();
    }

    public OWLNamedClass getEditedCls() {
        return this.hostClass;
    }

    public Icon getIcon(RDFResource rDFResource) {
        return ProtegeUI.getIcon(rDFResource);
    }

    public Icon getIcon(int n, int n2) {
        return this.getItem(n).getIcon(n2);
    }

    private ConditionsTableItem getItem(int n) {
        return this.items.get(n);
    }

    private Collection getNamedDefinitionClses(boolean bl) {
        HashSet<Cls> hashSet = new HashSet<Cls>();
        for (RDFSClass rDFSClass : this.hostClass.getEquivalentClasses()) {
            if (rDFSClass instanceof OWLIntersectionClass) {
                for (Cls cls : ((OWLIntersectionClass)rDFSClass).getOperands()) {
                    if (!(cls instanceof OWLNamedClass)) continue;
                    hashSet.add(cls);
                }
                continue;
            }
            if (!(rDFSClass instanceof OWLNamedClass) || !bl) continue;
            hashSet.add(rDFSClass);
        }
        return hashSet;
    }

    public OWLNamedClass getOriginClass(int n) {
        return this.getItem(n).getOriginCls();
    }

    public RDFProperty getPredicate(int n) {
        if (n == 0 || n >= 0 && this.isDefinition(n)) {
            return this.owlModel.getOWLEquivalentClassProperty();
        }
        return this.owlModel.getRDFSSubClassOfProperty();
    }

    public RDFResource getRDFResource(int n) {
        return this.getClass(n);
    }

    public RDFResource getSubject() {
        return this.hostClass;
    }

    public int getSymbolColumnIndex() {
        return 0;
    }

    public int getRowCount() {
        return this.items.size();
    }

    public int getType(int n) {
        ConditionsTableItem conditionsTableItem = this.getItem(n);
        if (conditionsTableItem != null) {
            return conditionsTableItem.getType();
        }
        return -1;
    }

    public Object getValueAt(int n, int n2) {
        ConditionsTableItem conditionsTableItem = this.getItem(n);
        if (n2 == 0) {
            return conditionsTableItem.toString();
        }
        return null;
    }

    private void handleDuplicateEntry(RDFSClass rDFSClass) {
        this.displaySemanticError("The class " + rDFSClass.getBrowserText() + " is already in the list.");
        if (rDFSClass instanceof OWLAnonymousClass) {
            rDFSClass.delete();
        }
    }

    public boolean isAddEnabledAt(int n) {
        if (!this.owlModel.getOWLThingClass().equals(this.getEditedCls())) {
            int n2 = this.getType(n);
            if (n2 == -1) {
                return true;
            }
            if (n2 != -2) {
                OWLIntersectionClass oWLIntersectionClass = this.getDefinition(n);
                if (oWLIntersectionClass != null) {
                    return oWLIntersectionClass.isEditable();
                }
                RDFSClass rDFSClass = this.getClass(n);
                if (rDFSClass == null) {
                    return this.isAddEnabledAt(n + 1);
                }
                return this.owlModel.getTripleStoreModel().isActiveTriple(this.getEditedCls(), this.owlModel.getOWLEquivalentClassProperty(), rDFSClass);
            }
        }
        return false;
    }

    public boolean isCellEditable(int n, int n2) {
        if (n2 == 0 && !this.isSeparator(n) && !this.getItem(n).isInherited() && this.superclassesSlot.getName().equals(":DIRECT-SUPERCLASSES")) {
            RDFSClass rDFSClass = this.getClass(n);
            if (rDFSClass == null) {
                return true;
            }
            if (this.isCreateEnabledAt(n)) {
                if (rDFSClass instanceof OWLAnonymousClass) {
                    return rDFSClass.isEditable();
                }
                return true;
            }
        }
        return false;
    }

    public boolean isCreateEnabledAt(int n) {
        if (this.isDefinition(n)) {
            OWLIntersectionClass oWLIntersectionClass = this.getDefinition(n);
            if (oWLIntersectionClass != null) {
                return oWLIntersectionClass.isEditable();
            }
            RDFSClass rDFSClass = this.getClass(n);
            if (rDFSClass == null) {
                return this.isCreateEnabledAt(n + 1);
            }
            return this.owlModel.getTripleStoreModel().isActiveTriple(this.getEditedCls(), this.owlModel.getOWLEquivalentClassProperty(), rDFSClass);
        }
        return this.getType(n) == -1;
    }

    public boolean isDeleteEnabledFor(RDFSClass rDFSClass) {
        int n = this.getClassRow(rDFSClass);
        if (rDFSClass instanceof OWLAnonymousClass) {
            if (!this.isSeparator(n)) {
                return this.isCellEditable(n, 0);
            }
            return false;
        }
        return this.isRemoveEnabledFor(n);
    }

    public boolean isDefinition(int n) {
        return this.getItem(n).isDefinition();
    }

    public boolean isEditable() {
        return this.hostClass.isEditable();
    }

    public boolean isRemoveEnabledFor(int n) {
        RDFSClass rDFSClass;
        if (!this.isSeparator(n) && (rDFSClass = this.getClass(n)) instanceof RDFSNamedClass) {
            HashSet hashSet;
            OWLClass oWLClass;
            if (this.getItem(n).isDefinition() && (oWLClass = this.getDefinition(n)) != null) {
                return oWLClass.isEditable();
            }
            oWLClass = this.getEditedCls();
            if ((this.owlModel.getTripleStoreModel().isEditableTriple(oWLClass, this.owlModel.getRDFSSubClassOfProperty(), rDFSClass) || this.owlModel.getTripleStoreModel().isEditableTriple(oWLClass, this.owlModel.getOWLEquivalentClassProperty(), rDFSClass)) && (hashSet = new HashSet(this.hostClass.getNamedSuperclasses())).contains(rDFSClass)) {
                hashSet.remove(rDFSClass);
                return hashSet.size() > 0 || !this.owlModel.getOWLThingClass().equals(rDFSClass);
            }
        }
        return false;
    }

    public boolean isSeparator(int n) {
        return this.getItem(n).isSeparator();
    }

    private void refill() {
        if (this.inEditing) {
            return;
        }
        this.items.clear();
        this.removeListeners();
        this.fillItems();
        this.fireTableDataChanged();
    }

    public void refresh() {
        if (this.inEditing) {
            return;
        }
        this.items.clear();
        if (this.hostClass != null) {
            this.fillItems();
            this.fireTableDataChanged();
        }
    }

    public void removeEmptyRow() {
        for (int i = this.getRowCount() - 1; i >= 0; --i) {
            if (!this.getItem(i).isNew()) continue;
            this.items.remove(i);
            this.fireTableRowsDeleted(i, i);
        }
    }

    private void removeListeners() {
        for (RDFSClass rDFSClass : this.listenedToClses) {
            rDFSClass.removeClassListener(this.classListener);
            rDFSClass.removeFrameListener(this.frameListener);
        }
        this.listenedToClses.clear();
    }

    private void replaceItemType(int n, int n2) {
        for (ConditionsTableItem conditionsTableItem : this.items) {
            if (conditionsTableItem.getType() != n) continue;
            conditionsTableItem.setType(n2);
        }
    }

    public void setCls(OWLNamedClass oWLNamedClass) {
        if (this.hostClass == null || !this.hostClass.equals(oWLNamedClass)) {
            if (this.hostClass != null) {
                this.hostClass.removeClassListener(this.classListener);
                this.hostClass.removeFrameListener(this.frameListener);
            }
            this.hostClass = oWLNamedClass;
            if (this.hostClass != null) {
                this.hostClass.addClassListener(this.classListener);
                this.hostClass.addFrameListener(this.frameListener);
            }
            this.refresh();
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n >= this.getRowCount()) {
            return;
        }
        if (n2 == 0) {
            String string = (String)object;
            OWLModel oWLModel = this.hostClass.getOWLModel();
            try {
                this.setValueAt(n, oWLModel, string);
            }
            catch (Exception exception) {
                Log.emptyCatchBlock((Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueAt(int n, OWLModel oWLModel, String string) throws Exception {
        RDFSClass rDFSClass = null;
        RDFSClass rDFSClass2 = this.getClass(n);
        try {
            oWLModel.beginTransaction("Set condition at " + this.getEditedCls().getBrowserText() + " to " + string, this.getEditedCls().getName());
            try {
                OWLClassParser oWLClassParser = oWLModel.getOWLClassDisplay().getParser();
                rDFSClass = oWLClassParser.parseClass(oWLModel, string);
                if (rDFSClass2 != null && rDFSClass != null && rDFSClass2.getBrowserText().equals(rDFSClass.getBrowserText()) || this.getEditedCls().equals(rDFSClass)) {
                    oWLModel.rollbackTransaction();
                    return;
                }
            }
            catch (OWLClassParseException oWLClassParseException) {
                oWLModel.rollbackTransaction();
                Log.getLogger().warning("Error at parsing restriction: " + string);
                ProtegeUI.getModalDialogFactory().showErrorMessageDialog(oWLModel, "Error at parsing restriction: " + string, "Parse Error");
                return;
            }
            this.inEditing = true;
            this.handleAddOrReplaceRestriction(rDFSClass, n);
            this.ensureHasOneNamedSuperclass(this.hostClass);
            if (rDFSClass2 instanceof RDFSNamedClass) {
                this.ensureHasOneNamedSuperclass((RDFSNamedClass)rDFSClass2);
            }
            this.inEditing = false;
            oWLModel.commitTransaction();
        }
        catch (Exception exception) {
            oWLModel.rollbackTransaction();
            this.inEditing = false;
            OWLUI.handleError(oWLModel, exception);
        }
        finally {
            this.refill();
        }
    }

    private boolean handleAddOrReplaceRestriction(RDFSClass rDFSClass, int n) {
        if (rDFSClass.equals(this.hostClass) || !this.isCreateEnabledAt(n) && rDFSClass instanceof OWLAnonymousClass || !this.isAddEnabledAt(n) && rDFSClass instanceof OWLNamedClass) {
            return false;
        }
        RDFSClass rDFSClass2 = this.getClass(n);
        if (this.getType(n) == -1) {
            this.hostClass.addSuperclass(rDFSClass);
            if (rDFSClass2 != null) {
                this.hostClass.removeSuperclass(rDFSClass2);
            }
            return true;
        }
        if (!this.isDefinition(n)) {
            return false;
        }
        if (rDFSClass.equals(this.owlModel.getOWLThingClass())) {
            return false;
        }
        OWLIntersectionClass oWLIntersectionClass = this.getDefinitionContext(n);
        if (oWLIntersectionClass != null) {
            if (rDFSClass2 != null) {
                if (rDFSClass2.getBrowserText().equals(rDFSClass.getBrowserText())) {
                    return false;
                }
                if (rDFSClass2.getBrowserText().equals(rDFSClass.getBrowserText())) {
                    return false;
                }
                boolean bl = OWLClassUtil.replaceOperand(oWLIntersectionClass, rDFSClass2, rDFSClass);
                if (bl) {
                    if (rDFSClass2 instanceof OWLAnonymousClass) {
                        this.deleteOldRestriction(rDFSClass2);
                    }
                    return true;
                }
                return false;
            }
            oWLIntersectionClass.addOperand(rDFSClass);
            if (rDFSClass instanceof OWLNamedClass) {
                this.hostClass.addDirectSuperclass(rDFSClass);
            }
            return true;
        }
        if (rDFSClass2 != null) {
            this.hostClass.addEquivalentClass(rDFSClass);
            this.hostClass.removeEquivalentClass(rDFSClass2);
            return true;
        }
        rDFSClass2 = this.getClassContext(n);
        if (rDFSClass2 == null) {
            this.hostClass.addEquivalentClass(rDFSClass);
            return true;
        }
        RDFSClass rDFSClass3 = rDFSClass2;
        if (rDFSClass2 instanceof OWLAnonymousClass) {
            rDFSClass3 = rDFSClass2.createClone();
        }
        OWLIntersectionClass oWLIntersectionClass2 = this.owlModel.createOWLIntersectionClass();
        oWLIntersectionClass2.addOperand(rDFSClass3);
        oWLIntersectionClass2.addOperand(rDFSClass);
        this.hostClass.addEquivalentClass(oWLIntersectionClass2);
        this.hostClass.removeEquivalentClass(rDFSClass2);
        if (rDFSClass3 instanceof OWLNamedClass) {
            this.hostClass.addDirectSuperclass(rDFSClass3);
        }
        return true;
    }

    private OWLIntersectionClass getDefinitionContext(int n) {
        OWLIntersectionClass oWLIntersectionClass = this.getDefinition(n);
        if (oWLIntersectionClass != null) {
            return oWLIntersectionClass;
        }
        if (n < this.items.size() && (oWLIntersectionClass = this.getDefinition(n + 1)) != null) {
            return oWLIntersectionClass;
        }
        if (n > 0) {
            oWLIntersectionClass = this.getDefinition(n - 1);
        }
        return oWLIntersectionClass;
    }

    private RDFSClass getClassContext(int n) {
        RDFSClass rDFSClass = this.getClass(n);
        if (rDFSClass != null) {
            return rDFSClass;
        }
        if (n < this.items.size() && (rDFSClass = this.getClass(n + 1)) != null) {
            return rDFSClass;
        }
        if (n > 0) {
            rDFSClass = this.getClass(n - 1);
        }
        return rDFSClass;
    }

    private void deleteOldRestriction(RDFSClass rDFSClass) {
        rDFSClass.delete();
    }

    private void sortItems() {
        Collections.sort(this.items);
    }

    private void sortSufficientBlocks(List list) {
        boolean bl = false;
        do {
            bl = false;
            for (int i = 0; i < list.size() - 1; ++i) {
                ConditionsTableItem conditionsTableItem;
                int n;
                ConditionsTableItem conditionsTableItem2;
                ConditionsTableItem conditionsTableItem3 = (ConditionsTableItem)list.get(i);
                int n2 = this.items.indexOf(conditionsTableItem3);
                ConditionsTableItem conditionsTableItem4 = this.getItem(n2 + 1);
                if (conditionsTableItem4.compareToWithSameType((conditionsTableItem2 = this.getItem((n = this.items.indexOf(conditionsTableItem = (ConditionsTableItem)list.get(i + 1))) + 1)).getCls()) >= 0) continue;
                bl = true;
                this.swapBlocks(conditionsTableItem3, conditionsTableItem);
                list.remove(conditionsTableItem);
                list.add(i, conditionsTableItem);
            }
        } while (bl);
    }

    private void swapBlocks(ConditionsTableItem conditionsTableItem, ConditionsTableItem conditionsTableItem2) {
        int n = conditionsTableItem.getType();
        int n2 = conditionsTableItem2.getType();
        this.replaceItemType(n, -10);
        this.replaceItemType(n2, n);
        this.replaceItemType(-10, n2);
        this.sortItems();
    }

    private void ensureHasOneNamedSuperclass(RDFSNamedClass rDFSNamedClass) {
        OWLNamedClass oWLNamedClass = this.owlModel.getOWLThingClass();
        if (rDFSNamedClass.equals(oWLNamedClass)) {
            return;
        }
        Collection collection = rDFSNamedClass.getSuperclasses(true);
        if (!collection.contains(oWLNamedClass)) {
            rDFSNamedClass.addSuperclass(oWLNamedClass);
            return;
        }
        Collection collection2 = rDFSNamedClass.getSuperclasses(false);
        for (Cls cls : collection2) {
            if (!(cls instanceof RDFSNamedClass) || cls.equals(rDFSNamedClass)) continue;
            return;
        }
        rDFSNamedClass.addSuperclass(this.owlModel.getOWLThingClass());
    }
}

