/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.conditions;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceAction;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.ResourceDisplay;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class AddCoveringAxiomAction
extends ResourceAction {
    public AddCoveringAxiomAction() {
        super("Add covering axiom", OWLIcons.getImageIcon("OWLUnionClass"), "Edit", true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        OWLNamedClass oWLNamedClass = (OWLNamedClass)this.getResource();
        if (this.isSuitable(this.getComponent(), oWLNamedClass)) {
            AddCoveringAxiomAction.performAction(oWLNamedClass);
        }
    }

    private Set getOperandsStringSet(Iterator iterator) {
        HashSet<String> hashSet = new HashSet<String>();
        while (iterator.hasNext()) {
            RDFSClass rDFSClass = (RDFSClass)iterator.next();
            hashSet.add(rDFSClass.getBrowserText());
        }
        return hashSet;
    }

    private static List getPureSubclasses(OWLNamedClass oWLNamedClass) {
        Collection collection = oWLNamedClass.getSubclasses(false);
        ArrayList arrayList = new ArrayList(collection);
        arrayList.removeAll(oWLNamedClass.getEquivalentClasses());
        return arrayList;
    }

    public boolean isSuitable(Component component, RDFResource rDFResource) {
        OWLNamedClass oWLNamedClass;
        List list;
        if (component instanceof ResourceDisplay && rDFResource instanceof OWLNamedClass && !rDFResource.isSystem() && (list = AddCoveringAxiomAction.getPureSubclasses(oWLNamedClass = (OWLNamedClass)rDFResource)).size() > 1) {
            Set set = this.getOperandsStringSet(list.iterator());
            for (RDFSClass rDFSClass : oWLNamedClass.getEquivalentClasses()) {
                Iterator iterator;
                Set set2;
                if (!(rDFSClass instanceof OWLUnionClass) || !((Object)set).equals(set2 = this.getOperandsStringSet(iterator = ((OWLUnionClass)rDFSClass).getOperands().iterator()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static void performAction(OWLNamedClass oWLNamedClass) {
        List list = AddCoveringAxiomAction.getPureSubclasses(oWLNamedClass);
        if (list.size() > 1) {
            OWLModel oWLModel = oWLNamedClass.getOWLModel();
            try {
                oWLModel.beginTransaction("Add covering axiom for " + oWLNamedClass.getBrowserText(), oWLNamedClass.getName());
                OWLUnionClass oWLUnionClass = oWLNamedClass.getOWLModel().createOWLUnionClass();
                for (RDFSClass rDFSClass : list) {
                    RDFSClass rDFSClass2 = rDFSClass.createClone();
                    oWLUnionClass.addOperand(rDFSClass2);
                }
                oWLNamedClass.addEquivalentClass(oWLUnionClass);
                oWLModel.commitTransaction();
            }
            catch (Exception exception) {
                oWLModel.rollbackTransaction();
                OWLUI.handleError(oWLModel, exception);
            }
        } else {
            ProtegeUI.getModalDialogFactory().showErrorMessageDialog(oWLNamedClass.getOWLModel(), "The class " + oWLNamedClass.getBrowserText() + " has less than 2 pure subclasses.");
        }
    }
}

