/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.triples;

import com.hp.hpl.jena.datatypes.xsd.impl.XMLLiteralType;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueAdapter;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueListener;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFSLiteral;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.actions.triple.DeleteTripleAction;
import edu.stanford.smi.protegex.owl.ui.components.triples.TriplesComponent;
import edu.stanford.smi.protegex.owl.ui.components.triples.TriplesTable;
import edu.stanford.smi.protegex.owl.ui.metadata.AnnotationsWidgetPlugin;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class TriplesTableModel
extends AbstractTableModel {
    private ArrayList properties = new ArrayList();
    private RDFResource subject;
    private JTable table;
    private PropertyValueListener valueListener = new PropertyValueAdapter(){

        public void propertyValueChanged(RDFResource rDFResource, RDFProperty rDFProperty, Collection collection) {
            if (TriplesTableModel.this.isRelevantProperty(rDFProperty)) {
                TriplesTableModel.this.updateValues();
            }
        }
    };
    private ArrayList values = new ArrayList();
    public static final int COL_PROPERTY = 0;
    public static final int COL_VALUE = 1;

    public TriplesTableModel() {
    }

    public TriplesTableModel(RDFResource rDFResource) {
        this.subject = rDFResource;
        if (rDFResource != null) {
            rDFResource.addPropertyValueListener(this.valueListener);
        }
        this.refill();
    }

    public int addRow(RDFProperty rDFProperty) {
        Object object = this.createDefaultValue(rDFProperty);
        if (object != null) {
            return this.addRow(rDFProperty, object);
        }
        return -1;
    }

    public int addRow(RDFProperty rDFProperty, Object object) {
        if (!this.subject.hasPropertyValue(rDFProperty, object)) {
            this.subject.addPropertyValue(rDFProperty, object);
        }
        return this.getPropertyValueRow(rDFProperty, object);
    }

    private Object createDefaultValue(RDFProperty rDFProperty) {
        Object object;
        Object object2;
        Object object3 = TriplesComponent.plugins();
        while (object3.hasNext()) {
            object2 = (AnnotationsWidgetPlugin)object3.next();
            if (!object2.canEdit(this.subject, rDFProperty, null) || (object = object2.createDefaultValue(this.subject, rDFProperty)) == null) continue;
            return object;
        }
        object3 = rDFProperty.getRange();
        if (object3 instanceof RDFSDatatype) {
            return ((RDFSDatatype)object3).getDefaultValue();
        }
        if (object3 instanceof OWLDataRange) {
            List list;
            object2 = (OWLDataRange)object3;
            object = object2.getOneOf();
            Object var5_5 = null;
            if (object != null && !(list = object.getValues()).isEmpty()) {
                var5_5 = list.iterator().next();
            }
            return var5_5;
        }
        if (rDFProperty instanceof OWLObjectProperty) {
            return null;
        }
        return "";
    }

    private Object createNewValue(RDFProperty rDFProperty, String string, String string2) {
        Object object = null;
        object = string2 == null || string2.trim().length() == 0 ? string : rDFProperty.getOWLModel().createRDFSLiteralOrString(string, string2);
        return object;
    }

    public void deleteRow(int n) {
        RDFProperty rDFProperty = this.getPredicate(n);
        Object object = this.getValue(n);
        this.subject.removePropertyValue(rDFProperty, object);
    }

    public void dispose() {
        if (this.subject != null) {
            this.subject.removePropertyValueListener(this.valueListener);
        }
    }

    public Class getColumnClass(int n) {
        if (n == 0) {
            return RDFProperty.class;
        }
        if (n == 1) {
            return Object.class;
        }
        if (this.hasTypeColumn() && n == 2) {
            return RDFResource.class;
        }
        return String.class;
    }

    public int getColumnCount() {
        return this.hasTypeColumn() ? 4 : 3;
    }

    public String getColumnName(int n) {
        if (n == 0) {
            return "Property";
        }
        if (n == 1) {
            return "Value";
        }
        if (this.isTypeColumn(n)) {
            return "Type";
        }
        return "Lang";
    }

    public Object getDisplayValue(int n) {
        Object e = this.values.get(n);
        if (e instanceof RDFSLiteral) {
            return ((RDFSLiteral)e).getString();
        }
        return e;
    }

    public String getLanguage(int n) {
        Object object = this.getValue(n);
        if (object instanceof RDFSLiteral) {
            return ((RDFSLiteral)object).getLanguage();
        }
        return null;
    }

    public OWLModel getOWLModel() {
        return this.subject.getOWLModel();
    }

    public RDFProperty getPredicate(int n) {
        return (RDFProperty)this.properties.get(n);
    }

    public int getPropertyValueRow(RDFProperty rDFProperty, Object object) {
        for (int i = 0; i < this.properties.size(); ++i) {
            RDFProperty rDFProperty2 = this.getPredicate(i);
            if (!rDFProperty2.equals(rDFProperty)) continue;
            if (object == null && this.getValue(i) == null) {
                return i;
            }
            if (object == null || !object.equals(this.getValue(i))) continue;
            return i;
        }
        return -1;
    }

    protected Collection getRelevantProperties() {
        OWLModel oWLModel = this.subject.getOWLModel();
        HashSet<RDFProperty> hashSet = new HashSet<RDFProperty>();
        for (RDFProperty rDFProperty : oWLModel.getRDFProperties()) {
            if (!rDFProperty.isVisible()) continue;
            hashSet.add(rDFProperty);
        }
        hashSet.add(oWLModel.getRDFSIsDefinedByProperty());
        hashSet.add(oWLModel.getRDFSLabelProperty());
        hashSet.add(oWLModel.getRDFProperty("rdfs:seeAlso"));
        hashSet.add(oWLModel.getOWLSameAsProperty());
        hashSet.add(oWLModel.getOWLEquivalentPropertyProperty());
        hashSet.add(oWLModel.getOWLDifferentFromProperty());
        hashSet.add(oWLModel.getOWLVersionInfoProperty());
        if (!(this.subject instanceof RDFProperty)) {
            hashSet.remove(oWLModel.getRDFSSubPropertyOfProperty());
        }
        return hashSet;
    }

    public int getRowCount() {
        return this.properties.size();
    }

    public RDFResource getSubject() {
        return this.subject;
    }

    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return this.getPredicate(n);
        }
        if (n2 == 1) {
            return this.getDisplayValue(n);
        }
        if (this.isTypeColumn(n2)) {
            Object object = this.getValue(n);
            if (object instanceof RDFResource) {
                return ((RDFResource)object).getRDFType();
            }
            if (object instanceof RDFSLiteral) {
                return ((RDFSLiteral)object).getDatatype();
            }
            RDFSLiteral rDFSLiteral = DefaultRDFSLiteral.create(this.getOWLModel(), object);
            return rDFSLiteral.getDatatype();
        }
        return this.getLanguage(n);
    }

    public Object getValue(int n) {
        return this.values.get(n);
    }

    protected boolean hasTypeColumn() {
        return true;
    }

    public boolean isCellEditable(int n, int n2) {
        if (n2 != 0) {
            RDFProperty rDFProperty = this.getPredicate(n);
            if (n2 == 1) {
                Object object = this.getValue(n);
                Object object2 = TriplesComponent.plugins();
                while (object2.hasNext()) {
                    AnnotationsWidgetPlugin annotationsWidgetPlugin = (AnnotationsWidgetPlugin)object2.next();
                    if (!annotationsWidgetPlugin.canEdit(this.subject, rDFProperty, object)) continue;
                    return false;
                }
                object2 = rDFProperty.getOWLModel();
                return (rDFProperty instanceof OWLDatatypeProperty || rDFProperty.isAnnotationProperty() && !(object instanceof Instance)) && !rDFProperty.isReadOnly() && object2.getTripleStoreModel().isActiveTriple(this.subject, rDFProperty, object) || this.getDefaultProperties().contains(rDFProperty) && object == null;
            }
            if (this.isTypeColumn(n2)) {
                return this.getValueAt(n, n2) instanceof RDFSDatatype;
            }
            return rDFProperty instanceof OWLDatatypeProperty && rDFProperty.getOWLModel().getXSDstring().equals(rDFProperty.getRange()) && !rDFProperty.isReadOnly();
        }
        return false;
    }

    public boolean isDeleteEnabled(int n) {
        RDFProperty rDFProperty = this.getPredicate(n);
        Object object = this.getValue(n);
        return DeleteTripleAction.isSuitable(this.subject, rDFProperty, object);
    }

    public static boolean isInvalidXMLLiteral(RDFProperty rDFProperty, Object object) {
        if (XMLSchemaDatatypes.isXMLLiteralSlot(rDFProperty) && object instanceof String && !XMLLiteralType.theXMLLiteralType.isValid((String)object)) {
            ProtegeUI.getModalDialogFactory().showErrorMessageDialog(rDFProperty.getOWLModel(), "This value is not a valid XML literal:\n" + object);
            return true;
        }
        return false;
    }

    protected boolean isRelevantProperty(RDFProperty rDFProperty) {
        return true;
    }

    private boolean isTypeColumn(int n) {
        return this.hasTypeColumn() && n == 2;
    }

    private void refill() {
        if (this.subject != null) {
            Collection collection = this.getRelevantProperties();
            RDFProperty[] rDFPropertyArray = collection.toArray(new RDFProperty[0]);
            Arrays.sort(rDFPropertyArray, new FrameComparator());
            for (int i = 0; i < rDFPropertyArray.length; ++i) {
                RDFProperty rDFProperty = rDFPropertyArray[i];
                Collection collection2 = this.subject.getPropertyValues(rDFProperty);
                for (Object e : collection2) {
                    this.properties.add(rDFProperty);
                    this.values.add(e);
                }
            }
            for (RDFProperty rDFProperty : this.getDefaultProperties()) {
                if (this.properties.contains(rDFProperty)) continue;
                this.properties.add(0, rDFProperty);
                this.values.add(0, null);
            }
        }
    }

    private void setDatatype(int n, RDFSDatatype rDFSDatatype) {
        Object object = this.getValue(n);
        String string = object.toString();
        RDFSLiteral rDFSLiteral = rDFSDatatype.getOWLModel().createRDFSLiteral(string, rDFSDatatype);
        RDFProperty rDFProperty = this.getPredicate(n);
        this.subject.removePropertyValue(rDFProperty, object);
        this.subject.addPropertyValue(rDFProperty, rDFSLiteral);
    }

    private Object setLanguage(int n, String string) {
        RDFProperty rDFProperty = this.getPredicate(n);
        String string2 = (String)this.getDisplayValue(n);
        Object object = this.createNewValue(rDFProperty, string2, string);
        if (!this.subject.getPropertyValues(rDFProperty).contains(object)) {
            Object object2 = this.getValue(n);
            this.subject.removePropertyValue(rDFProperty, object2);
            this.subject.addPropertyValue(rDFProperty, object);
        }
        return object;
    }

    public void setSubject(RDFResource rDFResource) {
        RDFResource rDFResource2 = this.subject;
        if (rDFResource2 != null) {
            rDFResource2.removePropertyValueListener(this.valueListener);
        }
        this.subject = rDFResource;
        this.properties.clear();
        this.values.clear();
        if (rDFResource != null) {
            rDFResource.addPropertyValueListener(this.valueListener);
            this.refill();
        }
        this.fireTableDataChanged();
    }

    public Object setValue(Object object, int n) {
        RDFProperty rDFProperty = this.getPredicate(n);
        Object object2 = this.getValue(n);
        if (object2 == null || !object2.equals(object)) {
            RDFResource rDFResource = rDFProperty.getRange();
            try {
                Object object3;
                String string;
                String string2 = object.toString();
                OWLModel oWLModel = rDFProperty.getOWLModel();
                if (oWLModel.getOWLOntologyProperties().contains(rDFProperty)) {
                    string = string2 + " is not a valid URI.";
                    try {
                        new URI(string2);
                    }
                    catch (Exception exception) {
                        ProtegeUI.getModalDialogFactory().showErrorMessageDialog(oWLModel, string);
                        return object2;
                    }
                    if (!string2.startsWith("http://") && !string2.startsWith("file:")) {
                        ProtegeUI.getModalDialogFactory().showErrorMessageDialog(oWLModel, string);
                        return object2;
                    }
                }
                string = this.getLanguage(n);
                if (object instanceof RDFSLiteral && ((RDFSLiteral)object).getLanguage() != null) {
                    object3 = object;
                } else if (string != null) {
                    object3 = this.createNewValue(rDFProperty, string2, string);
                } else if (object2 instanceof RDFSLiteral) {
                    RDFSLiteral rDFSLiteral = (RDFSLiteral)object2;
                    object3 = this.getOWLModel().createRDFSLiteral(string2, rDFSLiteral.getDatatype());
                } else {
                    object3 = object2 instanceof Boolean ? Boolean.valueOf(string2.equals("true")) : (object2 instanceof Float ? Float.valueOf(string2) : (object2 instanceof Integer ? Integer.valueOf(string2) : string2));
                }
                if (!this.subject.getPropertyValues(rDFProperty).contains(object3)) {
                    this.subject.removePropertyValue(rDFProperty, object2);
                    this.subject.addPropertyValue(rDFProperty, object3);
                }
                return object3;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return object2;
    }

    public void setValueAt(Object object, int n, int n2) {
        this.setValueAndGetIt(object, n, n2);
    }

    public Object setValueAndGetIt(Object object, int n, int n2) {
        if (n2 == 0) {
            return null;
        }
        if (n2 == 1) {
            return this.setValue(object, n);
        }
        if (this.isTypeColumn(n2)) {
            if (object instanceof RDFSDatatype) {
                RDFSDatatype rDFSDatatype = (RDFSDatatype)object;
                this.setDatatype(n, rDFSDatatype);
                return rDFSDatatype;
            }
            return null;
        }
        return this.setLanguage(n, (String)object);
    }

    void updateValues() {
        int n = -1;
        if (this.table != null) {
            n = this.table.getSelectedRow();
        }
        this.properties.clear();
        this.values.clear();
        this.refill();
        this.fireTableDataChanged();
        if (this.table != null && n >= 0 && n < this.getRowCount()) {
            this.table.getSelectionModel().setSelectionInterval(n, n);
        }
    }

    public void setTable(TriplesTable triplesTable) {
        this.table = triplesTable;
    }

    public Collection getDefaultProperties() {
        return Collections.EMPTY_LIST;
    }
}

