/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.singleresource;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.PopupMenuMouseListener;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFUntypedResource;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueAdapter;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueListener;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceActionManager;
import edu.stanford.smi.protegex.owl.ui.components.AbstractPropertyValuesComponent;
import edu.stanford.smi.protegex.owl.ui.components.singleresource.SetResourceAction;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;

public class SingleResourceComponent
extends AbstractPropertyValuesComponent
implements Disposable {
    private PropertyValueListener browserTextListener = new PropertyValueAdapter(){

        public void browserTextChanged(RDFResource rDFResource) {
            SingleResourceComponent.this.list.repaint();
        }
    };
    private Action createAction = new AbstractAction("Create resource", OWLIcons.getCreateIndividualIcon("RDFIndividual")){

        public void actionPerformed(ActionEvent actionEvent) {
            SingleResourceComponent.this.handleCreate();
        }
    };
    private JList list;
    private Action removeAction = new AbstractAction("Remove current value", OWLIcons.getRemoveIcon("RDFIndividual")){

        public void actionPerformed(ActionEvent actionEvent) {
            SingleResourceComponent.this.handleRemove();
        }
    };
    private RDFResource resource;
    private Action setAction = new SetResourceAction(this);

    public SingleResourceComponent(RDFProperty rDFProperty) {
        this(rDFProperty, null);
    }

    public SingleResourceComponent(RDFProperty rDFProperty, String string) {
        this(rDFProperty, string, false);
    }

    public SingleResourceComponent(RDFProperty rDFProperty, String string, boolean bl) {
        super(rDFProperty, string, bl);
        this.list = ComponentFactory.createSingleItemList((Action)new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SingleResourceComponent.this.handleDoubleClick();
            }
        });
        this.list.setCellRenderer(FrameRenderer.createInstance());
        this.list.addMouseListener((MouseListener)new PopupMenuMouseListener(this.list){

            protected JPopupMenu getPopupMenu() {
                return SingleResourceComponent.this.createPopupMenu();
            }

            protected void setSelection(JComponent jComponent, int n, int n2) {
            }
        });
        OWLLabeledComponent oWLLabeledComponent = new OWLLabeledComponent(string == null ? this.getLabel() : string, this.list);
        oWLLabeledComponent.addHeaderButton(this.createAction);
        oWLLabeledComponent.addHeaderButton(this.setAction);
        oWLLabeledComponent.addHeaderButton(this.removeAction);
        this.add("Center", (Component)((Object)oWLLabeledComponent));
    }

    static boolean containsAnonymousClass(Collection collection) {
        for (Cls cls : collection) {
            if (!(cls instanceof OWLAnonymousClass)) continue;
            return true;
        }
        return false;
    }

    protected JPopupMenu createPopupMenu() {
        if (this.resource != null) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            ResourceActionManager.addResourceActions(jPopupMenu, (Component)this, this.resource);
            if (jPopupMenu.getComponentCount() > 0) {
                return jPopupMenu;
            }
        }
        return null;
    }

    public void dispose() {
        this.removeBrowserTextListener();
    }

    public RDFResource getResource() {
        return this.resource;
    }

    protected void handleCreate() {
        OWLModel oWLModel = this.getOWLModel();
        RDFSNamedClass rDFSNamedClass = (RDFSNamedClass)this.getSubjectType();
        ArrayList<RDFSNamedClass> arrayList = new ArrayList<RDFSNamedClass>(rDFSNamedClass.getUnionRangeClasses(this.getPredicate()));
        if (SingleResourceComponent.containsAnonymousClass(arrayList)) {
            arrayList.clear();
        }
        if (arrayList.isEmpty()) {
            arrayList.add(oWLModel.getOWLThingClass());
        } else if (OWLUI.isExternalResourcesSupported(oWLModel)) {
            arrayList.add(oWLModel.getRDFUntypedResourcesClass());
        }
        if (OWLUI.isExternalResourcesSupported(oWLModel)) {
            oWLModel.getRDFUntypedResourcesClass().setVisible(true);
        }
        RDFSNamedClass rDFSNamedClass2 = ProtegeUI.getSelectionDialogFactory().selectClass((Component)this, oWLModel, arrayList, "Select type of new resource...");
        oWLModel.getRDFUntypedResourcesClass().setVisible(false);
        if (rDFSNamedClass2 != null) {
            RDFSClass rDFSClass;
            Instance instance = oWLModel.createInstance(null, rDFSNamedClass2);
            if (instance instanceof RDFUntypedResource) {
                OWLUtil.assignUniqueURI((RDFUntypedResource)instance);
            } else if (instance instanceof RDFSClass && (rDFSClass = (RDFSClass)instance).getSuperclassCount() == 0) {
                rDFSClass.addSuperclass(oWLModel.getOWLThingClass());
            }
            if (instance instanceof RDFResource) {
                this.showResource((RDFResource)instance);
            }
            this.getSubject().setPropertyValue(this.getPredicate(), instance);
        }
    }

    protected void handleDoubleClick() {
        if (this.resource != null) {
            this.getOWLModel().getProject().show((Instance)this.resource);
        }
    }

    protected void handleRemove() {
        this.getSubject().setPropertyValue(this.getPredicate(), null);
    }

    public boolean isCreateEnabled() {
        return !this.isEnumerationProperty() && this.isSetEnabled();
    }

    public boolean isRemoveEnabled() {
        if (!this.hasHasValueRestriction()) {
            return this.getObject() != null && this.hasOnlyEditableValues();
        }
        return false;
    }

    public boolean isSetEnabled() {
        return !this.hasHasValueRestriction() && this.hasOnlyEditableValues();
    }

    private void removeBrowserTextListener() {
        if (this.resource != null) {
            this.resource.removePropertyValueListener(this.browserTextListener);
        }
    }

    private void updateActions() {
        boolean bl = !this.isReadOnly();
        this.createAction.setEnabled(bl && this.isCreateEnabled());
        this.setAction.setEnabled(bl && this.isSetEnabled());
        this.removeAction.setEnabled(bl && this.isRemoveEnabled());
    }

    private void updateList() {
        ComponentUtilities.setListValues((JList)this.list, (Collection)CollectionUtilities.createCollection((Object)this.resource));
    }

    public void valuesChanged() {
        Collection collection;
        this.removeBrowserTextListener();
        Object object = this.getSubject().getPropertyValue(this.getPredicate(), true);
        if (object == null && !(collection = this.getSubject().getHasValuesOnTypes(this.getPredicate())).isEmpty()) {
            object = collection.iterator().next();
        }
        if (object instanceof RDFResource) {
            this.resource = (RDFResource)object;
            this.resource.addPropertyValueListener(this.browserTextListener);
        } else {
            this.resource = null;
        }
        this.updateActions();
        this.updateList();
    }
}

