/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.singleliteral;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFSLiteral;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.components.AbstractPropertyValuesComponent;
import edu.stanford.smi.protegex.owl.ui.components.ComponentUtil;
import edu.stanford.smi.protegex.owl.ui.editors.PropertyValueEditor;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.JTextComponent;

public abstract class AbstractSingleLiteralComponent
extends AbstractPropertyValuesComponent {
    private JComboBox booleanComboBox;
    private JComboBox datatypeComboBox;
    private Action deleteAction = new AbstractAction("Delete value", OWLIcons.getDeleteIcon()){

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractSingleLiteralComponent.this.handleDeleteAction();
        }
    };
    private JPanel mainPanel;
    private JTextComponent textComponent;
    private Component textComponentHolder;
    private static final String UNDEFINED = "undefined";
    private Action viewAction = new AbstractAction("View/edit value...", OWLIcons.getViewIcon()){

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractSingleLiteralComponent.this.handleViewAction();
        }
    };

    public AbstractSingleLiteralComponent(RDFProperty rDFProperty) {
        this(rDFProperty, null);
    }

    public AbstractSingleLiteralComponent(RDFProperty rDFProperty, String string) {
        this(rDFProperty, string, false);
    }

    public AbstractSingleLiteralComponent(RDFProperty rDFProperty, String string, boolean bl) {
        super(rDFProperty, string, bl);
        OWLModel oWLModel = this.getOWLModel();
        this.datatypeComboBox = ComponentUtil.createDatatypeComboBox(oWLModel);
        int n = this.datatypeComboBox.getPreferredSize().height;
        this.datatypeComboBox.setPreferredSize(new Dimension(80, n));
        this.datatypeComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractSingleLiteralComponent.this.assignTextFieldValue();
                AbstractSingleLiteralComponent.this.updateTextFieldAlignment((RDFSDatatype)AbstractSingleLiteralComponent.this.datatypeComboBox.getSelectedItem());
            }
        });
        this.booleanComboBox = new JComboBox<Object>(new Object[]{UNDEFINED, Boolean.FALSE, Boolean.TRUE});
        this.booleanComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractSingleLiteralComponent.this.assignBooleanComboBoxValue();
            }
        });
        this.textComponent = this.createTextComponent();
        this.textComponent.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                AbstractSingleLiteralComponent.this.assignTextFieldValue();
            }
        });
        this.textComponent.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    AbstractSingleLiteralComponent.this.assignTextFieldValue();
                }
            }
        });
        OWLUI.addCopyPastePopup(this.textComponent);
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add("East", this.datatypeComboBox);
        this.textComponentHolder = this.createTextComponentHolder(this.textComponent);
        this.mainPanel.add("Center", this.textComponentHolder);
        OWLLabeledComponent oWLLabeledComponent = new OWLLabeledComponent(string == null ? this.getLabel() : string, this.mainPanel);
        oWLLabeledComponent.addHeaderButton(this.viewAction);
        oWLLabeledComponent.addHeaderButton(this.deleteAction);
        if (this.textComponentHolder instanceof JScrollPane) {
            oWLLabeledComponent.setVerticallyStretchable(true);
        }
        this.add((Component)((Object)oWLLabeledComponent));
    }

    protected abstract JTextComponent createTextComponent();

    protected abstract Component createTextComponentHolder(JTextComponent var1);

    private void assignBooleanComboBoxValue() {
        Object object = this.booleanComboBox.getSelectedItem();
        if (UNDEFINED.equals(object)) {
            this.getSubject().setPropertyValue(this.getPredicate(), null);
        } else {
            this.getSubject().setPropertyValue(this.getPredicate(), object);
        }
    }

    private void assignTextFieldValue() {
        Object object;
        Object object2 = this.getSubject().getPropertyValue(this.getPredicate());
        String string = this.textComponent.getText().trim();
        Object object3 = null;
        if (string.length() > 0) {
            object = this.getDatatype();
            if (this.getOWLModel().getXSDstring().equals(object)) {
                String string2 = null;
                if (object2 instanceof RDFSLiteral) {
                    RDFSLiteral rDFSLiteral = (RDFSLiteral)object2;
                    if (rDFSLiteral.getLanguage() != null) {
                        string2 = rDFSLiteral.getLanguage();
                        object3 = this.getOWLModel().createRDFSLiteral(string, string2);
                    } else {
                        object3 = string;
                    }
                } else {
                    object3 = string;
                }
            } else {
                object3 = this.getOWLModel().createRDFSLiteral(string, (RDFSDatatype)object);
            }
        }
        if (object3 == null) {
            this.getSubject().setPropertyValue(this.getPredicate(), null);
        } else {
            object3 = DefaultRDFSLiteral.getPlainValueIfPossible(object3);
            object = this.getSubject().getPropertyValues(this.getPredicate(), true);
            if (!object.contains(object3)) {
                this.getSubject().setPropertyValue(this.getPredicate(), object3);
            }
        }
    }

    private RDFSDatatype getDatatype() {
        return (RDFSDatatype)this.datatypeComboBox.getSelectedItem();
    }

    protected JTextComponent getTextComponent() {
        return this.textComponent;
    }

    private void handleDeleteAction() {
        this.textComponent.setText("");
        this.assignTextFieldValue();
        this.resetDatatypeComboBox();
    }

    private void handleViewAction() {
        Object object = this.getObject();
        PropertyValueEditor propertyValueEditor = this.getEditor(object);
        if (propertyValueEditor != null) {
            Object object2;
            if (this.getObject() == null) {
                object = propertyValueEditor.createDefaultValue(this.getSubject(), this.getPredicate());
            }
            if ((object2 = propertyValueEditor.editValue(null, this.getSubject(), this.getPredicate(), object)) != null) {
                this.getSubject().setPropertyValue(this.getPredicate(), object2);
            }
        }
    }

    private boolean hasOnlyActiveValues() {
        if (this.getSubject() != null) {
            Collection collection = this.getSubject().getPropertyValues(this.getPredicate());
            TripleStoreModel tripleStoreModel = this.getOWLModel().getTripleStoreModel();
            for (Object e : collection) {
                if (tripleStoreModel.isActiveTriple(this.getSubject(), this.getPredicate(), e)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isRangeDefined() {
        RDFResource rDFResource = this.getSubject();
        RDFProperty rDFProperty = this.getPredicate();
        return ComponentUtil.isRangeDefined(rDFResource, rDFProperty);
    }

    private void resetDatatypeComboBox() {
        RDFResource rDFResource = this.getPredicate().getRange();
        if (rDFResource instanceof RDFSDatatype) {
            this.setDatatypeComboBoxItem(rDFResource);
            this.updateTextFieldAlignment((RDFSDatatype)rDFResource);
        } else {
            Collection collection = this.getSubject().getRDFTypes();
            for (RDFSClass rDFSClass : collection) {
                if (!(rDFSClass instanceof OWLNamedClass)) continue;
                OWLNamedClass oWLNamedClass = (OWLNamedClass)rDFSClass;
                RDFResource rDFResource2 = oWLNamedClass.getAllValuesFrom(this.getPredicate());
                if (rDFResource2 instanceof RDFSDatatype) {
                    this.setDatatypeComboBoxItem(rDFResource2);
                    this.updateTextFieldAlignment((RDFSDatatype)rDFResource2);
                    return;
                }
                RDFResource rDFResource3 = oWLNamedClass.getSomeValuesFrom(this.getPredicate());
                if (!(rDFResource3 instanceof RDFSDatatype)) continue;
                this.setDatatypeComboBoxItem(rDFResource3);
                this.updateTextFieldAlignment((RDFSDatatype)rDFResource3);
                return;
            }
        }
    }

    private void setDatatypeComboBoxItem(RDFResource rDFResource) {
        if (!this.datatypeComboBox.getSelectedItem().equals(rDFResource)) {
            this.datatypeComboBox.setSelectedItem(rDFResource);
        }
    }

    public void setSubject(RDFResource rDFResource) {
        super.setSubject(rDFResource);
        this.updateComboBoxVisibility();
        boolean bl = !this.isReadOnly() && this.hasOnlyEditableValues();
        boolean bl2 = bl && this.hasOnlyActiveValues() && rDFResource.getHasValuesOnTypes(this.getPredicate()).isEmpty();
        this.textComponent.setEditable(bl2);
        this.booleanComboBox.setEnabled(bl2);
        this.datatypeComboBox.setEnabled(bl2 && !this.isRangeDefined());
    }

    private void updateActionStatus() {
        boolean bl = !this.isReadOnly() && this.hasOnlyEditableValues();
        this.deleteAction.setEnabled(this.getSubject() != null && this.getSubject().getPropertyValue(this.getPredicate()) != null && bl);
        Object object = this.getObject();
        PropertyValueEditor propertyValueEditor = this.getEditor(object);
        this.viewAction.setEnabled(bl && propertyValueEditor != null);
        if (this.datatypeComboBox != null) {
            this.datatypeComboBox.setEnabled(!this.isReadOnly());
        }
        if (this.booleanComboBox != null) {
            this.booleanComboBox.setEnabled(!this.isReadOnly());
        }
        if (this.textComponent != null) {
            this.textComponent.setEditable(!this.isReadOnly());
        }
    }

    private void updateComboBoxVisibility() {
        boolean bl;
        Object object;
        RDFProperty rDFProperty = this.getPredicate();
        RDFSDatatype rDFSDatatype = null;
        Collection collection = this.getSubject().getRDFTypes();
        for (RDFSClass rDFSClass : collection) {
            OWLNamedClass oWLNamedClass;
            RDFResource rDFResource;
            if (!(rDFSClass instanceof OWLNamedClass) || !((rDFResource = (oWLNamedClass = (OWLNamedClass)rDFSClass).getAllValuesFrom(rDFProperty)) instanceof RDFSDatatype)) continue;
            rDFSDatatype = (RDFSDatatype)rDFResource;
        }
        if (rDFSDatatype == null) {
            object = rDFProperty.getRange();
            if (object instanceof RDFSDatatype) {
                rDFSDatatype = (RDFSDatatype)object;
            }
        } else if (rDFSDatatype.getBaseDatatype() != null) {
            rDFSDatatype = rDFSDatatype.getBaseDatatype();
        }
        object = this.getOWLModel();
        boolean bl2 = bl = object.getXSDboolean().equals(rDFSDatatype) || object.getXSDstring().equals(rDFSDatatype) || object.getXSDint().equals(rDFSDatatype) || object.getXSDfloat().equals(rDFSDatatype);
        if (bl) {
            this.mainPanel.remove(this.datatypeComboBox);
        } else {
            this.mainPanel.add("East", this.datatypeComboBox);
        }
    }

    private void updateDatatypeComboBox(Object object) {
        RDFSDatatype rDFSDatatype = this.getOWLModel().getRDFSDatatypeOfValue(object);
        if (rDFSDatatype != null) {
            this.setDatatypeComboBoxItem(rDFSDatatype);
            this.updateTextFieldAlignment(rDFSDatatype);
        } else {
            this.updateDatatypeComboBox(this.getOWLModel().getXSDstring());
        }
    }

    private void updateTextFieldAlignment(RDFSDatatype rDFSDatatype) {
        if (this.getOWLModel().getXSDboolean().equals(rDFSDatatype)) {
            if (this.booleanComboBox.getParent() != this.mainPanel) {
                this.mainPanel.remove(this.textComponentHolder);
                this.mainPanel.add("Center", this.booleanComboBox);
            }
        } else {
            boolean bl = rDFSDatatype.isNumericDatatype();
            this.updateTextFieldAlignment(bl);
            if (this.textComponentHolder.getParent() != this.mainPanel) {
                this.mainPanel.remove(this.booleanComboBox);
                this.mainPanel.add("Center", this.textComponentHolder);
            }
        }
    }

    protected void updateTextFieldAlignment(boolean bl) {
    }

    public void valuesChanged() {
        ArrayList arrayList = new ArrayList(this.getObjects(true));
        Collection collection = this.getSubject().getHasValuesOnTypes(this.getPredicate());
        for (Object e : collection) {
            if (arrayList.contains(e)) continue;
            arrayList.add(e);
        }
        Iterator iterator = arrayList.iterator();
        if (iterator.hasNext()) {
            Object e;
            e = iterator.next();
            this.textComponent.setText("" + e);
            if (e instanceof Boolean) {
                this.booleanComboBox.setSelectedItem(e);
            }
            this.updateDatatypeComboBox(e);
        } else {
            this.textComponent.setText("");
            this.booleanComboBox.setSelectedItem(UNDEFINED);
            this.resetDatatypeComboBox();
        }
        this.updateActionStatus();
    }
}

