/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.annotations;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.ui.components.annotations.AnnotationsTable;
import edu.stanford.smi.protegex.owl.ui.components.annotations.AnnotationsTableCellHolder;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;

public class AnnotationsValueEditor
extends AbstractCellEditor
implements TableCellEditor {
    private JTextArea textArea;
    private AnnotationsTableCellHolder multiLineHolder;
    private JTextField textField;
    private AnnotationsTableCellHolder singleLineHolder;
    private JTextComponent textComponent;
    private Border focusBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
    public static final int EDITING_MARGIN = 30;

    public AnnotationsValueEditor(OWLModel oWLModel, JTable jTable) {
        this.textArea = new JTextArea();
        OWLUI.addCopyPastePopup(this.textArea);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setLineWrap(true);
        this.textArea.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 10: {
                        if (!keyEvent.isControlDown()) break;
                        AnnotationsValueEditor.this.stopCellEditing();
                        keyEvent.consume();
                        break;
                    }
                    case 27: {
                        AnnotationsValueEditor.this.cancelCellEditing();
                    }
                }
            }
        });
        this.textArea.setFocusable(true);
        JScrollPane jScrollPane = new JScrollPane(this.textArea);
        jScrollPane.setBorder(this.focusBorder);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        this.multiLineHolder = new AnnotationsTableCellHolder(jScrollPane, "Center");
        this.textField = new JTextField();
        OWLUI.addCopyPastePopup(this.textField);
        this.singleLineHolder = new AnnotationsTableCellHolder(this.textField, "Center");
    }

    public Object getCellEditorValue() {
        return this.textComponent.getText().trim();
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        RDFProperty rDFProperty = (RDFProperty)jTable.getValueAt(n, 0);
        if (AnnotationsTable.isMultiLineProperty(rDFProperty)) {
            this.textArea.setText(object != null ? object.toString() : "");
            int n3 = this.getRowHeight(jTable, n);
            if (jTable.getRowHeight(n) != n3) {
                jTable.setRowHeight(n, n3);
            }
            this.textComponent = this.textArea;
            this.focusTextField();
            return this.multiLineHolder;
        }
        this.textField.setText(object != null ? object.toString() : "");
        this.textComponent = this.textField;
        this.focusTextField();
        return this.singleLineHolder;
    }

    private void focusTextField() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AnnotationsValueEditor.this.textComponent.requestFocus();
            }
        });
    }

    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            return ((MouseEvent)eventObject).getClickCount() == 2;
        }
        return super.isCellEditable(eventObject);
    }

    private int getRowHeight(JTable jTable, int n) {
        int n2;
        Object object = jTable.getValueAt(n, 1);
        if (object == null) {
            object = "";
        }
        int n3 = 0;
        View view = this.textArea.getUI().getRootView(this.textArea);
        view.setSize(jTable.getColumnModel().getColumn(1).getWidth(), 2.1474836E9f);
        n3 = (int)view.getPreferredSpan(1) + 30;
        JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, jTable);
        if (jScrollPane != null && n3 > (n2 = jScrollPane.getViewport().getViewRect().height)) {
            n3 = n2;
        }
        return n3;
    }
}

