/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.code;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNAryLogicalClass;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.classparser.ParserUtils;
import edu.stanford.smi.protegex.owl.ui.code.ResourceNameMatcher;
import edu.stanford.smi.protegex.owl.ui.code.SymbolEditor;
import edu.stanford.smi.protegex.owl.ui.code.SymbolErrorDisplay;
import edu.stanford.smi.protegex.owl.ui.code.SymbolTextField;
import edu.stanford.smi.protegex.owl.ui.code.SyntaxConverter;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceIgnoreCaseComparator;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.CellEditor;
import javax.swing.JComboBox;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SymbolTextArea
extends JTextArea
implements KeyListener,
SymbolEditor {
    private CellEditor cellEditor;
    private JComboBox comboBox;
    private SymbolErrorDisplay errorDisplay;
    private ResourceNameMatcher resourceNameMatcher;
    private OWLModel owlModel;
    private KeyEvent previousKeyPressed;
    private SyntaxConverter syntaxConverter;

    public SymbolTextArea(OWLModel oWLModel, SymbolErrorDisplay symbolErrorDisplay, ResourceNameMatcher resourceNameMatcher, SyntaxConverter syntaxConverter) {
        this.owlModel = oWLModel;
        this.resourceNameMatcher = resourceNameMatcher;
        this.errorDisplay = symbolErrorDisplay;
        this.syntaxConverter = syntaxConverter;
        this.setBackground(Color.white);
        this.removeAll();
        this.addKeyListener(this);
        this.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                if (SymbolTextArea.this.previousKeyPressed != null) {
                    int n = SymbolTextArea.this.previousKeyPressed.getKeyCode();
                    if (!SymbolTextField.isIdChar(SymbolTextArea.this.previousKeyPressed.getKeyChar()) && n != 8 && n != 127) {
                        SymbolTextArea.this.closeComboBox();
                    }
                }
            }
        });
        this.setFont(this.getFont().deriveFont(16.0f));
    }

    public JComboBox getComboBox() {
        return this.comboBox;
    }

    protected void acceptSelectedFrame() {
        String string = this.getText();
        int n = this.getCaretPosition();
        int n2 = ParserUtils.findSplittingPoint(string.substring(0, n));
        String string2 = string.substring(n2, n);
        this.extendPartialName(string2, this.resourceNameMatcher.getInsertString((RDFResource)this.comboBox.getSelectedItem()));
        this.updateErrorDisplay();
        this.closeComboBox();
    }

    @Override
    public void assignExpression() {
        this.handleEnter();
    }

    @Override
    public void backspace() {
        String string = this.getSelectedText();
        if (string != null && string.length() > 0) {
            int n = this.getSelectionStart();
            try {
                this.getDocument().remove(n, this.getSelectionEnd() - n);
            }
            catch (BadLocationException badLocationException) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", badLocationException);
            }
            this.setCaretPosition(n);
        } else {
            int n = this.getCaretPosition();
            if (n > 0) {
                try {
                    this.getDocument().remove(n - 1, 1);
                }
                catch (BadLocationException badLocationException) {
                    Log.getLogger().log(Level.SEVERE, "Exception caught", badLocationException);
                }
                this.setCaretPosition(n - 1);
            }
        }
        this.updateErrorDisplay();
        this.requestFocus();
    }

    @Override
    public void cancelEditing() {
        this.handleEscape();
    }

    protected abstract void checkUniCodeExpression(String var1) throws Throwable;

    protected void closeComboBox() {
        this.removeAll();
    }

    @Override
    public void displayError() {
        try {
            String string = this.getText();
            this.checkUniCodeExpression(string);
            this.errorDisplay.displayError((Throwable)null);
        }
        catch (Throwable throwable) {
            this.errorDisplay.displayError(throwable);
        }
        this.requestFocus();
    }

    protected void extendPartialName(String string, String string2) {
        try {
            this.getDocument().remove(this.getCaretPosition() - string.length(), string.length());
            this.getDocument().insertString(this.getCaretPosition(), string2, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void extendPartialName(boolean bl) {
        String string = this.getText();
        int n = this.getCaretPosition();
        int n2 = ParserUtils.findSplittingPoint(string.substring(0, n));
        String string2 = string.substring(n2, n);
        String string3 = string.substring(0, n2);
        Set<RDFResource> set = this.resourceNameMatcher.getMatchingResources(string2, string3, this.owlModel);
        if (bl && set.size() == 1) {
            RDFResource rDFResource = set.iterator().next();
            this.extendPartialName(string2, this.resourceNameMatcher.getInsertString(rDFResource));
            this.closeComboBox();
        } else if (set.size() > 1) {
            this.showComboBox(set, n2 + 1);
        }
    }

    public String getIndentedClsString(OWLNAryLogicalClass oWLNAryLogicalClass, String string) {
        boolean bl = string.length() == 0;
        String string2 = bl ? "" : "(";
        char c = oWLNAryLogicalClass instanceof OWLUnionClass ? (char)'\u2294' : '\u2293';
        Iterator iterator = oWLNAryLogicalClass.getOperands().iterator();
        while (iterator.hasNext()) {
            RDFSClass rDFSClass = (RDFSClass)iterator.next();
            string2 = string2 + string;
            string2 = rDFSClass instanceof OWLNAryLogicalClass ? string2 + this.getIndentedClsString((OWLNAryLogicalClass)rDFSClass, string + "    ") : string2 + rDFSClass.getBrowserText();
            if (!iterator.hasNext()) continue;
            string2 = string2 + " " + c + "\n";
        }
        if (!bl) {
            string2 = string2 + ")";
        }
        return string2;
    }

    protected OWLModel getOWLModel() {
        return this.owlModel;
    }

    private int getXOfPosition(int n) {
        Font font = this.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        return fontMetrics.stringWidth(this.getText().substring(0, n));
    }

    private boolean handleDown() {
        if (this.isComboBoxVisible()) {
            int n = this.comboBox.getSelectedIndex();
            if (n < this.comboBox.getItemCount() - 1) {
                this.comboBox.setSelectedIndex(n + 1);
            }
            return true;
        }
        return false;
    }

    boolean handleEnter() {
        if (this.isComboBoxVisible()) {
            this.acceptSelectedFrame();
            return true;
        }
        return false;
    }

    private void handleEscape() {
        if (this.isComboBoxVisible()) {
            this.closeComboBox();
        } else if (this.cellEditor != null) {
            this.cellEditor.cancelCellEditing();
        }
    }

    private boolean handleUp() {
        if (this.isComboBoxVisible()) {
            int n = this.comboBox.getSelectedIndex();
            if (n > 0) {
                this.comboBox.setSelectedIndex(n - 1);
            }
            return true;
        }
        return false;
    }

    @Override
    public void insertText(String string) {
        this.insertText(string, string.length());
    }

    @Override
    public void insertText(String string, int n) {
        String string2 = this.getSelectedText();
        if (string2 != null && string2.length() > 0) {
            int n2 = this.getSelectionStart();
            try {
                this.getDocument().remove(n2, this.getSelectionEnd() - n2);
                this.getDocument().insertString(n2, string, null);
                this.setCaretPosition(n2 + n);
            }
            catch (BadLocationException badLocationException) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", badLocationException);
            }
        } else {
            try {
                int n3 = this.getCaretPosition();
                this.getDocument().insertString(n3, string, null);
                this.setCaretPosition(n3 + n);
            }
            catch (BadLocationException badLocationException) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", badLocationException);
            }
        }
        this.updateErrorDisplay();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SymbolTextArea.this.requestFocus();
            }
        });
    }

    private boolean isComboBoxVisible() {
        return this.comboBox != null && this.comboBox.isVisible() && this.comboBox.isShowing();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.updateErrorDisplay();
        this.previousKeyPressed = keyEvent;
        int n = keyEvent.getKeyCode();
        if (keyEvent.getKeyCode() == 9 || keyEvent.getKeyChar() == ' ' && (keyEvent.getModifiers() & 2) != 0) {
            this.extendPartialName(true);
            keyEvent.consume();
        } else {
            switch (n) {
                case 40: {
                    if (!this.handleDown()) break;
                    keyEvent.consume();
                    break;
                }
                case 38: {
                    if (!this.handleUp()) break;
                    keyEvent.consume();
                    break;
                }
                case 27: {
                    this.handleEscape();
                    keyEvent.consume();
                    break;
                }
                case 10: {
                    if (!this.handleEnter()) break;
                    keyEvent.consume();
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.updateErrorDisplay();
        this.perhapsUpdateSyntax(keyEvent);
        int n = keyEvent.getKeyCode();
        if (n != 40 && n != 38) {
            this.refreshComboBox();
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        this.perhapsUpdateSyntax(keyEvent);
    }

    private void perhapsUpdateSyntax(KeyEvent keyEvent) {
        if (this.syntaxConverter != null) {
            char c = keyEvent.getKeyChar();
            int n = keyEvent.getKeyCode();
            if (!SymbolTextField.isIdChar(c) && n != 8 && n != 127) {
                this.syntaxConverter.convertSyntax(this);
            }
        }
    }

    private void refreshComboBox() {
        if (this.isComboBoxVisible()) {
            String string;
            int n;
            int n2;
            String string2 = this.getText();
            String string3 = string2.substring(n2 = ParserUtils.findSplittingPoint(string2.substring(0, n = this.getCaretPosition())), n);
            Set<RDFResource> set = this.resourceNameMatcher.getMatchingResources(string3, string = string2.substring(0, n2), this.owlModel);
            if (set.size() == 0) {
                this.closeComboBox();
            } else {
                this.showComboBox(set, n2 + 1);
            }
        }
    }

    void replaceText(String string) {
        this.setText(string);
        this.updateErrorDisplay();
        this.requestFocus();
    }

    public void setCellEditor(CellEditor cellEditor) {
        this.cellEditor = cellEditor;
    }

    private void showComboBox(Set<RDFResource> set, int n) {
        this.closeComboBox();
        Frame[] frameArray = set.toArray(new Frame[0]);
        Arrays.sort(frameArray, new ResourceIgnoreCaseComparator());
        this.comboBox = new JComboBox<Frame>(frameArray);
        this.comboBox.setBackground(Color.white);
        this.comboBox.setRenderer(new FrameRenderer());
        this.comboBox.setSize(this.comboBox.getPreferredSize().width + 20, 0);
        int n2 = this.getXOfPosition(n) - 16;
        String string = this.getText();
        int n3 = 1;
        int n4 = this.getCaretPosition();
        String string2 = "";
        for (int i = 0; i < n4; ++i) {
            string2 = string2 + string.charAt(i);
            if (string.charAt(i) != '\n') continue;
            ++n3;
            string2 = "";
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        n2 = fontMetrics.stringWidth(string2);
        this.comboBox.setLocation(n2, this.getRowHeight() * n3);
        this.comboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (((long)actionEvent.getModifiers() & 0x10L) != 0L) {
                    SymbolTextArea.this.acceptSelectedFrame();
                }
            }
        });
        this.add(this.comboBox);
        this.comboBox.showPopup();
    }

    protected void updateErrorDisplay() {
        String string = this.getText();
        try {
            this.checkUniCodeExpression(string);
            this.errorDisplay.displayError((Throwable)null);
            this.setBackground(Color.white);
        }
        catch (Throwable throwable) {
            this.errorDisplay.setErrorFlag(true);
            this.setBackground(new Color(240, 240, 240));
        }
    }

    public SymbolErrorDisplay getErrorSymbolDisplay() {
        return this.errorDisplay;
    }
}

