/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsdesc;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.event.ClassAdapter;
import edu.stanford.smi.protegex.owl.model.event.ClassListener;
import edu.stanford.smi.protegex.owl.ui.clsdesc.AddRowAction;
import edu.stanford.smi.protegex.owl.ui.clsdesc.ClassDescriptionTable;
import edu.stanford.smi.protegex.owl.ui.clsdesc.ClassDescriptionWidget;
import edu.stanford.smi.protegex.owl.ui.clsdesc.CreateRowAction;
import edu.stanford.smi.protegex.owl.ui.clsdesc.PropertiesDefinitionTableModel;
import edu.stanford.smi.protegex.owl.ui.clsdesc.PropertiesSuperclassesTableModel;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTableModel;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;

public class PropertiesSuperclassesWidget
extends ClassDescriptionWidget {
    private ResourceSelectionAction addRowAction;
    private ClassListener classListener = new ClassAdapter(){

        public void subclassAdded(RDFSClass rDFSClass, RDFSClass rDFSClass2) {
            PropertiesSuperclassesWidget.this.updateModel();
        }

        public void subclassRemoved(RDFSClass rDFSClass, RDFSClass rDFSClass2) {
            PropertiesSuperclassesWidget.this.updateModel();
        }

        public void superclassAdded(RDFSClass rDFSClass, RDFSClass rDFSClass2) {
            PropertiesSuperclassesWidget.this.updateModel();
        }

        public void superclassRemoved(RDFSClass rDFSClass, RDFSClass rDFSClass2) {
            PropertiesSuperclassesWidget.this.updateModel();
        }
    };
    private Action createRowAction;

    protected ResourceSelectionAction createAddAction(ClassDescriptionTable classDescriptionTable) {
        this.addRowAction = new AddRowAction(this.getTable(), "Add named class", true);
        return this.addRowAction;
    }

    protected Action createCreateAction(ClassDescriptionTable classDescriptionTable) {
        this.createRowAction = new CreateRowAction(this.getTable(), "Create class from expression");
        return this.createRowAction;
    }

    protected List createCustomActions(ClassDescriptionTable classDescriptionTable) {
        return Collections.EMPTY_LIST;
    }

    protected Icon createHeaderIcon() {
        return OWLIcons.getSuperclassesIcon();
    }

    protected OWLTableModel createTableModel() {
        return new PropertiesSuperclassesTableModel();
    }

    public void dispose() {
        super.dispose();
        if (this.getEditedCls() != null) {
            this.getEditedCls().removeClassListener(this.classListener);
        }
    }

    protected String getLabelText() {
        return "Superclasses";
    }

    public void setInstance(Instance instance) {
        if (this.getEditedCls() != null) {
            this.getEditedCls().removeClassListener(this.classListener);
        }
        super.setInstance(instance);
        this.updateModel();
        if (this.getEditedCls() != null) {
            this.getEditedCls().addClassListener(this.classListener);
            boolean bl = this.getKnowledgeBase().getRootCls().equals(this.getEditedCls());
            this.addRowAction.setEnabled(!bl && this.getEditedCls().isEditable());
            this.createRowAction.setEnabled(!bl && this.getEditedCls().isEditable());
        }
    }

    private void updateModel() {
        OWLNamedClass oWLNamedClass = this.getEditedCls();
        if (oWLNamedClass != null) {
            RDFSClass rDFSClass = oWLNamedClass.getDefinition();
            if (rDFSClass != null) {
                if (!(this.getTable().getModel() instanceof PropertiesDefinitionTableModel)) {
                    PropertiesDefinitionTableModel propertiesDefinitionTableModel = new PropertiesDefinitionTableModel();
                    propertiesDefinitionTableModel.setCls(oWLNamedClass);
                    this.getTable().setModel(propertiesDefinitionTableModel);
                }
                this.getLabeledComponent().setHeaderLabel("Defining Classes");
                this.getLabeledComponent().setHeaderIcon(OWLIcons.getEquivalentClassIcon());
            } else {
                if (!(this.getTable().getModel() instanceof PropertiesSuperclassesTableModel)) {
                    PropertiesSuperclassesTableModel propertiesSuperclassesTableModel = new PropertiesSuperclassesTableModel();
                    propertiesSuperclassesTableModel.setCls(oWLNamedClass);
                    this.getTable().setModel(propertiesSuperclassesTableModel);
                }
                this.getLabeledComponent().setHeaderLabel("Superclasses");
                this.getLabeledComponent().setHeaderIcon(OWLIcons.getSuperclassesIcon());
            }
        }
    }
}

