/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsdesc;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.ui.cls.OWLClassesTab;
import edu.stanford.smi.protegex.owl.ui.clsdesc.ClassDescriptionEditorComponent;
import edu.stanford.smi.protegex.owl.ui.code.SymbolEditorComponent;
import edu.stanford.smi.protegex.owl.ui.code.SymbolErrorDisplay;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTable;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTableModel;
import java.awt.Component;
import java.util.Collection;

public class ClassDescriptionTable
extends OWLTable {
    ClassDescriptionTable(OWLModel oWLModel, OWLTableModel oWLTableModel) {
        super(oWLTableModel, oWLModel, true);
        this.setColumnWidths();
    }

    void addCls(RDFSClass rDFSClass) {
        OWLTableModel oWLTableModel = this.getOWLTableModel();
        if (oWLTableModel.getClassRow(rDFSClass) >= 0) {
            oWLTableModel.displaySemanticError("The class " + rDFSClass.getBrowserText() + " is already in the list.");
        } else if (rDFSClass.equals(oWLTableModel.getEditedCls())) {
            oWLTableModel.displaySemanticError("Cannot assign " + rDFSClass.getBrowserText() + " to itself.");
        } else {
            OWLClassesTab oWLClassesTab = OWLClassesTab.getOWLClassesTab((Component)((Object)this));
            oWLTableModel.addRow(rDFSClass, this.getSelectedRow());
            int n = oWLTableModel.getClassRow(rDFSClass);
            if (n >= 0) {
                this.getSelectionModel().setSelectionInterval(n, n);
            }
            if (oWLClassesTab != null) {
                oWLClassesTab.ensureClassSelected(this.getEditedCls(), -1);
            }
        }
    }

    void createAndEditRow() {
        int n = this.getOWLTableModel().addEmptyRow(-1);
        this.editExpression(n);
    }

    protected SymbolEditorComponent createSymbolEditorComponent(OWLModel oWLModel, SymbolErrorDisplay symbolErrorDisplay) {
        return new ClassDescriptionEditorComponent(oWLModel, symbolErrorDisplay, false);
    }

    public void hideSymbolPanel() {
        super.hideSymbolPanel();
        this.getOWLTableModel().removeEmptyRow();
    }

    private void setColumnWidths() {
        this.getColumnModel().getColumn(this.getOWLTableModel().getSymbolColumnIndex()).setPreferredWidth(350);
    }

    void toggleSuperClsIntoDefintion() {
        int n = this.getSelectedRow();
        if (n >= 0) {
            OWLNamedClass oWLNamedClass = this.getOWLTableModel().getEditedCls();
            RDFSClass rDFSClass = this.getOWLTableModel().getClass(n);
            this.toggleSuperclassIntoEquivalentClass(oWLNamedClass, rDFSClass);
            this.getSelectionModel().setSelectionInterval(n, n);
        }
    }

    void toggleDefinitionIntoSuperCls() {
        int n = this.getSelectedRow();
        if (n >= 0) {
            OWLNamedClass oWLNamedClass = this.getOWLTableModel().getEditedCls();
            RDFSClass rDFSClass = this.getOWLTableModel().getClass(n);
            this.toggleEquivalentClassIntoSuperclass(oWLNamedClass, rDFSClass);
            this.getSelectionModel().setSelectionInterval(n, n);
        }
    }

    private void toggleEquivalentClassIntoSuperclass(OWLNamedClass oWLNamedClass, RDFSClass rDFSClass) {
        OWLUtil.convertEquivalentClsIntoSuperClses(oWLNamedClass, rDFSClass);
    }

    private void toggleSuperclassIntoEquivalentClass(OWLNamedClass oWLNamedClass, RDFSClass rDFSClass) {
        Collection collection = oWLNamedClass.getNamedSuperclasses();
        collection.remove(rDFSClass);
        if (collection.size() == 0) {
            oWLNamedClass.addSuperclass(this.getOWLModel().getOWLThingClass());
        }
        OWLUtil.convertSuperClsIntoEquivalentCls(oWLNamedClass, rDFSClass);
    }
}

