/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsdesc;

import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.clsdesc.ClassDescriptionTable;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTableModel;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;

class AddRowAction
extends ResourceSelectionAction {
    private ClassDescriptionTable table;
    private boolean thingAllowed;

    AddRowAction(ClassDescriptionTable classDescriptionTable, String string, boolean bl) {
        super(string, OWLIcons.getAddIcon("PrimitiveClass"), true);
        this.table = classDescriptionTable;
        this.thingAllowed = bl;
    }

    public void resourceSelected(RDFResource rDFResource) {
        OWLModel oWLModel = rDFResource.getOWLModel();
        try {
            oWLModel.beginTransaction(this.getValue("Name") + " " + rDFResource.getBrowserText() + " to " + this.table.getEditedCls().getBrowserText(), this.table.getEditedCls().getName());
            this.table.addCls((RDFSClass)rDFResource);
            oWLModel.commitTransaction();
        }
        catch (Exception exception) {
            oWLModel.rollbackTransaction();
            OWLUI.handleError(oWLModel, exception);
        }
    }

    public Collection getSelectableResources() {
        OWLModel oWLModel = this.table.getOWLModel();
        Collection collection = oWLModel.getUserDefinedOWLNamedClasses();
        if (this.thingAllowed) {
            collection.add(oWLModel.getOWLThingClass());
        }
        OWLNamedClass oWLNamedClass = ((OWLTableModel)this.table.getModel()).getEditedCls();
        collection.remove(oWLNamedClass);
        Object[] objectArray = collection.toArray();
        Arrays.sort(objectArray, new FrameComparator());
        return Arrays.asList(objectArray);
    }

    public Collection pickResources() {
        return ProtegeUI.getSelectionDialogFactory().selectClasses((Component)((Object)this.table), this.table.getOWLModel(), "Select named class(es) to add");
    }
}

