/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.cls;

import com.hp.hpl.jena.ontology.OntModel;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protegex.owl.database.OWLDatabaseModel;
import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.jena.JenaDLConverter;
import edu.stanford.smi.protegex.owl.jena.creator.JenaCreator;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceAction;
import edu.stanford.smi.protegex.owl.ui.cls.OWLSubclassPane;
import edu.stanford.smi.protegex.owl.ui.widget.ModalProgressBarManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.HashSet;
import javax.swing.JFileChooser;

public class ExtractOntologyAction
extends ResourceAction {
    private JFileChooser fileChooser;

    public ExtractOntologyAction() {
        super("Extract (sub) ontology to OWL file...", Icons.getBlankIcon(), "Extract/");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        JenaCreator jenaCreator2;
        int n = ProtegeUI.getModalDialogFactory().showConfirmCancelDialog(this.getResource().getOWLModel(), "Shall the OWL File be converted to OWL DL if needed?", this.getValue("Name").toString());
        if (n == 4) {
            return;
        }
        HashSet<Object> hashSet = null;
        RDFSNamedClass rDFSNamedClass = (RDFSNamedClass)this.getResource();
        if (!this.getResource().equals(this.getResource().getOWLModel().getOWLThingClass())) {
            hashSet = new HashSet<Object>();
            for (JenaCreator jenaCreator2 : rDFSNamedClass.getSubclasses(true)) {
                if (!(jenaCreator2 instanceof OWLNamedClass) || !((OWLNamedClass)((Object)jenaCreator2)).isEditable()) continue;
                hashSet.add(jenaCreator2);
            }
            hashSet.add(rDFSNamedClass);
        }
        OWLModel oWLModel = rDFSNamedClass.getOWLModel();
        jenaCreator2 = new JenaCreator(oWLModel, false, hashSet, new ModalProgressBarManager("Preparing Ontology"));
        OntModel ontModel = jenaCreator2.createOntModel();
        if (n == 1) {
            System.out.println("Running JenaDLConverter...");
            object = new JenaDLConverter(ontModel, oWLModel.getNamespaceManager());
            ontModel = ((JenaDLConverter)object).convertOntModel();
        }
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser(".");
        }
        if (this.fileChooser.showSaveDialog(null) == 0) {
            object = this.fileChooser.getSelectedFile();
            Jena.saveOntModel(oWLModel, (File)object, ontModel, "The (sub) ontology has been extracted to\n" + object);
        }
    }

    public boolean isSuitable(Component component, RDFResource rDFResource) {
        return component instanceof OWLSubclassPane && rDFResource instanceof RDFSNamedClass && rDFResource.getOWLModel() instanceof OWLDatabaseModel;
    }
}

