/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.classform.component.property;

import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueAdapter;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueListener;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.classform.component.FormComponent;
import edu.stanford.smi.protegex.owl.ui.classform.component.property.AddIndividualAction;
import edu.stanford.smi.protegex.owl.ui.classform.component.property.AddNamedClassAction;
import edu.stanford.smi.protegex.owl.ui.classform.component.property.ChangeClosureAxiomButton;
import edu.stanford.smi.protegex.owl.ui.classform.component.property.DeleteRowAction;
import edu.stanford.smi.protegex.owl.ui.classform.component.property.PropertyFormTable;
import edu.stanford.smi.protegex.owl.ui.classform.component.property.PropertyFormTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JScrollPane;

public class PropertyFormComponent
extends FormComponent {
    private AddIndividualAction addIndividualAction;
    private AddNamedClassAction addNamedClassAction;
    private ChangeClosureAxiomButton closureAxiomAction;
    private DeleteRowAction deleteRowAction;
    private OWLLabeledComponent lc;
    private RDFProperty property;
    private PropertyFormTable table;
    private PropertyValueListener valueListener = new PropertyValueAdapter(){

        public void browserTextChanged(RDFResource rDFResource) {
            PropertyFormComponent.this.updatePropertyBrowserText();
        }
    };
    private static final int MAX_ROWS = 8;

    public PropertyFormComponent(RDFProperty rDFProperty) {
        this.property = rDFProperty;
        rDFProperty.addPropertyValueListener(this.valueListener);
    }

    public void dispose() {
        this.property.removePropertyValueListener(this.valueListener);
    }

    public Dimension getPreferredSize() {
        if (this.lc != null && this.table != null) {
            Dimension dimension = super.getPreferredSize();
            Dimension dimension2 = this.lc.getCenterComponent().getPreferredSize();
            int n = dimension.width - dimension2.width;
            int n2 = Math.min(Math.max(1, this.table.getTableModel().getRowCount()), 8);
            int n3 = this.table.getRowHeight();
            int n4 = dimension.height - dimension2.height + n2 * n3 + 3;
            return new Dimension(n, n4);
        }
        return new Dimension(0, 0);
    }

    public void init(OWLModel oWLModel) {
    }

    public void setNamedClass(OWLNamedClass oWLNamedClass) {
        if (this.table != null) {
            ComponentUtilities.dispose((Component)((Object)this.table));
        }
        PropertyFormTableModel propertyFormTableModel = new PropertyFormTableModel(oWLNamedClass, this.property);
        this.table = new PropertyFormTable(propertyFormTableModel, oWLNamedClass, this.property);
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.table));
        jScrollPane.getViewport().setBackground(Color.white);
        String string = this.property.getBrowserText() + "  ";
        string = this.table.isClosed() ? string + "only some" : string + "some";
        this.lc = new OWLLabeledComponent(string, jScrollPane);
        this.addNamedClassAction = new AddNamedClassAction(this.table);
        this.addIndividualAction = new AddIndividualAction(this.table);
        this.deleteRowAction = new DeleteRowAction(this.table);
        this.closureAxiomAction = new ChangeClosureAxiomButton(this.table);
        this.lc.addHeaderButton(this.addNamedClassAction);
        this.lc.addHeaderButton(this.addIndividualAction);
        this.lc.addHeaderButton(this.deleteRowAction);
        this.setContent((JComponent)((Object)this.lc));
    }

    private void updatePropertyBrowserText() {
        this.lc.setHeaderLabel(this.property.getBrowserText());
    }
}

