/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.actions;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;

public class DeleteMatchingPropertyValuesAction
extends AbstractAction {
    private RDFProperty property;
    private Object value;
    private Collection targetFrames;
    private String type;

    public DeleteMatchingPropertyValuesAction(String string, RDFProperty rDFProperty, Object object, Collection collection) {
        this(string, rDFProperty, object, collection, "annotation");
    }

    public DeleteMatchingPropertyValuesAction(String string, RDFProperty rDFProperty, Object object, Collection collection, String string2) {
        super("Delete selected " + string2 + " value in " + string + "...", OWLIcons.getDeleteIcon("SubClass"));
        this.property = rDFProperty;
        this.value = object;
        this.targetFrames = collection;
        this.type = string;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        OWLModel oWLModel = this.property.getOWLModel();
        try {
            oWLModel.beginTransaction("Delete annotation " + this.value + " from property " + this.property.getBrowserText() + " at multiple " + this.type, this.property == null ? null : this.property.getName());
            for (RDFResource rDFResource : this.targetFrames) {
                if (!rDFResource.getPropertyValues(this.property).contains(this.value)) continue;
                rDFResource.removePropertyValue(this.property, this.value);
            }
            oWLModel.commitTransaction();
        }
        catch (Exception exception) {
            oWLModel.rollbackTransaction();
            OWLUI.handleError(oWLModel, exception);
        }
    }
}

