/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.testing.sanity;

import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.testing.AbstractOWLTest;
import edu.stanford.smi.protegex.owl.testing.AutoRepairableOWLTest;
import edu.stanford.smi.protegex.owl.testing.DefaultOWLTestResult;
import edu.stanford.smi.protegex.owl.testing.OWLTestResult;
import edu.stanford.smi.protegex.owl.testing.RDFPropertyTest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class InverseOfTopLevelPropertyMustBeTopLevelPropertyTest
extends AbstractOWLTest
implements RDFPropertyTest,
AutoRepairableOWLTest {
    public InverseOfTopLevelPropertyMustBeTopLevelPropertyTest() {
        super("Sanity Tests", null);
    }

    public static boolean fails(RDFProperty rDFProperty) {
        if (rDFProperty instanceof OWLObjectProperty) {
            RDFProperty rDFProperty2 = rDFProperty.getInverseProperty();
            return rDFProperty2 != null && rDFProperty.getSuperpropertyCount() == 0 && rDFProperty2.getDirectSuperslotCount() > 0;
        }
        return false;
    }

    public boolean repair(OWLTestResult oWLTestResult) {
        return InverseOfTopLevelPropertyMustBeTopLevelPropertyTest.repair((OWLProperty)oWLTestResult.getHost());
    }

    public static boolean repair(OWLProperty oWLProperty) {
        RDFProperty rDFProperty;
        if (oWLProperty instanceof OWLObjectProperty && (rDFProperty = oWLProperty.getInverseProperty()) != null) {
            for (Slot slot : new ArrayList(rDFProperty.getDirectSuperslots())) {
                rDFProperty.removeDirectSuperslot(slot);
            }
            return !InverseOfTopLevelPropertyMustBeTopLevelPropertyTest.fails(oWLProperty);
        }
        return false;
    }

    public List test(RDFProperty rDFProperty) {
        if (InverseOfTopLevelPropertyMustBeTopLevelPropertyTest.fails(rDFProperty)) {
            return Collections.singletonList(new DefaultOWLTestResult("The inverse of a top-level property should also be top-level property.", rDFProperty, 2, this));
        }
        return Collections.EMPTY_LIST;
    }
}

