/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.testing.constraints;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.testing.AbstractOWLTest;
import edu.stanford.smi.protegex.owl.testing.DefaultOWLTestResult;
import edu.stanford.smi.protegex.owl.testing.RDFResourceTest;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.util.ArrayList;
import java.util.List;

public class FindSPARQLAssertsTest
extends AbstractOWLTest
implements RDFResourceTest {
    public FindSPARQLAssertsTest() {
        super(null, null);
    }

    private void addItems(List list, String string, List list2, RDFResource rDFResource) {
        for (final String string2 : list) {
            list2.add(new DefaultOWLTestResult(string2, rDFResource, 2, this, OWLIcons.getImageIcon(string)){

                public String toString() {
                    return "SPARQL Assertion (at " + this.getHost().getBrowserText() + "): " + string2;
                }
            });
        }
    }

    public String getName() {
        return "Find SPARQL assert items";
    }

    public static List getSPARQLAsserts(RDFResource rDFResource, String string) {
        RDFProperty rDFProperty;
        ArrayList arrayList = new ArrayList();
        OWLModel oWLModel = rDFResource.getOWLModel();
        String string2 = oWLModel.getResourceNameForURI(string);
        if (string2 != null && (rDFProperty = oWLModel.getRDFProperty(string2)) != null) {
            for (Object object : rDFResource.getPropertyValues(rDFProperty)) {
                String string3 = null;
                if (object instanceof RDFSLiteral) {
                    string3 = ((RDFSLiteral)object).getString();
                    object = string3;
                } else {
                    string3 = object.toString();
                }
                arrayList.add(object);
            }
        }
        return arrayList;
    }

    public List test(RDFResource rDFResource) {
        List list = FindSPARQLAssertsTest.getSPARQLAsserts(rDFResource, "http://www.owl-ontologies.com/assert.owl#empty");
        List list2 = FindSPARQLAssertsTest.getSPARQLAsserts(rDFResource, "http://www.owl-ontologies.com/assert.owl#notEmpty");
        ArrayList arrayList = new ArrayList();
        this.addItems(list, "AssertFalse", arrayList, rDFResource);
        this.addItems(list2, "AssertTrue", arrayList, rDFResource);
        return arrayList;
    }
}

