/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.ui.table;

import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.event.ClassAdapter;
import edu.stanford.smi.protegex.owl.model.event.ClassListener;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLFactory;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLImp;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.owltable.SymbolTableModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

public class SWRLTableModel
extends AbstractTableModel
implements Disposable,
SymbolTableModel {
    public static final int COL_ENABLED = 0;
    public static final int COL_NAME = 1;
    public static final int COL_EXPRESSION = 2;
    public static final int COL_COUNT = 3;
    private List imps = new ArrayList();
    private RDFResource rdfResource;
    private OWLModel owlModel;
    private SWRLFactory factory;
    private ClassListener clsListener = new ClassAdapter(){

        public void instanceAdded(RDFSClass rDFSClass, RDFResource rDFResource) {
            final SWRLImp sWRLImp = (SWRLImp)rDFResource;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SWRLTableModel.this.perhapsAdd(sWRLImp);
                }
            });
        }

        public void instanceRemoved(RDFSClass rDFSClass, RDFResource rDFResource) {
            SWRLTableModel.this.perhapsRemove((SWRLImp)rDFResource);
        }
    };

    public SWRLTableModel(OWLModel oWLModel) {
        this.owlModel = oWLModel;
        this.factory = new SWRLFactory(oWLModel);
        this.imps.addAll(this.factory.getImps());
        this.sortImps();
        this.initClsListener();
    }

    public SWRLTableModel(RDFResource rDFResource) {
        this.rdfResource = rDFResource;
        this.owlModel = rDFResource.getOWLModel();
        this.factory = new SWRLFactory(this.owlModel);
        this.addReferencingImps(rDFResource);
        this.sortImps();
        this.initClsListener();
    }

    public void dispose() {
        this.owlModel.getRDFSNamedClass("swrl:Imp").removeClassListener(this.clsListener);
    }

    public int getColumnCount() {
        return 3;
    }

    public Icon getIcon(RDFResource rDFResource) {
        return ProtegeUI.getIcon(rDFResource);
    }

    public SWRLImp getImp(int n) {
        return (SWRLImp)this.imps.get(n);
    }

    public RDFProperty getPredicate(int n) {
        return null;
    }

    public RDFResource getRDFResource(int n) {
        return this.getImp(n);
    }

    public RDFResource getSubject() {
        return null;
    }

    public int getSymbolColumnIndex() {
        return 2;
    }

    public int getRowCount() {
        return this.imps.size();
    }

    public int indexOf(SWRLImp sWRLImp) {
        return this.imps.indexOf(sWRLImp);
    }

    public Class getColumnClass(int n) {
        if (n == 0) {
            return Boolean.class;
        }
        return super.getColumnClass(n);
    }

    public String getColumnName(int n) {
        if (n == 0) {
            return "Enabled";
        }
        if (n == 1) {
            return "Name";
        }
        if (n == 2) {
            return "Expression";
        }
        return null;
    }

    public Object getValueAt(int n, int n2) {
        if (n2 == this.getSymbolColumnIndex()) {
            return this.getImp(n).getBrowserText();
        }
        if (n2 == 1) {
            return this.getImp(n).getName();
        }
        if (n2 == 0) {
            return new Boolean(this.getImp(n).isEnabled());
        }
        return null;
    }

    public boolean isCellEditable(int n, int n2) {
        if (n2 == 0 || n2 == 1 || n2 == 2) {
            SWRLImp sWRLImp = this.getImp(n);
            return sWRLImp.isEditable();
        }
        return false;
    }

    public void setValueAt(Object object, int n, int n2) {
        SWRLImp sWRLImp = this.getImp(n);
        if (n2 == 2) {
            String string = (String)object;
            try {
                sWRLImp.setExpression(string);
                if (!this.isSuitable(sWRLImp)) {
                    ProtegeUI.getModalDialogFactory().showMessageDialog(this.owlModel, "The replacing rule no longer fits the selection\ncriteria of this rules list, and will therefore no\nlonger be visible here.  But no reason to panic: It\nshould still show up on the SWRL tab.");
                }
            }
            catch (Exception exception) {}
        } else if (n2 == 1) {
            String string = (String)object;
            if (this.owlModel.isValidResourceName(string, sWRLImp)) {
                RDFResource rDFResource = this.owlModel.getRDFResource(string);
                if (rDFResource != null) {
                    if (!sWRLImp.equals(rDFResource)) {
                        ProtegeUI.getModalDialogFactory().showErrorMessageDialog(this.owlModel, "The name " + string + " is already used in this ontology.");
                    }
                } else {
                    sWRLImp.setName(string);
                }
            } else {
                ProtegeUI.getModalDialogFactory().showErrorMessageDialog(this.owlModel, string + " is not a valid rule name.");
            }
        } else if (n2 == 0) {
            Boolean bl = (Boolean)object;
            if (bl.booleanValue()) {
                sWRLImp.enable();
            } else {
                sWRLImp.disable();
            }
        }
    }

    public void setRowOf(SWRLImp sWRLImp, int n) {
        int n2 = this.imps.indexOf(sWRLImp);
        this.imps.remove(n2);
        this.fireTableRowsDeleted(n2, n2);
        this.imps.add(n, sWRLImp);
        this.fireTableRowsInserted(n, n);
    }

    public void enableAll() {
        for (SWRLImp sWRLImp : this.imps) {
            sWRLImp.enable();
        }
        this.fireTableRowsUpdated(0, this.getRowCount());
    }

    public void disableAll() {
        for (SWRLImp sWRLImp : this.imps) {
            sWRLImp.disable();
        }
        this.fireTableRowsUpdated(0, this.getRowCount());
    }

    private void addReferencingImps(RDFResource rDFResource) {
        OWLModel oWLModel = rDFResource.getOWLModel();
        Collection collection = this.factory.getImps();
        for (SWRLImp sWRLImp : collection) {
            if (!this.isSuitable(sWRLImp)) continue;
            this.imps.add(sWRLImp);
        }
    }

    private int getRowFor(SWRLImp sWRLImp) {
        int n;
        String string = sWRLImp.getName();
        for (n = 0; n < this.imps.size() && string.compareToIgnoreCase(this.getImp(n).getName()) >= 0; ++n) {
        }
        return n;
    }

    private void initClsListener() {
        this.owlModel.getRDFSNamedClass("swrl:Imp").addClassListener(this.clsListener);
    }

    private boolean isSuitable(SWRLImp sWRLImp) {
        if (this.rdfResource == null) {
            return true;
        }
        Set set = sWRLImp.getReferencedInstances();
        return set.contains(this.rdfResource);
    }

    private void perhapsAdd(SWRLImp sWRLImp) {
        if (this.isSuitable(sWRLImp)) {
            int n = this.getRowFor(sWRLImp);
            this.imps.add(n, sWRLImp);
            this.fireTableRowsInserted(n, n);
        }
    }

    private void perhapsRemove(SWRLImp sWRLImp) {
        int n = this.imps.indexOf(sWRLImp);
        if (n >= 0) {
            this.imps.remove(n);
            this.fireTableRowsDeleted(n, n);
        }
    }

    private void sortImps() {
        Collections.sort(this.imps, new Comparator(){

            public int compare(Object object, Object object2) {
                SWRLImp sWRLImp = (SWRLImp)object;
                SWRLImp sWRLImp2 = (SWRLImp)object2;
                return sWRLImp.getName().compareToIgnoreCase(sWRLImp2.getName());
            }
        });
    }
}

