/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.ui.tab;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.widget.AbstractTabWidget;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.factory.OWLJavaFactoryUpdater;
import edu.stanford.smi.protegex.owl.model.util.ImportHelper;
import edu.stanford.smi.protegex.owl.swrl.model.factory.SWRLJavaFactory;
import edu.stanford.smi.protegex.owl.swrl.ui.SWRLProjectPlugin;
import edu.stanford.smi.protegex.owl.swrl.ui.icons.SWRLIcons;
import edu.stanford.smi.protegex.owl.swrl.ui.table.SWRLTablePanel;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JLabel;

public class SWRLTab
extends AbstractTabWidget {
    private SWRLTablePanel panel = null;

    private void activateSWRL() {
        JenaOWLModel jenaOWLModel = (JenaOWLModel)this.getKnowledgeBase();
        try {
            jenaOWLModel.getNamespaceManager().setPrefix(new URI("http://www.w3.org/2003/11/swrl#"), "swrl");
            jenaOWLModel.getNamespaceManager().setPrefix(new URI("http://www.w3.org/2003/11/swrlb#"), "swrlb");
            jenaOWLModel.getNamespaceManager().setPrefix(new URI("http://swrl.stanford.edu/ontologies/3.3/swrla.owl#"), "swrla");
            jenaOWLModel.getNamespaceManager().setPrefix(new URI("http://swrl.stanford.edu/ontologies/built-ins/3.3/swrlx.owl#"), "swrlx");
            jenaOWLModel.getNamespaceManager().setPrefix(new URI("http://swrl.stanford.edu/ontologies/built-ins/3.4/swrlm.owl#"), "swrlm");
            jenaOWLModel.getNamespaceManager().setPrefix(new URI("http://swrl.stanford.edu/ontologies/built-ins/3.3/tbox.owl#"), "tbox");
            jenaOWLModel.getNamespaceManager().setPrefix(new URI("http://swrl.stanford.edu/ontologies/built-ins/3.3/abox.owl#"), "abox");
            jenaOWLModel.getNamespaceManager().setPrefix(new URI("http://swrl.stanford.edu/ontologies/built-ins/3.3/temporal.owl#"), "temporal");
            jenaOWLModel.getNamespaceManager().setPrefix(new URI("http://swrl.stanford.edu/ontologies/built-ins/3.4/swrlxml.owl#"), "swrlxml");
            jenaOWLModel.getNamespaceManager().setPrefix(new URI("http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl#"), "sqwrl");
            ImportHelper importHelper = new ImportHelper((JenaOWLModel)this.getKnowledgeBase());
            importHelper.addImport(new URI("http://swrl.stanford.edu/ontologies/3.3/swrla.owl"));
            importHelper.addImport(new URI("http://swrl.stanford.edu/ontologies/built-ins/3.3/swrlx.owl"));
            importHelper.addImport(new URI("http://swrl.stanford.edu/ontologies/built-ins/3.4/swrlm.owl"));
            importHelper.addImport(new URI("http://swrl.stanford.edu/ontologies/built-ins/3.3/tbox.owl"));
            importHelper.addImport(new URI("http://swrl.stanford.edu/ontologies/built-ins/3.3/abox.owl"));
            importHelper.addImport(new URI("http://swrl.stanford.edu/ontologies/built-ins/3.3/temporal.owl"));
            importHelper.addImport(new URI("http://swrl.stanford.edu/ontologies/built-ins/3.4/swrlxml.owl"));
            importHelper.addImport(new URI("http://sqwrl.stanford.edu/ontologies/built-ins/3.4/sqwrl.owl"));
            importHelper.importOntologies();
            OWLObjectProperty oWLObjectProperty = jenaOWLModel.getOWLObjectProperty(":TO");
            oWLObjectProperty.setVisible(true);
            OWLObjectProperty oWLObjectProperty2 = jenaOWLModel.getOWLObjectProperty(":FROM");
            oWLObjectProperty2.setVisible(true);
            SWRLProjectPlugin.setSWRLClassesAndPropertiesVisible(this.getProject(), false);
            ProjectManager.getProjectManager().reloadUI(true);
        }
        catch (Exception exception) {
            ProtegeUI.getModalDialogFactory().showErrorMessageDialog(jenaOWLModel, "Could not activate SWRLTab: " + exception + "\n. Your project might be in an inconsistent state now.");
            Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
        }
    }

    public void initialize() {
        this.setLabel("SWRL Rules");
        this.setIcon(SWRLIcons.getImpsIcon());
        if (!(this.getKnowledgeBase() instanceof OWLModel)) {
            this.add("Center", new JLabel("This tab can only be used with OWL projects."));
            return;
        }
        OWLModel oWLModel = (OWLModel)this.getKnowledgeBase();
        if (!SWRLProjectPlugin.isSWRLImported(oWLModel)) {
            if (this.isSWRLImported(oWLModel)) {
                this.activateSWRLFactoryIfNecessary(oWLModel);
            } else {
                this.setLayout(new FlowLayout());
                this.add(new JLabel("Your ontology needs to reference the SWRL ontology (http://www.w3.org/2003/11/swrl#)."));
                JButton jButton = new JButton("Activate SWRL...");
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        SWRLTab.this.activateSWRL();
                    }
                });
                this.add(jButton);
                if (!(oWLModel instanceof JenaOWLModel)) {
                    jButton.setEnabled(false);
                }
            }
        }
        if (SWRLProjectPlugin.isSWRLImported(oWLModel)) {
            this.panel = new SWRLTablePanel(oWLModel, null, this);
            this.add(this.panel);
        }
        SWRLProjectPlugin.adjustGUI(this.getProject());
    }

    public void reconfigure() {
        if (this.panel != null) {
            this.remove(this.panel);
            this.setLayout(new BorderLayout());
            this.add(this.panel);
        }
    }

    private void activateSWRLFactoryIfNecessary(OWLModel oWLModel) {
        SWRLJavaFactory sWRLJavaFactory = new SWRLJavaFactory(oWLModel);
        oWLModel.setOWLJavaFactory(sWRLJavaFactory);
        if (oWLModel instanceof JenaOWLModel) {
            OWLJavaFactoryUpdater.run((JenaOWLModel)oWLModel);
        }
    }

    private boolean isSWRLImported(OWLModel oWLModel) {
        boolean bl = false;
        boolean bl2 = false;
        Iterator iterator = oWLModel.getOWLOntologies().iterator();
        try {
            while (!(!iterator.hasNext() || bl2 && bl)) {
                OWLOntology oWLOntology = (OWLOntology)iterator.next();
                if (oWLOntology.getNamespace().equals("http://www.w3.org/2003/11/swrl#")) {
                    bl = true;
                }
                if (!oWLOntology.getNamespace().equals("http://www.w3.org/2003/11/swrlb#")) continue;
                bl2 = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl && bl2;
    }

    public static boolean isSuitable(Project project, Collection collection) {
        if (project.getKnowledgeBase() instanceof OWLModel) {
            return true;
        }
        collection.add("This tab can only be used with OWL projects.");
        return false;
    }
}

