/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.ui.code;

import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLVariable;
import edu.stanford.smi.protegex.owl.ui.code.OWLResourceNameMatcher;
import edu.stanford.smi.protegex.owl.ui.code.ResourceNameMatcher;
import edu.stanford.smi.protegex.owl.ui.code.SymbolTextField;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWRLResourceNameMatcher
implements ResourceNameMatcher {
    @Override
    public String getInsertString(RDFResource rDFResource) {
        if (rDFResource instanceof SWRLVariable) {
            return rDFResource.getName();
        }
        return rDFResource.getBrowserText();
    }

    @Override
    public Set<RDFResource> getMatchingResources(String string, String string2, OWLModel oWLModel) {
        HashSet<RDFResource> hashSet = new HashSet<RDFResource>();
        if (string2.endsWith("?")) {
            for (SWRLVariable sWRLVariable : oWLModel.getOWLNamedClass("swrl:Variable").getInstances(true)) {
                if (!sWRLVariable.getName().startsWith(string)) continue;
                hashSet.add(sWRLVariable);
            }
        } else if (string.length() > 0) {
            SWRLResourceNameMatcher.getMatchingOWLNamedClasses(string, hashSet, oWLModel);
            SWRLResourceNameMatcher.getMatchingOWLIndividuals(string, hashSet, oWLModel);
            SWRLResourceNameMatcher.getMatchingOWLProperties(string, hashSet, oWLModel);
        }
        return hashSet;
    }

    @Override
    public boolean isIdChar(char c) {
        return SymbolTextField.isIdChar(c);
    }

    public static void getMatchingOWLNamedClasses(String string, Set<RDFResource> set, OWLModel oWLModel) {
        HashSet<RDFResource> hashSet = new HashSet<RDFResource>();
        OWLResourceNameMatcher.addMatchingRDFSNamedClasses(string, hashSet, oWLModel);
        for (RDFSNamedClass rDFSNamedClass : hashSet) {
            if (!(rDFSNamedClass instanceof OWLNamedClass)) continue;
            set.add(rDFSNamedClass);
        }
    }

    public static void getMatchingOWLProperties(String string, Set<RDFResource> set, OWLModel oWLModel) {
        HashSet<RDFResource> hashSet = new HashSet<RDFResource>();
        OWLResourceNameMatcher.addMatchingRDFProperties(string, hashSet, oWLModel);
        for (RDFProperty rDFProperty : hashSet) {
            if (!(rDFProperty instanceof OWLProperty)) continue;
            set.add(rDFProperty);
        }
    }

    public static void getMatchingOWLIndividuals(String string, Set set, OWLModel oWLModel) {
        HashSet<RDFResource> hashSet = new HashSet<RDFResource>();
        OWLResourceNameMatcher.addMatchingRDFIndividuals(string, hashSet, oWLModel);
        for (RDFIndividual rDFIndividual : hashSet) {
            if (!(rDFIndividual instanceof OWLIndividual)) continue;
            set.add(rDFIndividual);
        }
    }
}

