/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.ui.actions;

import edu.stanford.smi.protege.model.WidgetDescriptor;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.ui.ProjectView;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.widget.TabWidget;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.swrl.ui.icons.SWRLIcons;
import edu.stanford.smi.protegex.owl.swrl.ui.tab.SWRLTab;
import edu.stanford.smi.protegex.owl.ui.actions.AbstractOWLModelAction;
import java.awt.Component;
import java.util.logging.Level;

public class EnableSWRLTabAction
extends AbstractOWLModelAction {
    private static final String SWRL_TAB_JAVA_CLASS_NAME = SWRLTab.class.getName();
    public static final String GROUP = "3_Query";

    public String getIconFileName() {
        return "SWRLImps";
    }

    public Class getIconResourceClass() {
        return SWRLIcons.class;
    }

    public String getMenubarPath() {
        return "Reasoning/3_Query";
    }

    public String getName() {
        return "Open SWRL Tab";
    }

    public boolean isSuitable(OWLModel oWLModel) {
        return true;
    }

    public void run(OWLModel oWLModel) {
        try {
            ProjectView projectView = ProjectManager.getProjectManager().getCurrentProjectView();
            TabWidget tabWidget = projectView.getTabByClassName(SWRL_TAB_JAVA_CLASS_NAME);
            if (tabWidget != null) {
                projectView.setSelectedTab(tabWidget);
                return;
            }
            WidgetDescriptor widgetDescriptor = oWLModel.getProject().getTabWidgetDescriptor(SWRL_TAB_JAVA_CLASS_NAME);
            widgetDescriptor.setVisible(true);
            projectView.addTab(widgetDescriptor);
            tabWidget = projectView.getTabByClassName(SWRL_TAB_JAVA_CLASS_NAME);
            projectView.setSelectedTab(tabWidget);
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.WARNING, "Cannot enable SWRL Tab", exception);
            ModalDialog.showMessageDialog((Component)ProjectManager.getProjectManager().getCurrentProjectView(), (String)"Cannot enable SWRLTab. See console for more details.");
        }
    }
}

