/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.model.impl;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLAtomList;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLBuiltin;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLImp;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLIndividual;
import edu.stanford.smi.protegex.owl.swrl.model.impl.AbstractSWRLIndividual;
import edu.stanford.smi.protegex.owl.swrl.model.impl.SWRLUtil;
import edu.stanford.smi.protegex.owl.swrl.parser.SWRLParseException;
import edu.stanford.smi.protegex.owl.swrl.parser.SWRLParser;
import edu.stanford.smi.protegex.owl.swrl.ui.icons.SWRLIcons;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSWRLImp
extends AbstractSWRLIndividual
implements SWRLImp {
    public static final String EMPTY_RULE_TEXT = "<EMPTY_RULE>";
    private boolean isRuleEnabled = true;
    private Map<String, Boolean> ruleGroups;
    private OWLProperty ruleEnabledProperty;
    private OWLProperty ruleGroupProperty;
    private OWLProperty ruleGroupEnabledProperty;
    private OWLNamedClass ruleGroupClass;

    public DefaultSWRLImp(KnowledgeBase knowledgeBase, FrameID frameID) {
        super(knowledgeBase, frameID);
        this.initialize();
    }

    public DefaultSWRLImp() {
        this.initialize();
    }

    private void initialize() {
        this.ruleEnabledProperty = this.getOWLModel().getOWLProperty("swrla:isRuleEnabled");
        this.ruleGroupProperty = this.getOWLModel().getOWLProperty("swrla:hasRuleGroup");
        this.ruleGroupEnabledProperty = this.getOWLModel().getOWLProperty("swrla:isRuleGroupEnabled");
        this.ruleGroupClass = this.getOWLModel().getOWLNamedClass("swrla:RuleGroup");
        this.isRuleEnabled = this.getIsRuleEnabledAnnotation();
        this.ruleGroups = this.getRuleGroupAnnotations();
    }

    @Override
    public SWRLImp createClone() {
        String string = this.getBrowserText();
        OWLModel oWLModel = (OWLModel)this.getKnowledgeBase();
        SWRLParser sWRLParser = new SWRLParser(oWLModel);
        sWRLParser.setParseOnly(false);
        try {
            return sWRLParser.parse(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean getIsRuleEnabledAnnotation() {
        if (this.ruleEnabledProperty == null) {
            return true;
        }
        Object object = this.getPropertyValue(this.ruleEnabledProperty);
        if (object == null) {
            return true;
        }
        if (!(object instanceof Boolean)) {
            return true;
        }
        return (Boolean)object;
    }

    private Map<String, Boolean> getRuleGroupAnnotations() {
        Collection collection;
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        if (this.ruleGroupProperty != null && this.ruleGroupEnabledProperty != null && (collection = this.getPropertyValues(this.ruleGroupProperty)) != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Boolean bl = Boolean.TRUE;
                OWLIndividual oWLIndividual = (OWLIndividual)iterator.next();
                Object object = oWLIndividual.getPropertyValue(this.ruleGroupEnabledProperty);
                if (object != null) {
                    bl = (Boolean)object;
                }
                hashMap.put(oWLIndividual.getName(), bl);
            }
        }
        return hashMap;
    }

    private void deleteHeadAndBody() {
        Slot slot = this.getKnowledgeBase().getSlot(":DIRECT-INSTANCES");
        Set set = this.getReferencedInstances();
        for (Object e : set) {
            SWRLIndividual sWRLIndividual;
            if (!(e instanceof SWRLIndividual) || e instanceof SWRLBuiltin || (sWRLIndividual = (SWRLIndividual)e).isDeleted()) continue;
            Collection collection = this.getKnowledgeBase().getReferences((Object)sWRLIndividual, -1);
            boolean bl = false;
            for (Reference reference : collection) {
                Frame frame;
                if (slot.equals(reference.getSlot()) || set.contains(frame = reference.getFrame()) || this.equals(frame)) continue;
                bl = true;
            }
            if (bl) continue;
            sWRLIndividual.delete();
        }
    }

    @Override
    public void deleteImp() {
        this.deleteHeadAndBody();
        this.delete();
    }

    @Override
    public SWRLAtomList getHead() {
        Object object = this.getPropertyValue(this.getOWLModel().getRDFProperty("swrl:head"));
        if (object instanceof SWRLAtomList) {
            return (SWRLAtomList)object;
        }
        return null;
    }

    @Override
    public SWRLAtomList getBody() {
        Object object = this.getPropertyValue(this.getOWLModel().getRDFProperty("swrl:body"));
        if (object instanceof SWRLAtomList) {
            return (SWRLAtomList)object;
        }
        return null;
    }

    @Override
    public void setBody(SWRLAtomList sWRLAtomList) {
        this.setPropertyValue(this.getOWLModel().getRDFProperty("swrl:body"), sWRLAtomList);
    }

    @Override
    public void setHead(SWRLAtomList sWRLAtomList) {
        this.setPropertyValue(this.getOWLModel().getRDFProperty("swrl:head"), sWRLAtomList);
    }

    @Override
    public Icon getIcon() {
        return this.isEditable() ? SWRLIcons.getImpIcon() : OWLIcons.getReadOnlyIcon(SWRLIcons.getImpIcon(), "RoundedBoxFrame");
    }

    @Override
    public Set getReferencedInstances() {
        HashSet hashSet = new HashSet();
        this.getReferencedInstances(hashSet);
        return hashSet;
    }

    @Override
    public void getReferencedInstances(Set set) {
        SWRLAtomList sWRLAtomList;
        SWRLAtomList sWRLAtomList2 = this.getHead();
        if (sWRLAtomList2 != null) {
            set.add(sWRLAtomList2);
            sWRLAtomList2.getReferencedInstances(set);
        }
        if ((sWRLAtomList = this.getBody()) != null) {
            set.add(sWRLAtomList);
            sWRLAtomList.getReferencedInstances(set);
        }
    }

    @Override
    public String getBrowserText() {
        SWRLAtomList sWRLAtomList = this.getBody();
        SWRLAtomList sWRLAtomList2 = this.getHead();
        String string = "";
        if (sWRLAtomList2 == null && sWRLAtomList == null) {
            string = string + EMPTY_RULE_TEXT;
        } else {
            string = string + SWRLUtil.getSWRLBrowserText(sWRLAtomList, "BODY");
            string = string + " \u2192 ";
            string = string + SWRLUtil.getSWRLBrowserText(sWRLAtomList2, "HEAD");
        }
        return string;
    }

    @Override
    public void setExpression(String string) throws SWRLParseException {
        SWRLParser sWRLParser = new SWRLParser(this.getOWLModel());
        sWRLParser.parse(string);
        this.deleteHeadAndBody();
        sWRLParser.setParseOnly(false);
        sWRLParser.parse(string, this);
    }

    @Override
    public boolean isEnabled() {
        return this.isRuleEnabled;
    }

    @Override
    public void enable() {
        this.enable(new HashSet<String>());
    }

    public void enable(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        this.enable(hashSet);
    }

    public void enable(Set<String> set) {
        if (set.isEmpty()) {
            if (this.ruleEnabledProperty != null) {
                this.setPropertyValue(this.ruleEnabledProperty, Boolean.TRUE);
            }
            this.isRuleEnabled = true;
        } else {
            for (String string : set) {
                OWLIndividual oWLIndividual = this.getOWLModel().getOWLIndividual(string);
                if (oWLIndividual != null && this.ruleGroupProperty != null) {
                    this.addPropertyValue(this.ruleGroupProperty, oWLIndividual);
                    oWLIndividual.addPropertyValue(this.ruleGroupEnabledProperty, Boolean.TRUE);
                }
                this.ruleGroups.put(string, Boolean.TRUE);
            }
        }
    }

    @Override
    public void disable() {
        this.disable(new HashSet<String>());
    }

    public void disable(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        this.disable(hashSet);
    }

    public void disable(Set<String> set) {
        if (set.isEmpty()) {
            if (this.ruleEnabledProperty != null) {
                this.setPropertyValue(this.ruleEnabledProperty, Boolean.FALSE);
            }
            this.isRuleEnabled = false;
        } else {
            for (String string : set) {
                OWLIndividual oWLIndividual = this.getOWLModel().getOWLIndividual(string);
                if (oWLIndividual != null && this.ruleGroupProperty != null) {
                    this.addPropertyValue(this.ruleGroupProperty, oWLIndividual);
                    oWLIndividual.addPropertyValue(this.ruleGroupEnabledProperty, Boolean.FALSE);
                }
                this.ruleGroups.put(string, Boolean.FALSE);
            }
        }
    }

    @Override
    public Set<String> getRuleGroupNames() {
        return this.ruleGroups.keySet();
    }

    @Override
    public boolean isInRuleGroup(String string) {
        return this.ruleGroups.containsKey(string);
    }

    @Override
    public boolean isInRuleGroups(Set<String> set) {
        for (String string : set) {
            if (this.ruleGroups.containsKey(string)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addRuleGroup(String string) {
        OWLIndividual oWLIndividual;
        OWLNamedClass oWLNamedClass = this.getOWLModel().getOWLNamedClass("swrla:RuleGroup");
        OWLProperty oWLProperty = this.getOWLModel().getOWLProperty("swrla:hasRuleGroup");
        OWLProperty oWLProperty2 = this.getOWLModel().getOWLProperty("swrla:isRuleGroupEnabled");
        boolean bl = false;
        if (this.isInRuleGroup(string)) {
            return true;
        }
        if (oWLNamedClass != null && (oWLIndividual = this.getOWLModel().getOWLIndividual(string)) != null && oWLProperty != null) {
            this.addPropertyValue(oWLProperty, oWLIndividual);
            oWLIndividual.addPropertyValue(oWLProperty2, Boolean.TRUE);
            this.ruleGroups.put(string, Boolean.TRUE);
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean removeRuleGroup(String string) {
        OWLProperty oWLProperty;
        OWLIndividual oWLIndividual;
        OWLNamedClass oWLNamedClass = this.getOWLModel().getOWLNamedClass("swrla:RuleGroup");
        boolean bl = false;
        if (!this.isInRuleGroup(string)) {
            return true;
        }
        if (oWLNamedClass != null && (oWLIndividual = this.getOWLModel().getOWLIndividual(string)) != null && (oWLProperty = this.getOWLModel().getOWLProperty("swrla:hasRuleGroup")) != null) {
            this.removePropertyValue(oWLProperty, oWLIndividual);
            this.ruleGroups.remove(string);
            bl = true;
        }
        return bl;
    }
}

