/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge.impl;

import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.swrl.bridge.AtomArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.DatavaluedPropertyAtom;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLDatatypeValue;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLFactory;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.DatatypeConversionException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.OWLFactoryException;
import edu.stanford.smi.protegex.owl.swrl.bridge.impl.AtomImpl;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLDatavaluedPropertyAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLVariable;

public class DatavaluedPropertyAtomImpl
extends AtomImpl
implements DatavaluedPropertyAtom {
    private String propertyName;
    private AtomArgument argument1;
    private AtomArgument argument2;

    public DatavaluedPropertyAtomImpl(OWLModel oWLModel, SWRLDatavaluedPropertyAtom sWRLDatavaluedPropertyAtom) throws OWLFactoryException, DatatypeConversionException {
        AtomArgument atomArgument;
        OWLIndividual oWLIndividual;
        String string = this.propertyName = sWRLDatavaluedPropertyAtom.getPropertyPredicate() != null ? sWRLDatavaluedPropertyAtom.getPropertyPredicate().getName() : null;
        if (this.propertyName == null) {
            throw new OWLFactoryException("empty property name in SWRLDatavaluedPropertyAtom '" + sWRLDatavaluedPropertyAtom.getBrowserText() + "'");
        }
        this.addReferencedPropertyName(this.propertyName);
        if (sWRLDatavaluedPropertyAtom.getArgument1() instanceof SWRLVariable) {
            oWLIndividual = (SWRLVariable)sWRLDatavaluedPropertyAtom.getArgument1();
            atomArgument = OWLFactory.createVariableAtomArgument(oWLIndividual.getName());
            this.addReferencedVariableName(oWLIndividual.getName());
            this.argument1 = atomArgument;
        } else if (sWRLDatavaluedPropertyAtom.getArgument1() instanceof OWLIndividual) {
            oWLIndividual = (OWLIndividual)sWRLDatavaluedPropertyAtom.getArgument1();
            atomArgument = OWLFactory.createOWLIndividual(oWLIndividual);
            this.addReferencedIndividualName(atomArgument.getIndividualName());
            this.argument1 = atomArgument;
        } else {
            throw new OWLFactoryException("unexpected argument first to datavalued property atom '" + sWRLDatavaluedPropertyAtom.getBrowserText() + "' - expecting variable or individual, got instance of " + sWRLDatavaluedPropertyAtom.getArgument1().getClass());
        }
        if (sWRLDatavaluedPropertyAtom.getArgument2() instanceof SWRLVariable) {
            oWLIndividual = (SWRLVariable)sWRLDatavaluedPropertyAtom.getArgument2();
            atomArgument = OWLFactory.createVariableAtomArgument(oWLIndividual.getName());
            this.addReferencedVariableName(oWLIndividual.getName());
            this.argument2 = atomArgument;
        } else if (sWRLDatavaluedPropertyAtom.getArgument2() instanceof RDFSLiteral) {
            this.argument2 = OWLFactory.createOWLDatatypeValue(oWLModel, (RDFSLiteral)sWRLDatavaluedPropertyAtom.getArgument2());
        } else {
            throw new OWLFactoryException("unexpected second to datavalued property atom '" + sWRLDatavaluedPropertyAtom.getBrowserText() + "' - expecting variable or literal, got instance of " + sWRLDatavaluedPropertyAtom.getArgument2().getClass());
        }
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public AtomArgument getArgument1() {
        return this.argument1;
    }

    public AtomArgument getArgument2() {
        return this.argument2;
    }

    public String toString() {
        String string = "" + this.getPropertyName() + "(" + this.getArgument1() + ", ";
        string = this.getArgument2() instanceof OWLDatatypeValue && ((OWLDatatypeValue)this.getArgument2()).isString() ? string + "\"" + this.getArgument2() + "\"" : string + "" + this.getArgument2();
        string = string + ")";
        return string;
    }
}

