/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge.impl;

import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.swrl.bridge.BuiltInArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.BuiltInAtom;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLDatatypeValue;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLFactory;
import edu.stanford.smi.protegex.owl.swrl.bridge.VariableBuiltInArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.BuiltInException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.DatatypeConversionException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.OWLFactoryException;
import edu.stanford.smi.protegex.owl.swrl.bridge.impl.AtomImpl;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLBuiltinAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLVariable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuiltInAtomImpl
extends AtomImpl
implements BuiltInAtom {
    private String builtInName;
    private List<BuiltInArgument> arguments;
    private int builtInIndex = -1;
    private boolean sqwrlVariablesUsed = false;
    private boolean isASQWRLMakeCollection = false;

    public BuiltInAtomImpl(OWLModel oWLModel, SWRLBuiltinAtom sWRLBuiltinAtom) throws OWLFactoryException, DatatypeConversionException {
        String string = this.builtInName = sWRLBuiltinAtom.getBuiltin() != null ? sWRLBuiltinAtom.getBuiltin().getName() : null;
        if (this.builtInName == null) {
            throw new OWLFactoryException("empty built-in name in SWRLBuiltinAtom: " + sWRLBuiltinAtom);
        }
        this.arguments = this.buildArgumentList(oWLModel, sWRLBuiltinAtom);
    }

    public BuiltInAtomImpl(String string, List<BuiltInArgument> list) {
        this.builtInName = string;
        this.arguments = list;
    }

    @Override
    public String getBuiltInName() {
        return this.builtInName;
    }

    @Override
    public List<BuiltInArgument> getArguments() {
        return this.arguments;
    }

    @Override
    public int getNumberOfArguments() {
        return this.arguments.size();
    }

    @Override
    public int getBuiltInIndex() {
        return this.builtInIndex;
    }

    @Override
    public void setBuiltInIndex(int n) {
        this.builtInIndex = n;
    }

    @Override
    public boolean usesSQWRLVariables() {
        return this.sqwrlVariablesUsed;
    }

    @Override
    public void setUsesSQWRLVariables() {
        this.sqwrlVariablesUsed = true;
    }

    @Override
    public boolean isSQWRLMakeCollection() {
        return this.isASQWRLMakeCollection;
    }

    @Override
    public void setIsSQWRLMakeCollection() {
        this.isASQWRLMakeCollection = true;
    }

    @Override
    public boolean usesAtLeastOneVariableOf(Set<String> set) throws BuiltInException {
        HashSet<String> hashSet = new HashSet<String>(set);
        hashSet.retainAll(this.getArgumentsVariableNames());
        return !hashSet.isEmpty();
    }

    @Override
    public boolean isArgumentAVariable(int n) throws BuiltInException {
        this.checkArgumentNumber(n);
        return this.arguments.get(n).isVariable();
    }

    @Override
    public boolean isArgumentUnbound(int n) throws BuiltInException {
        this.checkArgumentNumber(n);
        return this.arguments.get(n).isUnbound();
    }

    @Override
    public boolean hasUnboundArguments() {
        for (BuiltInArgument builtInArgument : this.arguments) {
            if (!builtInArgument.isUnbound()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<String> getUnboundArgumentVariableNames() throws BuiltInException {
        HashSet<String> hashSet = new HashSet<String>();
        for (BuiltInArgument builtInArgument : this.arguments) {
            if (!builtInArgument.isUnbound()) continue;
            hashSet.add(builtInArgument.getVariableName());
        }
        return hashSet;
    }

    @Override
    public String getArgumentVariableName(int n) throws BuiltInException {
        this.checkArgumentNumber(n);
        if (!this.arguments.get(n).isVariable()) {
            throw new BuiltInException("expecting a variable for (0-offset) argument #" + n);
        }
        return this.arguments.get(n).getVariableName();
    }

    @Override
    public Set<String> getArgumentsVariableNames() throws BuiltInException {
        HashSet<String> hashSet = new HashSet<String>();
        for (BuiltInArgument builtInArgument : this.arguments) {
            if (!builtInArgument.isVariable()) continue;
            hashSet.add(builtInArgument.getVariableName());
        }
        return hashSet;
    }

    @Override
    public void addArguments(List<BuiltInArgument> list) {
        if (this.arguments == null) {
            System.err.println("dddddadjskjd");
        }
        if (list == null) {
            System.err.println("adjskjd");
        }
        this.arguments.addAll(list);
    }

    private void checkArgumentNumber(int n) throws BuiltInException {
        if (n < 0 || n > this.arguments.size()) {
            throw new BuiltInException("invalid (0-offset) argument #" + n);
        }
    }

    private List<BuiltInArgument> buildArgumentList(OWLModel oWLModel, SWRLBuiltinAtom sWRLBuiltinAtom) throws OWLFactoryException, DatatypeConversionException {
        ArrayList<BuiltInArgument> arrayList = new ArrayList<BuiltInArgument>();
        RDFList rDFList = sWRLBuiltinAtom.getArguments();
        for (Object e : rDFList.getValues()) {
            RDFResource rDFResource;
            if (e instanceof SWRLVariable) {
                rDFResource = (SWRLVariable)e;
                VariableBuiltInArgument variableBuiltInArgument = OWLFactory.createVariableBuiltInArgument(rDFResource.getName());
                arrayList.add(variableBuiltInArgument);
                this.addReferencedVariableName(rDFResource.getName());
                continue;
            }
            if (e instanceof OWLIndividual) {
                rDFResource = (OWLIndividual)e;
                arrayList.add(OWLFactory.createOWLIndividual((OWLIndividual)rDFResource));
                this.addReferencedIndividualName(rDFResource.getName());
                continue;
            }
            if (e instanceof OWLNamedClass) {
                rDFResource = (OWLNamedClass)e;
                arrayList.add(OWLFactory.createOWLClass(oWLModel, rDFResource.getName()));
                continue;
            }
            if (e instanceof OWLProperty) {
                rDFResource = (OWLProperty)e;
                if (rDFResource.isObjectProperty()) {
                    arrayList.add(OWLFactory.createOWLObjectProperty((OWLObjectProperty)rDFResource));
                    continue;
                }
                arrayList.add(OWLFactory.createOWLDatatypeProperty((OWLDatatypeProperty)rDFResource));
                continue;
            }
            if (e instanceof RDFSLiteral) {
                arrayList.add(OWLFactory.createOWLDatatypeValue(oWLModel, (RDFSLiteral)e));
                continue;
            }
            if (e instanceof Number) {
                arrayList.add(OWLFactory.createOWLDatatypeValue((Number)e));
                continue;
            }
            if (e instanceof String) {
                arrayList.add(OWLFactory.createOWLDatatypeValue((String)e));
                continue;
            }
            throw new OWLFactoryException("unknown type for argument '" + e + "'");
        }
        return arrayList;
    }

    public String toString() {
        String string = this.getBuiltInName() + "(";
        boolean bl = true;
        for (BuiltInArgument builtInArgument : this.getArguments()) {
            if (!bl) {
                string = string + ", ";
            }
            string = builtInArgument instanceof OWLDatatypeValue && ((OWLDatatypeValue)builtInArgument).isString() ? string + "\"" + builtInArgument + "\"" : string + "" + builtInArgument;
            bl = false;
        }
        string = string + ")";
        return string;
    }
}

