/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge.builtins.temporal;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.swrl.bridge.ArgumentFactory;
import edu.stanford.smi.protegex.owl.swrl.bridge.BuiltInArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.AbstractSWRLBuiltInLibrary;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.SWRLBuiltInUtil;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.temporal.Instant;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.temporal.Period;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.temporal.Temporal;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.temporal.XSDDatetimeStringProcessor;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.temporal.exceptions.TemporalException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.BuiltInException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidBuiltInArgumentException;
import edu.stanford.smi.protegex.owl.swrl.bridge.xsd.DateTime;
import edu.stanford.smi.protegex.owl.swrl.exceptions.SWRLOWLUtilException;
import edu.stanford.smi.protegex.owl.swrl.util.SWRLOWLUtil;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWRLBuiltInLibraryImpl
extends AbstractSWRLBuiltInLibrary {
    public static final String TemporalLibraryName = "SWRLTemporalBuiltIns";
    public static final String Prefix = "temporal:";
    private static String TemporalDuration = "temporal:duration";
    private static String TemporalDurationLessThan = "temporal:durationLessThan";
    private static String TemporalDurationLessOrEqualTo = "temporal:durationLessThanOrEqualTo";
    private static String TemporalDurationEqualTo = "temporal:durationEqualTo";
    private static String TemporalDurationGreaterThan = "temporal:durationGreaterThan";
    private static String TemporalDurationGreaterThanOrEqualTo = "temporal:durationGreaterThanOrEqualTo";
    private static String TemporalEquals = "temporal:equals";
    private static String TemporalAfter = "temporal:after";
    private static String TemporalBefore = "temporal:before";
    private static String TemporalAdd = "temporal:add";
    private static String TemporalMeets = "temporal:meets";
    private static String TemporalMetBy = "temporal:metBy";
    private static String TemporalOverlaps = "temporal:overlaps";
    private static String TemporalOverlappedBy = "temporal:overlappedBy";
    private static String TemporalContains = "temporal:contains";
    private static String TemporalDuring = "temporal:during";
    private static String TemporalStarts = "temporal:starts";
    private static String TemporalStartedBy = "temporal:startedBy";
    private static String TemporalFinishes = "temporal:finishes";
    private static String TemporalFinishedBy = "temporal:finishedBy";
    private static String TemporalIntersects = "temporal:intersects";
    private static String ValidInstantClassName = "temporal:ValidInstant";
    private static String ValidPeriodClassName = "temporal:ValidPeriod";
    private static String GranularityClassName = "temporal:Granularity";
    private static String HasGranularityPropertyName = "temporal:hasGranularity";
    private static String HasTimePropertyName = "temporal:hasTime";
    private static String HasStartTimePropertyName = "temporal:hasStartTime";
    private static String HasFinishTimePropertyName = "temporal:hasFinishTime";
    private Temporal temporal;
    private ArgumentFactory argumentFactory = ArgumentFactory.getFactory();

    public SWRLBuiltInLibraryImpl() {
        super(TemporalLibraryName);
    }

    @Override
    public void reset() {
        XSDDatetimeStringProcessor xSDDatetimeStringProcessor = new XSDDatetimeStringProcessor();
        this.temporal = new Temporal(xSDDatetimeStringProcessor);
    }

    public boolean equals(List<BuiltInArgument> list) throws BuiltInException {
        return this.temporalOperation(TemporalEquals, list);
    }

    public boolean before(List<BuiltInArgument> list) throws BuiltInException {
        return this.temporalOperation(TemporalBefore, list);
    }

    public boolean after(List<BuiltInArgument> list) throws BuiltInException {
        return this.temporalOperation(TemporalAfter, list);
    }

    public boolean meets(List<BuiltInArgument> list) throws BuiltInException {
        return this.temporalOperation(TemporalMeets, list);
    }

    public boolean metBy(List<BuiltInArgument> list) throws BuiltInException {
        return this.temporalOperation(TemporalMetBy, list);
    }

    public boolean overlaps(List<BuiltInArgument> list) throws BuiltInException {
        return this.temporalOperation(TemporalOverlaps, list);
    }

    public boolean overlappedBy(List<BuiltInArgument> list) throws BuiltInException {
        return this.temporalOperation(TemporalOverlappedBy, list);
    }

    public boolean contains(List<BuiltInArgument> list) throws BuiltInException {
        return this.temporalOperation(TemporalContains, list);
    }

    public boolean during(List<BuiltInArgument> list) throws BuiltInException {
        return this.temporalOperation(TemporalDuring, list);
    }

    public boolean starts(List<BuiltInArgument> list) throws BuiltInException {
        return this.temporalOperation(TemporalStarts, list);
    }

    public boolean startedBy(List<BuiltInArgument> list) throws BuiltInException {
        return this.temporalOperation(TemporalStartedBy, list);
    }

    public boolean finishes(List<BuiltInArgument> list) throws BuiltInException {
        return this.temporalOperation(TemporalFinishes, list);
    }

    public boolean finishedBy(List<BuiltInArgument> list) throws BuiltInException {
        return this.temporalOperation(TemporalFinishedBy, list);
    }

    public boolean intersects(List<BuiltInArgument> list) throws BuiltInException {
        return this.temporalOperation(TemporalIntersects, list);
    }

    public boolean notIntersects(List<BuiltInArgument> list) throws BuiltInException {
        return !this.temporalOperation(TemporalIntersects, list);
    }

    public boolean notEquals(List<BuiltInArgument> list) throws BuiltInException {
        return !this.temporalOperation(TemporalEquals, list);
    }

    public boolean notBefore(List<BuiltInArgument> list) throws BuiltInException {
        return !this.temporalOperation(TemporalBefore, list);
    }

    public boolean notAfter(List<BuiltInArgument> list) throws BuiltInException {
        return !this.temporalOperation(TemporalAfter, list);
    }

    public boolean notMeets(List<BuiltInArgument> list) throws BuiltInException {
        return !this.temporalOperation(TemporalMeets, list);
    }

    public boolean notMetBy(List<BuiltInArgument> list) throws BuiltInException {
        return !this.temporalOperation(TemporalMetBy, list);
    }

    public boolean notOverlaps(List<BuiltInArgument> list) throws BuiltInException {
        return !this.temporalOperation(TemporalOverlaps, list);
    }

    public boolean notOverlappedBy(List<BuiltInArgument> list) throws BuiltInException {
        return !this.temporalOperation(TemporalOverlappedBy, list);
    }

    public boolean notContains(List<BuiltInArgument> list) throws BuiltInException {
        return !this.temporalOperation(TemporalContains, list);
    }

    public boolean notDuring(List<BuiltInArgument> list) throws BuiltInException {
        return !this.temporalOperation(TemporalDuring, list);
    }

    public boolean notStarts(List<BuiltInArgument> list) throws BuiltInException {
        return !this.temporalOperation(TemporalStarts, list);
    }

    public boolean notStartedBy(List<BuiltInArgument> list) throws BuiltInException {
        return !this.temporalOperation(TemporalStartedBy, list);
    }

    public boolean notFinishes(List<BuiltInArgument> list) throws BuiltInException {
        return !this.temporalOperation(TemporalFinishes, list);
    }

    public boolean notFinishedBy(List<BuiltInArgument> list) throws BuiltInException {
        return !this.temporalOperation(TemporalFinishedBy, list);
    }

    public boolean notDurationLessThan(List<BuiltInArgument> list) throws BuiltInException {
        return !this.durationLessThan(list);
    }

    public boolean notDurationLessThanOrEqualTo(List<BuiltInArgument> list) throws BuiltInException {
        return !this.durationLessThanOrEqualTo(list);
    }

    public boolean notDurationEqualTo(List<BuiltInArgument> list) throws BuiltInException {
        return !this.durationEqualTo(list);
    }

    public boolean notDurationGreaterThan(List<BuiltInArgument> list) throws BuiltInException {
        return !this.durationGreaterThan(list);
    }

    public boolean notDurationGreaterThanOrEqualTo(List<BuiltInArgument> list) throws BuiltInException {
        return !this.durationGreaterThanOrEqualTo(list);
    }

    public boolean duration(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        int n = list.size();
        SWRLBuiltInUtil.checkNumberOfArgumentsInRange(3, 4, list.size());
        SWRLBuiltInUtil.checkForUnboundNonFirstArguments(list);
        try {
            long l;
            if (n == 3) {
                int n2 = this.getArgumentAsAGranularity(2, list);
                Period period = this.getArgumentAsAPeriod(1, list, n2);
                l = period.duration(n2);
            } else {
                int n3 = this.getArgumentAsAGranularity(3, list);
                Instant instant = this.getArgumentAsAnInstant(1, list, n3);
                Instant instant2 = this.getArgumentAsAnInstant(2, list, n3);
                l = instant.duration(instant2, n3);
            }
            if (SWRLBuiltInUtil.isUnboundArgument(0, list)) {
                list.set(0, this.argumentFactory.createDatatypeValueArgument(l));
                bl = true;
            } else {
                long l2 = SWRLBuiltInUtil.getArgumentAsALong(0, list);
                bl = l2 == l;
            }
        }
        catch (TemporalException temporalException) {
            throw new BuiltInException(temporalException.getMessage());
        }
        catch (SWRLOWLUtilException sWRLOWLUtilException) {
            throw new BuiltInException(sWRLOWLUtilException.getMessage());
        }
        return bl;
    }

    public boolean durationLessThan(List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsInRange(3, 4, list.size());
        SWRLBuiltInUtil.checkForUnboundArguments(list);
        List<BuiltInArgument> list2 = SWRLBuiltInUtil.copyArguments(list);
        long l = SWRLBuiltInUtil.getArgumentAsALong(0, list);
        list2.get(0).setUnbound();
        this.duration(list2);
        long l2 = SWRLBuiltInUtil.getArgumentAsALong(0, list2);
        return l < l2;
    }

    public boolean durationLessThanOrEqualTo(List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsInRange(3, 4, list.size());
        SWRLBuiltInUtil.checkForUnboundArguments(list);
        List<BuiltInArgument> list2 = SWRLBuiltInUtil.copyArguments(list);
        long l = SWRLBuiltInUtil.getArgumentAsALong(0, list);
        list2.get(0).setUnbound();
        this.duration(list2);
        long l2 = SWRLBuiltInUtil.getArgumentAsALong(0, list2);
        return l <= l2;
    }

    public boolean durationEqualTo(List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsInRange(3, 4, list.size());
        SWRLBuiltInUtil.checkForUnboundArguments(list);
        List<BuiltInArgument> list2 = SWRLBuiltInUtil.copyArguments(list);
        long l = SWRLBuiltInUtil.getArgumentAsALong(0, list);
        list2.get(0).setUnbound();
        this.duration(list2);
        long l2 = SWRLBuiltInUtil.getArgumentAsALong(0, list2);
        return l == l2;
    }

    public boolean durationGreaterThan(List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsInRange(3, 4, list.size());
        SWRLBuiltInUtil.checkForUnboundArguments(list);
        List<BuiltInArgument> list2 = SWRLBuiltInUtil.copyArguments(list);
        long l = SWRLBuiltInUtil.getArgumentAsALong(0, list);
        list2.get(0).setUnbound();
        this.duration(list2);
        long l2 = SWRLBuiltInUtil.getArgumentAsALong(0, list2);
        return l > l2;
    }

    public boolean durationGreaterThanOrEqualTo(List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsInRange(3, 4, list.size());
        SWRLBuiltInUtil.checkForUnboundArguments(list);
        List<BuiltInArgument> list2 = SWRLBuiltInUtil.copyArguments(list);
        long l = SWRLBuiltInUtil.getArgumentAsALong(0, list);
        list2.get(0).setUnbound();
        this.duration(list2);
        long l2 = SWRLBuiltInUtil.getArgumentAsALong(0, list2);
        return l >= l2;
    }

    public boolean add(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(4, list.size());
        SWRLBuiltInUtil.checkForUnboundNonFirstArguments(list);
        try {
            long l = SWRLBuiltInUtil.getArgumentAsAnInteger(2, list);
            int n = this.getArgumentAsAGranularity(3, list);
            Instant instant = this.getArgumentAsAnInstant(1, list, n);
            instant.addGranuleCount(l, n);
            if (SWRLBuiltInUtil.isUnboundArgument(0, list)) {
                list.set(0, this.argumentFactory.createDatatypeValueArgument(new DateTime(instant.toString())));
                bl = true;
            } else {
                Instant instant2 = this.getArgumentAsAnInstant(0, list, n);
                bl = instant2.equals(instant, 6);
            }
        }
        catch (TemporalException temporalException) {
            throw new BuiltInException(temporalException.getMessage());
        }
        catch (SWRLOWLUtilException sWRLOWLUtilException) {
            throw new BuiltInException(sWRLOWLUtilException.getMessage());
        }
        return bl;
    }

    private boolean temporalOperation(String string, List<BuiltInArgument> list) throws BuiltInException {
        boolean bl;
        block17: {
            bl = false;
            int n = list.size();
            SWRLBuiltInUtil.checkNumberOfArgumentsInRange(2, 4, n);
            SWRLBuiltInUtil.checkForUnboundArguments(list);
            try {
                Period period;
                boolean bl2 = this.isArgumentAGranularity(n - 1, list);
                boolean bl3 = bl2 ? n > 3 : n > 2;
                int n2 = bl2 ? this.getArgumentAsAGranularity(n - 1, list) : 6;
                Period period2 = this.getArgumentAsAPeriod(0, list, n2);
                Period period3 = period = bl3 ? this.getTwoInstantArgumentsAsAPeriod(1, 2, list, n2) : this.getArgumentAsAPeriod(1, list, n2);
                if (string.equals(TemporalEquals)) {
                    bl = period2.equals(period, n2);
                    break block17;
                }
                if (string.equals(TemporalBefore)) {
                    bl = period2.before(period, n2);
                    break block17;
                }
                if (string.equals(TemporalAfter)) {
                    bl = period2.after(period, n2);
                    break block17;
                }
                if (string.equals(TemporalMeets)) {
                    bl = period2.meets(period, n2);
                    break block17;
                }
                if (string.equals(TemporalMetBy)) {
                    bl = period2.met_by(period, n2);
                    break block17;
                }
                if (string.equals(TemporalOverlaps)) {
                    bl = period2.overlaps(period, n2);
                    break block17;
                }
                if (string.equals(TemporalOverlappedBy)) {
                    bl = period2.overlapped_by(period, n2);
                    break block17;
                }
                if (string.equals(TemporalContains)) {
                    bl = period2.contains(period, n2);
                    break block17;
                }
                if (string.equals(TemporalDuring)) {
                    bl = period2.during(period, n2);
                    break block17;
                }
                if (string.equals(TemporalStarts)) {
                    bl = period2.starts(period, n2);
                    break block17;
                }
                if (string.equals(TemporalStartedBy)) {
                    bl = period2.started_by(period, n2);
                    break block17;
                }
                if (string.equals(TemporalFinishes)) {
                    bl = period2.finishes(period, n2);
                    break block17;
                }
                if (string.equals(TemporalFinishedBy)) {
                    bl = period2.finished_by(period, n2);
                    break block17;
                }
                if (string.equals(TemporalIntersects)) {
                    bl = period2.intersects(period, n2);
                    break block17;
                }
                throw new BuiltInException("internal error - unknown temporal operator '" + string + "'");
            }
            catch (TemporalException temporalException) {
                throw new BuiltInException(temporalException.getMessage());
            }
            catch (SWRLOWLUtilException sWRLOWLUtilException) {
                throw new BuiltInException(sWRLOWLUtilException.getMessage());
            }
        }
        return bl;
    }

    private Period getTwoInstantArgumentsAsAPeriod(int n, int n2, List<BuiltInArgument> list, int n3) throws BuiltInException, TemporalException, SWRLOWLUtilException {
        if (n >= list.size()) {
            throw new InvalidBuiltInArgumentException(n, "out of range");
        }
        if (n2 >= list.size()) {
            throw new InvalidBuiltInArgumentException(n2, "out of range");
        }
        Instant instant = this.getArgumentAsAnInstant(n, list, n3);
        Instant instant2 = this.getArgumentAsAnInstant(n2, list, n3);
        Period period = new Period(this.temporal, instant, instant2, n3);
        return period;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Period getArgumentAsAPeriod(int n, List<BuiltInArgument> list, int n2) throws BuiltInException, TemporalException, SWRLOWLUtilException {
        OWLModel oWLModel = this.getInvokingBridge().getOWLModel();
        Period period = null;
        if (SWRLBuiltInUtil.isArgumentALiteral(n, list)) {
            String string = SWRLBuiltInUtil.getArgumentAsAString(n, list);
            return new Period(this.temporal, string, string, n2);
        }
        if (!SWRLBuiltInUtil.isArgumentAnIndividual(n, list)) throw new InvalidBuiltInArgumentException(n, "expecting an XSD datetime or " + ValidInstantClassName + " or " + ValidPeriodClassName + " individual" + ", got '" + list.get(n) + "'");
        String string = SWRLBuiltInUtil.getArgumentAsAnIndividualName(n, list);
        if (SWRLOWLUtil.isIndividualOfClass(oWLModel, string, ValidInstantClassName)) {
            Instant instant = this.getValidInstant(oWLModel, string, n2);
            return new Period(this.temporal, instant, n2);
        }
        if (!SWRLOWLUtil.isIndividualOfClass(oWLModel, string, ValidPeriodClassName)) throw new InvalidBuiltInArgumentException(n, "individual '" + string + "' is not a " + ValidInstantClassName + " or " + ValidPeriodClassName);
        return this.getValidPeriod(oWLModel, string, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Instant getArgumentAsAnInstant(int n, List<BuiltInArgument> list, int n2) throws BuiltInException, TemporalException, SWRLOWLUtilException {
        OWLModel oWLModel = this.getInvokingBridge().getOWLModel();
        Instant instant = null;
        if (SWRLBuiltInUtil.isArgumentALiteral(n, list)) {
            String string = SWRLBuiltInUtil.getArgumentAsAString(n, list);
            return new Instant(this.temporal, string, n2);
        }
        if (!SWRLBuiltInUtil.isArgumentAnIndividual(n, list)) throw new InvalidBuiltInArgumentException(n, "expecting an XSD datetime or " + ValidInstantClassName + " individual" + ", got '" + list.get(n) + "'");
        String string = SWRLBuiltInUtil.getArgumentAsAnIndividualName(n, list);
        if (!SWRLOWLUtil.isIndividualOfClass(oWLModel, string, ValidInstantClassName)) throw new InvalidBuiltInArgumentException(n, "individual '" + string + "' is not a " + ValidInstantClassName);
        return this.getValidInstant(oWLModel, string, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getArgumentAsAGranularity(int n, List<BuiltInArgument> list) throws TemporalException, BuiltInException, SWRLOWLUtilException {
        OWLModel oWLModel = this.getInvokingBridge().getOWLModel();
        int n2 = -1;
        if (SWRLBuiltInUtil.isArgumentALiteral(n, list)) {
            String string = SWRLBuiltInUtil.getArgumentAsAString(n, list);
            return Temporal.getIntegerGranularityRepresentation(string);
        }
        if (!SWRLBuiltInUtil.isArgumentAnIndividual(n, list)) throw new InvalidBuiltInArgumentException(n, "expecting a " + GranularityClassName + " individual" + ", got '" + list.get(n) + "'");
        String string = SWRLBuiltInUtil.getArgumentAsAnIndividualName(n, list);
        if (!SWRLOWLUtil.isIndividualOfClass(oWLModel, string, GranularityClassName)) throw new InvalidBuiltInArgumentException(n, "individual '" + string + "' is not a " + GranularityClassName);
        int n3 = string.indexOf(58);
        String string2 = n3 == -1 ? string : string.substring(n3 + 1, string.length());
        return Temporal.getIntegerGranularityRepresentation(string2);
    }

    private boolean isArgumentAGranularity(int n, List<BuiltInArgument> list) throws BuiltInException, SWRLOWLUtilException {
        OWLModel oWLModel = this.getInvokingBridge().getOWLModel();
        boolean bl = false;
        if (SWRLBuiltInUtil.isArgumentALiteral(n, list)) {
            String string = SWRLBuiltInUtil.getArgumentAsAString(n, list);
            bl = Temporal.isValidGranularityString(string);
        } else if (SWRLBuiltInUtil.isArgumentAnIndividual(n, list)) {
            String string = SWRLBuiltInUtil.getArgumentAsAnIndividualName(n, list);
            bl = SWRLOWLUtil.isIndividualOfClass(oWLModel, string, GranularityClassName);
        }
        return bl;
    }

    private Instant getValidInstant(OWLModel oWLModel, String string, int n) throws BuiltInException, TemporalException, SWRLOWLUtilException {
        String string2 = SWRLOWLUtil.getDatavaluedPropertyValueAsString(oWLModel, string, HasTimePropertyName);
        return new Instant(this.temporal, string2, n);
    }

    private Period getValidPeriod(OWLModel oWLModel, String string, int n) throws BuiltInException, TemporalException, SWRLOWLUtilException {
        String string2 = SWRLOWLUtil.getDatavaluedPropertyValueAsString(oWLModel, string, HasStartTimePropertyName);
        String string3 = SWRLOWLUtil.getDatavaluedPropertyValueAsString(oWLModel, string, HasFinishTimePropertyName);
        return new Period(this.temporal, string2, string3, n);
    }

    private int getGranularity(OWLModel oWLModel, String string) throws BuiltInException, TemporalException, SWRLOWLUtilException {
        return SWRLOWLUtil.getDatavaluedPropertyValueAsInteger(oWLModel, string, HasGranularityPropertyName);
    }
}

