/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge.builtins.temporal;

import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.temporal.Temporal;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.temporal.exceptions.TemporalException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;

public abstract class DatetimeStringProcessor {
    protected SimpleDateFormat dateFormat;
    protected String delimiters;
    protected int[] gTokenIndex;
    protected String[] datetimeRoundDownPadding;
    protected String[] datetimeRoundUpPadding;

    public DatetimeStringProcessor(SimpleDateFormat simpleDateFormat, String string, int[] nArray, String[] stringArray, String[] stringArray2) {
        this.dateFormat = simpleDateFormat;
        this.delimiters = string;
        this.gTokenIndex = (int[])nArray.clone();
        this.datetimeRoundUpPadding = (String[])stringArray2.clone();
        this.datetimeRoundDownPadding = (String[])stringArray.clone();
    }

    protected abstract String constructDatetimeString(long var1) throws TemporalException;

    public String granuleCount2DatetimeString(long l, int n) throws TemporalException {
        Temporal.checkGranularity(n);
        long l2 = Temporal.convertGranuleCount(l, n, 6);
        if (l2 > 12219292800000L) {
            l2 -= 864000000L;
        }
        return this.constructDatetimeString(l2 -= 62167363200000L);
    }

    public String expressDatetimeStringAtGranularity(String string, int n, boolean bl) throws TemporalException {
        String string2 = this.stripDatetimeString(string, n);
        return this.padDatetimeString(string2, bl);
    }

    public String expressDatetimeStringAtGranularity(String string, int n) throws TemporalException {
        return this.expressDatetimeStringAtGranularity(string, n, false);
    }

    public void checkDatetimeString(String string) throws TemporalException {
        String string2 = string.trim();
        Date date = this.dateFormat.parse(string2, new ParsePosition(0));
        if (date == null) {
            Temporal.throwInvalidDatetimeStringException(string);
        }
    }

    public String normalizeDatetimeString(String string, int n, boolean bl) throws TemporalException {
        String string2 = "";
        String string3 = string.trim();
        string3 = this.stripDatetimeString(string3, n);
        string2 = this.padDatetimeString(string3, bl);
        this.checkDatetimeString(string2);
        return string2;
    }

    public String normalizeDatetimeString(String string, int n) throws TemporalException {
        return this.normalizeDatetimeString(string, n, false);
    }

    public String padDatetimeString(String string, boolean bl) throws TemporalException {
        String string2;
        String string3 = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string3, this.delimiters);
        int n = stringTokenizer.countTokens();
        if (n == 0) {
            Temporal.throwInvalidDatetimeStringException(string);
        }
        int n2 = n - 1;
        String string4 = stringTokenizer.nextToken().trim();
        long l = Long.parseLong(string4);
        if (bl) {
            if (n2 != 1) {
                string2 = string3 + this.datetimeRoundUpPadding[n2];
            } else {
                string4 = stringTokenizer.nextToken().trim();
                long l2 = Long.parseLong(string4);
                Temporal.checkMonthCount(l2);
                int n3 = Temporal.getDaysInMonth(l2);
                if (Temporal.isLeapYear(l) && l2 == 2L) {
                    ++n3;
                }
                string2 = string3 + "-" + n3 + this.datetimeRoundUpPadding[2];
            }
        } else {
            string2 = string3 + this.datetimeRoundDownPadding[n2];
        }
        return string2;
    }

    public String stripDatetimeString(String string, int n) throws TemporalException {
        String string2 = "";
        Temporal.checkGranularity(n);
        StringTokenizer stringTokenizer = new StringTokenizer(string, this.delimiters, true);
        int n2 = stringTokenizer.countTokens();
        if (n2 == 0) {
            Temporal.throwInvalidDatetimeStringException(string);
        }
        if (n2 <= this.gTokenIndex[n]) {
            string2 = string;
        } else {
            try {
                for (int i = 0; i < this.gTokenIndex[n] && stringTokenizer.hasMoreTokens(); ++i) {
                    string2 = string2 + stringTokenizer.nextToken();
                }
            }
            catch (Exception exception) {
                Temporal.throwInvalidDatetimeStringException(string);
            }
        }
        return string2;
    }

    public long getYears(String string) throws TemporalException {
        return this.getTimeComponent(string, 0);
    }

    public long getMonths(String string) throws TemporalException {
        return this.getTimeComponent(string, 1);
    }

    public long getDays(String string) throws TemporalException {
        return this.getTimeComponent(string, 2);
    }

    public long getHours(String string) throws TemporalException {
        return this.getTimeComponent(string, 3);
    }

    public long getMinutes(String string) throws TemporalException {
        return this.getTimeComponent(string, 4);
    }

    public long getSeconds(String string) throws TemporalException {
        return this.getTimeComponent(string, 5);
    }

    public long getMilliseconds(String string) throws TemporalException {
        return this.getTimeComponent(string, 6);
    }

    private long getTimeComponent(String string, int n) throws TemporalException {
        long l = -1L;
        Temporal.checkGranularity(n);
        StringTokenizer stringTokenizer = new StringTokenizer(string, this.delimiters, true);
        int n2 = stringTokenizer.countTokens();
        if (n2 == 0) {
            Temporal.throwInvalidDatetimeStringException(string);
        }
        if (n2 < this.gTokenIndex[n]) {
            throw new TemporalException("Cannot extract '" + Temporal.getStringGranularityRepresentation(n) + "' from incomplete datetime '" + string + "'");
        }
        try {
            int n3 = 1;
            while (n3++ < this.gTokenIndex[n]) {
                stringTokenizer.nextToken();
            }
            l = new Long(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            Temporal.throwInvalidDatetimeStringException(string);
        }
        return l;
    }
}

