/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge.builtins.swrlxml;

import edu.stanford.smi.protegex.owl.swrl.bridge.BuiltInArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLIndividual;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.AbstractSWRLBuiltInLibrary;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.SWRLBuiltInUtil;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.swrlxml.XMLMapper;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.swrlxml.XMLMapperException;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.swrlxml.XMLProcessor;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.swrlxml.XMLProcessorException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.BuiltInException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWRLBuiltInLibraryImpl
extends AbstractSWRLBuiltInLibrary {
    private static String SWRLXMLLibraryName = "SWRLXMLBuiltIns";
    private XMLProcessor xmlProcessor;
    private XMLMapper xmlMapper;
    private Map<String, OWLIndividual> mappedSources;

    public SWRLBuiltInLibraryImpl() {
        super(SWRLXMLLibraryName);
        this.reset();
    }

    @Override
    public void reset() {
        this.xmlProcessor = new XMLProcessor();
        this.xmlMapper = new XMLMapper();
        this.mappedSources = new HashMap<String, OWLIndividual>();
    }

    public boolean makeXMLDocument(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl;
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(2, list.size());
        SWRLBuiltInUtil.checkForUnboundNonFirstArguments(list);
        if (SWRLBuiltInUtil.isUnboundArgument(0, list)) {
            String string = SWRLBuiltInUtil.getArgumentAsAString(1, list);
            OWLIndividual oWLIndividual = null;
            if (!this.mappedSources.containsKey(string)) {
                try {
                    Document document = this.xmlProcessor.processXMLStream(string);
                    oWLIndividual = this.xmlMapper.document2XMLDocumentMapping(document, this.getInvokingBridge());
                    this.mappedSources.put(string, oWLIndividual);
                }
                catch (XMLProcessorException xMLProcessorException) {
                    throw new BuiltInException("error processing XML stream '" + string + "': " + xMLProcessorException.getMessage());
                }
                catch (XMLMapperException xMLMapperException) {
                    throw new BuiltInException("error mapping XML stream '" + string + "': " + xMLMapperException.getMessage());
                }
            } else {
                oWLIndividual = this.mappedSources.get(string);
            }
            list.set(0, oWLIndividual);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }
}

