/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge.builtins.sqwrl;

import edu.stanford.smi.protegex.owl.swrl.bridge.Argument;
import edu.stanford.smi.protegex.owl.swrl.bridge.ArgumentFactory;
import edu.stanford.smi.protegex.owl.swrl.bridge.BuiltInArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.ClassArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.DatatypeValueArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.IndividualArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLClass;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLDatatypeValue;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLIndividual;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLProperty;
import edu.stanford.smi.protegex.owl.swrl.bridge.PropertyArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.AbstractSWRLBuiltInLibrary;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.SWRLBuiltInUtil;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.BuiltInException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidBuiltInArgumentException;
import edu.stanford.smi.protegex.owl.swrl.exceptions.InvalidRuleNameException;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.ClassValue;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.DatatypeValue;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.ObjectValue;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.PropertyValue;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.SQWRLNames;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.impl.ResultImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWRLBuiltInLibraryImpl
extends AbstractSWRLBuiltInLibrary {
    private HashMap<String, Set<BuiltInArgument>> sets;
    private HashMap<String, List<BuiltInArgument>> lists;
    private HashMap<String, SortedSet<BuiltInArgument>> sortedSets;
    private HashSet<String> invocationPatterns;
    private ArgumentFactory argumentFactory;

    public SWRLBuiltInLibraryImpl() {
        super(SQWRLNames.SQWRLBuiltInLibraryName);
    }

    @Override
    public void reset() {
        this.sets = new HashMap();
        this.lists = new HashMap();
        this.sortedSets = new HashMap();
        this.invocationPatterns = new HashSet();
        this.argumentFactory = ArgumentFactory.getFactory();
    }

    public boolean select(List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkForUnboundArguments(list);
        SWRLBuiltInUtil.checkNumberOfArgumentsAtLeast(1, list.size());
        ResultImpl resultImpl = this.getResult(this.getInvokingRuleName());
        if (!resultImpl.isRowOpen()) {
            resultImpl.openRow();
        }
        int n = 0;
        for (BuiltInArgument builtInArgument : list) {
            if (builtInArgument instanceof DatatypeValueArgument) {
                resultImpl.addRowData((DatatypeValue)((Object)builtInArgument));
            } else if (builtInArgument instanceof IndividualArgument) {
                resultImpl.addRowData((ObjectValue)((Object)builtInArgument));
            } else if (builtInArgument instanceof ClassArgument) {
                resultImpl.addRowData((ClassValue)((Object)builtInArgument));
            } else if (builtInArgument instanceof PropertyArgument) {
                resultImpl.addRowData((PropertyValue)((Object)builtInArgument));
            } else {
                throw new InvalidBuiltInArgumentException(n, "unknown type '" + builtInArgument.getClass() + "'");
            }
            ++n;
        }
        return false;
    }

    public boolean selectDistinct(List<BuiltInArgument> list) throws BuiltInException {
        return this.select(list);
    }

    public boolean count(List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkForUnboundArguments(list);
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(1, list.size());
        ResultImpl resultImpl = this.getResult(this.getInvokingRuleName());
        BuiltInArgument builtInArgument = list.get(0);
        if (!resultImpl.isRowOpen()) {
            resultImpl.openRow();
        }
        if (builtInArgument instanceof OWLDatatypeValue) {
            resultImpl.addRowData((DatatypeValue)((Object)builtInArgument));
        } else if (builtInArgument instanceof OWLIndividual) {
            resultImpl.addRowData((ObjectValue)((Object)builtInArgument));
        } else if (builtInArgument instanceof OWLClass) {
            resultImpl.addRowData((ClassValue)((Object)builtInArgument));
        } else if (builtInArgument instanceof OWLProperty) {
            resultImpl.addRowData((PropertyValue)((Object)builtInArgument));
        } else {
            throw new InvalidBuiltInArgumentException(0, "unknown type '" + builtInArgument.getClass() + "'");
        }
        return false;
    }

    public boolean countDistinct(List<BuiltInArgument> list) throws BuiltInException {
        return this.count(list);
    }

    public boolean min(List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkForUnboundArguments(list);
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(1, list.size());
        ResultImpl resultImpl = this.getResult(this.getInvokingRuleName());
        BuiltInArgument builtInArgument = list.get(0);
        if (!resultImpl.isRowOpen()) {
            resultImpl.openRow();
        }
        if (!(builtInArgument instanceof OWLDatatypeValue) || !((OWLDatatypeValue)builtInArgument).isNumeric()) {
            throw new InvalidBuiltInArgumentException(0, "expecting numeric literal, got '" + builtInArgument + "'");
        }
        resultImpl.addRowData((DatatypeValue)((Object)builtInArgument));
        return false;
    }

    public boolean max(List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkForUnboundArguments(list);
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(1, list.size());
        ResultImpl resultImpl = this.getResult(this.getInvokingRuleName());
        BuiltInArgument builtInArgument = list.get(0);
        if (!resultImpl.isRowOpen()) {
            resultImpl.openRow();
        }
        if (!(builtInArgument instanceof OWLDatatypeValue) || !((OWLDatatypeValue)builtInArgument).isNumeric()) {
            throw new InvalidBuiltInArgumentException(0, "expecting numeric literal, got '" + builtInArgument + "'");
        }
        resultImpl.addRowData((DatatypeValue)((Object)builtInArgument));
        return false;
    }

    public boolean sum(List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkForUnboundArguments(list);
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(1, list.size());
        ResultImpl resultImpl = this.getResult(this.getInvokingRuleName());
        BuiltInArgument builtInArgument = list.get(0);
        if (!resultImpl.isRowOpen()) {
            resultImpl.openRow();
        }
        if (!(builtInArgument instanceof OWLDatatypeValue) || !((OWLDatatypeValue)builtInArgument).isNumeric()) {
            throw new InvalidBuiltInArgumentException(0, "expecting numeric literal, got '" + builtInArgument + "'");
        }
        resultImpl.addRowData((DatatypeValue)((Object)builtInArgument));
        return false;
    }

    public boolean avg(List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkForUnboundArguments(list);
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(1, list.size());
        ResultImpl resultImpl = this.getResult(this.getInvokingRuleName());
        Argument argument = list.get(0);
        if (!resultImpl.isRowOpen()) {
            resultImpl.openRow();
        }
        if (!(argument instanceof OWLDatatypeValue) || !((OWLDatatypeValue)argument).isNumeric()) {
            throw new InvalidBuiltInArgumentException(0, "expecting numeric literal, got '" + argument + "'");
        }
        resultImpl.addRowData((DatatypeValue)((Object)argument));
        return false;
    }

    public boolean columnNames(List<BuiltInArgument> list) throws BuiltInException {
        return false;
    }

    public boolean orderBy(List<BuiltInArgument> list) throws BuiltInException {
        return false;
    }

    public boolean orderByDescending(List<BuiltInArgument> list) throws BuiltInException {
        return false;
    }

    public boolean makeSet(List<BuiltInArgument> list) throws BuiltInException {
        String string = this.getCollectionIDInMake(list);
        BuiltInArgument builtInArgument = list.get(1);
        HashSet<BuiltInArgument> hashSet = this.sets.containsKey(string) ? this.sets.get(string) : new HashSet<BuiltInArgument>();
        String string2 = SWRLBuiltInUtil.createInvocationPattern(this.getInvokingBridge(), this.getInvokingRuleName(), this.getInvokingBuiltInIndex(), list.subList(1, list.size()));
        if (!this.invocationPatterns.contains(string2)) {
            this.invocationPatterns.add(string2);
            hashSet.add(builtInArgument);
            if (!this.sets.containsKey(string)) {
                this.sets.put(string, hashSet);
            }
        }
        if (SWRLBuiltInUtil.isUnboundArgument(0, list)) {
            list.set(0, this.argumentFactory.createDatatypeValueArgument(string));
        }
        return true;
    }

    public boolean makeList(List<BuiltInArgument> list) throws BuiltInException {
        String string = this.getCollectionIDInMake(list);
        ArrayList<BuiltInArgument> arrayList = this.lists.containsKey(string) ? this.lists.get(string) : new ArrayList<BuiltInArgument>();
        BuiltInArgument builtInArgument = list.get(1);
        String string2 = SWRLBuiltInUtil.createInvocationPattern(this.getInvokingBridge(), this.getInvokingRuleName(), this.getInvokingBuiltInIndex(), list.subList(1, list.size()));
        if (!this.invocationPatterns.contains(string2)) {
            this.invocationPatterns.add(string2);
            arrayList.add(builtInArgument);
            if (!this.lists.containsKey(string)) {
                this.lists.put(string, arrayList);
            }
        }
        if (SWRLBuiltInUtil.isUnboundArgument(0, list)) {
            list.set(0, this.argumentFactory.createDatatypeValueArgument(string));
        }
        return true;
    }

    public boolean makeSortedSet(List<BuiltInArgument> list) throws BuiltInException {
        String string = this.getCollectionIDInMake(list);
        BuiltInArgument builtInArgument = list.get(1);
        TreeSet<BuiltInArgument> treeSet = this.sortedSets.containsKey(string) ? this.sortedSets.get(string) : new TreeSet<BuiltInArgument>();
        String string2 = SWRLBuiltInUtil.createInvocationPattern(this.getInvokingBridge(), this.getInvokingRuleName(), this.getInvokingBuiltInIndex(), list.subList(1, list.size()));
        if (!this.invocationPatterns.contains(string2)) {
            this.invocationPatterns.add(string2);
            treeSet.add(builtInArgument);
            if (!this.sortedSets.containsKey(string)) {
                this.sortedSets.put(string, treeSet);
            }
        }
        if (SWRLBuiltInUtil.isUnboundArgument(0, list)) {
            list.set(0, this.argumentFactory.createDatatypeValueArgument(string));
        }
        return true;
    }

    public boolean isEmpty(List<BuiltInArgument> list) throws BuiltInException {
        String string = this.getCollectionIDInOperation(list, 0, 1);
        boolean bl = false;
        if (this.sets.containsKey(string)) {
            bl = this.sets.get(string).size() != 0;
        } else if (this.lists.containsKey(string)) {
            bl = this.lists.get(string).size() != 0;
        } else if (this.sortedSets.containsKey(string)) {
            bl = this.sortedSets.get(string).size() != 0;
        } else {
            throw new BuiltInException("internal error: no collection found for ID '" + string + "'");
        }
        return bl;
    }

    public boolean size(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl;
        String string = this.getCollectionIDInOperation(list, 1, 2);
        long l = -1L;
        if (this.isSet(string)) {
            l = this.sets.get(string).size();
        } else if (this.isSortedSet(string)) {
            l = this.sortedSets.get(string).size();
        } else if (this.isList(string)) {
            l = this.lists.get(string).size();
        } else {
            throw new BuiltInException("internal error: no collection found for ID '" + string + "'");
        }
        if (SWRLBuiltInUtil.isUnboundArgument(0, list)) {
            list.set(0, this.argumentFactory.createDatatypeValueArgument(l));
            bl = true;
        } else {
            long l2 = SWRLBuiltInUtil.getArgumentAsALong(0, list);
            bl = l2 == l;
        }
        return bl;
    }

    public boolean intersect(List<BuiltInArgument> list) throws BuiltInException {
        String string = this.getCollectionIDInOperation(list, 1, 3);
        String string2 = this.getCollectionIDInOperation(list, 2, 3);
        throw new BuiltInException("not implemented");
    }

    public boolean union(List<BuiltInArgument> list) throws BuiltInException {
        throw new BuiltInException("not implemented");
    }

    public boolean contains(List<BuiltInArgument> list) throws BuiltInException {
        throw new BuiltInException("not implemented");
    }

    public boolean except(List<BuiltInArgument> list) throws BuiltInException {
        throw new BuiltInException("not implemented");
    }

    public boolean nth(List<BuiltInArgument> list) throws BuiltInException {
        throw new BuiltInException("not implemented");
    }

    public boolean first(List<BuiltInArgument> list) throws BuiltInException {
        throw new BuiltInException("not implemented");
    }

    public boolean last(List<BuiltInArgument> list) throws BuiltInException {
        throw new BuiltInException("not implemented");
    }

    private boolean isSet(String string) {
        return this.sets.containsKey(string);
    }

    private boolean isList(String string) {
        return this.lists.containsKey(string);
    }

    private boolean isSortedSet(String string) {
        return this.sortedSets.containsKey(string);
    }

    private String getCollectionIDInMake(List<BuiltInArgument> list) throws BuiltInException {
        return this.getCollectionID(list, 0, 2);
    }

    private String getCollectionIDInOperation(List<BuiltInArgument> list, int n, int n2) throws BuiltInException {
        return this.getCollectionID(list, n, n2);
    }

    private String getCollectionID(List<BuiltInArgument> list, int n, int n2) throws BuiltInException {
        String string = this.getInvokingRuleName();
        String string2 = SWRLBuiltInUtil.getVariableName(n, list);
        boolean bl = list.size() > n2;
        String string3 = !bl ? "" : SWRLBuiltInUtil.createInvocationPattern(this.getInvokingBridge(), string, 0, list.subList(n2, list.size()));
        return string + ":" + string2 + ":" + string3;
    }

    private ResultImpl getResult(String string) throws BuiltInException {
        ResultImpl resultImpl = null;
        try {
            if (this.getInvokingBridge().getRule(string) != null) {
                resultImpl = this.getInvokingBridge().getRule(string).getSQWRLResult();
            }
        }
        catch (InvalidRuleNameException invalidRuleNameException) {
            // empty catch block
        }
        return resultImpl;
    }

    private void throwInternalSQWRLException(String string) throws BuiltInException {
        throw new BuiltInException("internal SQWRL engine exception: " + string);
    }
}

