/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge.builtins.ddm;

import edu.stanford.smi.protegex.owl.swrl.bridge.ArgumentFactory;
import edu.stanford.smi.protegex.owl.swrl.bridge.BuiltInArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.Mapper;
import edu.stanford.smi.protegex.owl.swrl.bridge.MultiArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLClass;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLDatatypeValue;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLFactory;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLIndividual;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLProperty;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.AbstractSWRLBuiltInLibrary;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.SWRLBuiltInUtil;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.BuiltInException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.SWRLRuleEngineBridgeException;
import edu.stanford.smi.protegex.owl.swrl.ddm.DDMFactory;
import edu.stanford.smi.protegex.owl.swrl.ddm.Database;
import edu.stanford.smi.protegex.owl.swrl.ddm.DatabaseConnection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWRLBuiltInLibraryImpl
extends AbstractSWRLBuiltInLibrary {
    private static String SWRLDDMLibraryName = "SWRLDDMBuiltIns";
    private ArgumentFactory argumentFactory = ArgumentFactory.getFactory();

    public SWRLBuiltInLibraryImpl() {
        super(SWRLDDMLibraryName);
    }

    @Override
    public void reset() {
    }

    public boolean makeDatabase(List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(7, list.size());
        String string = SWRLBuiltInUtil.getArgumentAsAString(1, list);
        String string2 = SWRLBuiltInUtil.getArgumentAsAString(2, list);
        String string3 = SWRLBuiltInUtil.getArgumentAsAString(3, list);
        int n = SWRLBuiltInUtil.getArgumentAsAnInteger(4, list);
        String string4 = SWRLBuiltInUtil.getArgumentAsAString(5, list);
        String string5 = SWRLBuiltInUtil.getArgumentAsAString(6, list);
        Database database = DDMFactory.createDatabase(string, string2, string3, n);
        try {
            DatabaseConnection databaseConnection = DDMFactory.createDatabaseConnection(database, string4, string5);
        }
        catch (SQLException sQLException) {
            throw new BuiltInException("SQL exception when connecting to database: " + sQLException.getMessage());
        }
        return true;
    }

    public boolean mapOWLClass(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        Object var5_3 = null;
        Set<Object> set = new HashSet();
        SWRLBuiltInUtil.checkNumberOfArgumentsAtLeast(2, list.size());
        String string = SWRLBuiltInUtil.getArgumentAsAClassName(0, list);
        if (!this.getInvokingBridge().hasMapper()) {
            return false;
        }
        boolean bl2 = SWRLBuiltInUtil.isUnboundArgument(1, list);
        if (!bl2) {
            throw new BuiltInException("bound arguments not yet implemented, class = '" + string + "'");
        }
        try {
            OWLClass oWLClass = OWLFactory.getOWLClass(string);
            Mapper mapper = this.getInvokingBridge().getMapper();
            if (!mapper.isMapped(oWLClass)) {
                return false;
            }
            set = mapper.mapOWLClass(oWLClass);
            if (bl2) {
                MultiArgument multiArgument = this.argumentFactory.createMultiArgument(SWRLBuiltInUtil.getVariableName(1, list));
                for (OWLIndividual oWLIndividual : set) {
                    multiArgument.addArgument(oWLIndividual);
                }
                list.set(1, multiArgument);
                bl = !multiArgument.hasNoArguments();
            } else {
                bl = false;
            }
        }
        catch (SWRLRuleEngineBridgeException sWRLRuleEngineBridgeException) {
            throw new BuiltInException("error mapping OWL class '" + string + "': " + sWRLRuleEngineBridgeException.getMessage());
        }
        return bl;
    }

    public boolean mapOWLObjectProperty(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        OWLIndividual oWLIndividual = null;
        OWLIndividual oWLIndividual2 = null;
        Set<Object> set = new HashSet();
        SWRLBuiltInUtil.checkNumberOfArgumentsAtLeast(1, list.size());
        SWRLBuiltInUtil.checkForUnboundArguments(list);
        String string = SWRLBuiltInUtil.getArgumentAsAPropertyName(0, list);
        if (!this.getInvokingBridge().hasMapper()) {
            return false;
        }
        boolean bl2 = list.size() > 1;
        boolean bl3 = list.size() > 2;
        try {
            Mapper mapper;
            OWLObjectProperty oWLObjectProperty = OWLFactory.getOWLObjectProperty(string);
            if (bl2) {
                oWLIndividual = OWLFactory.getOWLIndividual(SWRLBuiltInUtil.getArgumentAsAnIndividualName(1, list));
            }
            if (bl3) {
                oWLIndividual2 = OWLFactory.getOWLIndividual(SWRLBuiltInUtil.getArgumentAsAnIndividualName(2, list));
            }
            if (!(mapper = this.getInvokingBridge().getMapper()).isMapped(oWLObjectProperty)) {
                return false;
            }
            set = !bl2 && !bl3 ? mapper.mapOWLObjectProperty(oWLObjectProperty) : (bl2 && !bl3 ? mapper.mapOWLObjectProperty(oWLObjectProperty, oWLIndividual) : mapper.mapOWLObjectProperty(oWLObjectProperty, oWLIndividual, oWLIndividual2));
            if (!set.isEmpty()) {
                this.getInvokingBridge().createOWLObjectPropertyAssertionAxioms(set);
            }
        }
        catch (SWRLRuleEngineBridgeException sWRLRuleEngineBridgeException) {
            throw new BuiltInException("error mapping OWL object property '" + string + "': " + sWRLRuleEngineBridgeException.getMessage());
        }
        return !set.isEmpty();
    }

    public boolean mapOWLDatatypeProperty(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        OWLIndividual oWLIndividual = null;
        OWLDatatypeValue oWLDatatypeValue = null;
        Set<Object> set = new HashSet();
        SWRLBuiltInUtil.checkNumberOfArgumentsAtLeast(1, list.size());
        SWRLBuiltInUtil.checkForUnboundArguments(list);
        String string = SWRLBuiltInUtil.getArgumentAsAPropertyName(0, list);
        if (!this.getInvokingBridge().hasMapper()) {
            return false;
        }
        boolean bl2 = list.size() > 1 && SWRLBuiltInUtil.isArgumentAnIndividual(1, list);
        boolean bl3 = list.size() > 2 || list.size() > 1 && SWRLBuiltInUtil.isArgumentADatatypeValue(1, list);
        try {
            Mapper mapper;
            OWLDatatypeProperty oWLDatatypeProperty = OWLFactory.getOWLDatatypeProperty(string);
            if (bl2) {
                oWLIndividual = OWLFactory.getOWLIndividual(SWRLBuiltInUtil.getArgumentAsAnIndividualName(1, list));
            }
            if (bl3) {
                oWLDatatypeValue = bl2 ? SWRLBuiltInUtil.getArgumentAsAnOWLDatatypeValue(2, list) : SWRLBuiltInUtil.getArgumentAsAnOWLDatatypeValue(1, list);
            }
            if (!(mapper = this.getInvokingBridge().getMapper()).isMapped(oWLDatatypeProperty)) {
                return false;
            }
            set = !bl2 && !bl3 ? mapper.mapOWLDatatypeProperty(oWLDatatypeProperty) : (bl2 && !bl3 ? mapper.mapOWLDatatypeProperty((OWLProperty)oWLDatatypeProperty, oWLIndividual) : (!bl2 && bl3 ? mapper.mapOWLDatatypeProperty((OWLProperty)oWLDatatypeProperty, oWLDatatypeValue) : mapper.mapOWLDatatypeProperty(oWLDatatypeProperty, oWLIndividual, oWLDatatypeValue)));
            if (!set.isEmpty()) {
                this.getInvokingBridge().createOWLDatatypePropertyAssertionAxioms(set);
            }
        }
        catch (SWRLRuleEngineBridgeException sWRLRuleEngineBridgeException) {
            throw new BuiltInException("error mapping OWL datatype property '" + string + "': " + sWRLRuleEngineBridgeException.getMessage());
        }
        return !set.isEmpty();
    }
}

