/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge.builtins;

import edu.stanford.smi.protegex.owl.swrl.bridge.Argument;
import edu.stanford.smi.protegex.owl.swrl.bridge.BuiltInArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.ClassArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.DatatypeValueArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.IndividualArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.MultiArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLClass;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLDatatypeValue;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLIndividual;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLProperty;
import edu.stanford.smi.protegex.owl.swrl.bridge.PropertyArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.SWRLRuleEngineBridge;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.BuiltInException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidBuiltInArgumentException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidBuiltInArgumentNumberException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWRLBuiltInUtil {
    public static void checkNumberOfArgumentsEqualTo(int n, int n2) throws InvalidBuiltInArgumentNumberException {
        if (n != n2) {
            throw new InvalidBuiltInArgumentNumberException(n, n2);
        }
    }

    public static void checkNumberOfArgumentsAtLeast(int n, int n2) throws InvalidBuiltInArgumentNumberException {
        if (n2 < n) {
            throw new InvalidBuiltInArgumentNumberException(n, n2, "at least");
        }
    }

    public static void checkNumberOfArgumentsAtMost(int n, int n2) throws InvalidBuiltInArgumentNumberException {
        if (n2 > n) {
            throw new InvalidBuiltInArgumentNumberException(n, n2, "at most");
        }
    }

    public static void checkNumberOfArgumentsInRange(int n, int n2, int n3) throws InvalidBuiltInArgumentNumberException {
        if (n3 > n2 || n3 < n) {
            throw new InvalidBuiltInArgumentNumberException(n2, n3, n + " to");
        }
    }

    public static void checkThatAllArgumentsAreLiterals(List<BuiltInArgument> list) throws BuiltInException {
        for (int i = 0; i < list.size(); ++i) {
            SWRLBuiltInUtil.checkThatArgumentIsALiteral(i, list);
        }
    }

    public static void checkThatAllArgumentsAreNumeric(List<BuiltInArgument> list) throws BuiltInException {
        for (int i = 0; i < list.size(); ++i) {
            SWRLBuiltInUtil.checkThatArgumentIsNumeric(i, list);
        }
    }

    public static void checkThatAllArgumentsAreIntegers(List<BuiltInArgument> list) throws BuiltInException {
        for (int i = 0; i < list.size(); ++i) {
            SWRLBuiltInUtil.checkThatArgumentIsAnInteger(i, list);
        }
    }

    public static boolean areAllArgumentsShorts(List<BuiltInArgument> list) throws BuiltInException {
        for (int i = 0; i < list.size(); ++i) {
            if (SWRLBuiltInUtil.isArgumentAShort(i, list)) continue;
            return false;
        }
        return true;
    }

    public static boolean areAllArgumentsIntegers(List<BuiltInArgument> list) throws BuiltInException {
        for (int i = 0; i < list.size(); ++i) {
            if (SWRLBuiltInUtil.isArgumentAnInteger(i, list)) continue;
            return false;
        }
        return true;
    }

    public static boolean areAllArgumentsLongs(List<BuiltInArgument> list) throws BuiltInException {
        for (int i = 0; i < list.size(); ++i) {
            if (SWRLBuiltInUtil.isArgumentALong(i, list)) continue;
            return false;
        }
        return true;
    }

    public static boolean areAllArgumentsFloats(List<BuiltInArgument> list) throws BuiltInException {
        for (int i = 0; i < list.size(); ++i) {
            if (SWRLBuiltInUtil.isArgumentAFloat(i, list)) continue;
            return false;
        }
        return true;
    }

    public static boolean areAllArgumentsDoubles(List<BuiltInArgument> list) throws BuiltInException {
        for (int i = 0; i < list.size(); ++i) {
            if (SWRLBuiltInUtil.isArgumentADouble(i, list)) continue;
            return false;
        }
        return true;
    }

    public static boolean isArgumentConvertableToDouble(int n, List<BuiltInArgument> list) throws BuiltInException {
        return SWRLBuiltInUtil.isArgumentNumeric(n, list);
    }

    public static boolean isArgumentConvertableToFloat(int n, List<BuiltInArgument> list) throws BuiltInException {
        return SWRLBuiltInUtil.isArgumentNumeric(n, list) && SWRLBuiltInUtil.isArgumentAShort(n, list) && SWRLBuiltInUtil.isArgumentAnInteger(n, list) && SWRLBuiltInUtil.isArgumentALong(n, list) && SWRLBuiltInUtil.isArgumentAFloat(n, list);
    }

    public static boolean isArgumentConvertableToLong(int n, List<BuiltInArgument> list) throws BuiltInException {
        return SWRLBuiltInUtil.isArgumentNumeric(n, list) && SWRLBuiltInUtil.isArgumentAShort(n, list) && SWRLBuiltInUtil.isArgumentAnInteger(n, list) && SWRLBuiltInUtil.isArgumentALong(n, list);
    }

    public static boolean isArgumentConvertableToInteger(int n, List<BuiltInArgument> list) throws BuiltInException {
        return SWRLBuiltInUtil.isArgumentNumeric(n, list) && SWRLBuiltInUtil.isArgumentAShort(n, list) && SWRLBuiltInUtil.isArgumentAnInteger(n, list);
    }

    public static boolean isArgumentConvertableToShort(int n, List<BuiltInArgument> list) throws BuiltInException {
        return SWRLBuiltInUtil.isArgumentNumeric(n, list) && SWRLBuiltInUtil.isArgumentAShort(n, list);
    }

    public static boolean isShortMostPreciseArgument(List<BuiltInArgument> list) throws BuiltInException {
        for (int i = 0; i < list.size(); ++i) {
            if (!SWRLBuiltInUtil.isArgumentAnInteger(i, list) && !SWRLBuiltInUtil.isArgumentALong(i, list) && !SWRLBuiltInUtil.isArgumentAFloat(i, list) && !SWRLBuiltInUtil.isArgumentADouble(i, list)) continue;
            return false;
        }
        return true;
    }

    public static boolean isIntegerMostPreciseArgument(List<BuiltInArgument> list) throws BuiltInException {
        for (int i = 0; i < list.size(); ++i) {
            if (!SWRLBuiltInUtil.isArgumentALong(i, list) && !SWRLBuiltInUtil.isArgumentAFloat(i, list) && !SWRLBuiltInUtil.isArgumentADouble(i, list)) continue;
            return false;
        }
        return true;
    }

    public static boolean isLongMostPreciseArgument(List<BuiltInArgument> list) throws BuiltInException {
        for (int i = 0; i < list.size(); ++i) {
            if (!SWRLBuiltInUtil.isArgumentADouble(i, list) && !SWRLBuiltInUtil.isArgumentAFloat(i, list)) continue;
            return false;
        }
        return true;
    }

    public static boolean isFloatMostPreciseArgument(List<BuiltInArgument> list) throws BuiltInException {
        for (int i = 0; i < list.size(); ++i) {
            if (!SWRLBuiltInUtil.isArgumentADouble(i, list)) continue;
            return false;
        }
        return true;
    }

    public static boolean areAllArgumentsBooleans(List<BuiltInArgument> list) throws BuiltInException {
        for (int i = 0; i < list.size(); ++i) {
            if (SWRLBuiltInUtil.isArgumentABoolean(i, list)) continue;
            return false;
        }
        return true;
    }

    public static boolean areAllArgumentLiterals(List<BuiltInArgument> list) throws BuiltInException {
        for (int i = 0; i < list.size(); ++i) {
            if (SWRLBuiltInUtil.isArgumentALiteral(i, list)) continue;
            return false;
        }
        return true;
    }

    public static boolean areAllArgumentsNumeric(List<BuiltInArgument> list) throws BuiltInException {
        for (int i = 0; i < list.size(); ++i) {
            if (SWRLBuiltInUtil.isArgumentNumeric(i, list)) continue;
            return false;
        }
        return true;
    }

    public static boolean areAllArgumentsStrings(List<BuiltInArgument> list) throws BuiltInException {
        for (int i = 0; i < list.size(); ++i) {
            if (SWRLBuiltInUtil.isArgumentAString(i, list)) continue;
            return false;
        }
        return true;
    }

    public static boolean areAllArgumentsOfAnOrderedType(List<BuiltInArgument> list) throws BuiltInException {
        for (int i = 0; i < list.size(); ++i) {
            if (SWRLBuiltInUtil.isArgumentOfAnOrderedType(i, list)) continue;
            return false;
        }
        return true;
    }

    public static void checkThatAllArgumentsAreFloats(List<BuiltInArgument> list) throws BuiltInException {
        for (int i = 0; i < list.size(); ++i) {
            SWRLBuiltInUtil.checkThatArgumentIsAFloat(i, list);
        }
    }

    public static void checkThatAllArgumentsAreStrings(List<BuiltInArgument> list) throws BuiltInException {
        for (int i = 0; i < list.size(); ++i) {
            SWRLBuiltInUtil.checkThatArgumentIsAString(i, list);
        }
    }

    public static void checkThatAllArgumentsAreOfAnOrderedType(List<BuiltInArgument> list) throws BuiltInException {
        for (int i = 0; i < list.size(); ++i) {
            SWRLBuiltInUtil.checkThatArgumentIsOfAnOrderedType(i, list);
        }
    }

    public static void checkThatArgumentIsALiteral(int n, List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkArgumentNumber(n, list);
        if (!(list.get(n) instanceof DatatypeValueArgument)) {
            throw new InvalidBuiltInArgumentException(n, SWRLBuiltInUtil.makeInvalidArgumentTypeMessage(list.get(n), "literal"));
        }
    }

    public static void checkThatArgumentIsALiteral(BuiltInArgument builtInArgument) throws BuiltInException {
        if (!(builtInArgument instanceof DatatypeValueArgument)) {
            throw new InvalidBuiltInArgumentException(SWRLBuiltInUtil.makeInvalidArgumentTypeMessage(builtInArgument, "literal"));
        }
    }

    public static void checkThatArgumentIsNumeric(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (!SWRLBuiltInUtil.isArgumentNumeric(n, list)) {
            throw new InvalidBuiltInArgumentException(n, SWRLBuiltInUtil.makeInvalidArgumentTypeMessage(list.get(n), "numeric"));
        }
    }

    public static void checkThatArgumentIsOfAnOrderedType(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (!SWRLBuiltInUtil.isArgumentOfAnOrderedType(n, list)) {
            throw new InvalidBuiltInArgumentException(n, SWRLBuiltInUtil.makeInvalidArgumentTypeMessage(list.get(n), "ordered type"));
        }
    }

    public static boolean isArgumentOfAnOrderedType(int n, List<BuiltInArgument> list) throws BuiltInException {
        return SWRLBuiltInUtil.isArgumentNumeric(n, list) || SWRLBuiltInUtil.isArgumentAString(n, list);
    }

    public static boolean isArgumentAnIndividual(int n, List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkArgumentNumber(n, list);
        return list.get(n) instanceof IndividualArgument;
    }

    public static boolean isArgumentADatatypeValue(int n, List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkArgumentNumber(n, list);
        return list.get(n) instanceof DatatypeValueArgument;
    }

    public static void checkThatArgumentIsAnIndividual(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (!SWRLBuiltInUtil.isArgumentAnIndividual(n, list)) {
            throw new InvalidBuiltInArgumentException(n, SWRLBuiltInUtil.makeInvalidArgumentTypeMessage(list.get(n), "individual"));
        }
    }

    public static void checkThatArgumentIsAnOWLDatatypeValue(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (!SWRLBuiltInUtil.isArgumentADatatypeValue(n, list)) {
            throw new InvalidBuiltInArgumentException(n, SWRLBuiltInUtil.makeInvalidArgumentTypeMessage(list.get(n), "datatype value"));
        }
    }

    public static String getArgumentAsAnIndividualName(int n, List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkThatArgumentIsAnIndividual(n, list);
        return ((OWLIndividual)list.get(n)).getIndividualName();
    }

    public static String getArgumentAsAClassName(int n, List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkThatArgumentIsAClass(n, list);
        return ((OWLClass)list.get(n)).getClassName();
    }

    public static OWLClass getArgumentAsAnOWLClass(int n, List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkThatArgumentIsAClass(n, list);
        return (OWLClass)list.get(n);
    }

    public static OWLProperty getArgumentAsAnOWLProperty(int n, List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkThatArgumentIsAProperty(n, list);
        return (OWLProperty)((Object)list.get(n));
    }

    public static OWLDatatypeValue getArgumentAsAnOWLDatatypeValue(int n, List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkThatArgumentIsAnOWLDatatypeValue(n, list);
        return (OWLDatatypeValue)list.get(n);
    }

    public static String getArgumentAsAResourceName(int n, List<BuiltInArgument> list) throws BuiltInException {
        String string = "";
        SWRLBuiltInUtil.checkThatArgumentIsAClassPropertyOrIndividual(n, list);
        if (SWRLBuiltInUtil.isArgumentAClass(n, list)) {
            string = ((OWLClass)list.get(n)).getClassName();
        } else if (SWRLBuiltInUtil.isArgumentAProperty(n, list)) {
            string = ((OWLProperty)((Object)list.get(n))).getPropertyName();
        } else if (SWRLBuiltInUtil.isArgumentAnIndividual(n, list)) {
            string = ((OWLIndividual)list.get(n)).getIndividualName();
        }
        return string;
    }

    public static String getArgumentAsAPropertyName(int n, List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkThatArgumentIsAProperty(n, list);
        return ((OWLProperty)((Object)list.get(n))).getPropertyName();
    }

    public static void checkArgumentNumber(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (n < 0 || n >= list.size()) {
            throw new BuiltInException("(0-offset) argument number #" + n + " is out of bounds");
        }
    }

    public static boolean isArgumentNumeric(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (SWRLBuiltInUtil.isArgumentALiteral(n, list)) {
            return SWRLBuiltInUtil.getArgumentAsALiteral(n, list).isNumeric();
        }
        return false;
    }

    public static boolean isArgumentNonNumeric(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (SWRLBuiltInUtil.isArgumentALiteral(n, list)) {
            return !SWRLBuiltInUtil.getArgumentAsALiteral(n, list).isNumeric();
        }
        return false;
    }

    public static void checkThatArgumentIsNonNumeric(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (!SWRLBuiltInUtil.isArgumentNonNumeric(n, list)) {
            throw new InvalidBuiltInArgumentException(n, SWRLBuiltInUtil.makeInvalidArgumentTypeMessage(list.get(n), "non-numeric"));
        }
    }

    public static void checkThatArgumentIsAnInteger(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (!SWRLBuiltInUtil.isArgumentAnInteger(n, list)) {
            throw new InvalidBuiltInArgumentException(n, SWRLBuiltInUtil.makeInvalidArgumentTypeMessage(list.get(n), "integer"));
        }
    }

    public static boolean isArgumentAnInteger(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (SWRLBuiltInUtil.isArgumentALiteral(n, list)) {
            return SWRLBuiltInUtil.getArgumentAsALiteral(n, list).isInteger();
        }
        return false;
    }

    public static int getArgumentAsAnInteger(int n, List<BuiltInArgument> list) throws BuiltInException {
        return SWRLBuiltInUtil.getArgumentAsALiteral(n, list).getInt();
    }

    public static boolean isArgumentAShort(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (SWRLBuiltInUtil.isArgumentALiteral(n, list)) {
            return SWRLBuiltInUtil.getArgumentAsALiteral(n, list).isShort();
        }
        return false;
    }

    public static short getArgumentAsAShort(int n, List<BuiltInArgument> list) throws BuiltInException {
        return SWRLBuiltInUtil.getArgumentAsALiteral(n, list).getShort();
    }

    public static BigDecimal getArgumentAsABigDecimal(int n, List<BuiltInArgument> list) throws BuiltInException {
        return SWRLBuiltInUtil.getArgumentAsALiteral(n, list).getBigDecimal();
    }

    public static BigInteger getArgumentAsABigInteger(int n, List<BuiltInArgument> list) throws BuiltInException {
        return SWRLBuiltInUtil.getArgumentAsALiteral(n, list).getBigInteger();
    }

    public static boolean isArgumentALiteral(int n, List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkThatArgumentIsBound(n, list);
        return list.get(n) instanceof DatatypeValueArgument;
    }

    public static boolean isArgumentAProperty(int n, List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkThatArgumentIsBound(n, list);
        return list.get(n) instanceof PropertyArgument;
    }

    public static void checkThatArgumentIsAProperty(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (!SWRLBuiltInUtil.isArgumentAProperty(n, list)) {
            throw new InvalidBuiltInArgumentException(n, SWRLBuiltInUtil.makeInvalidArgumentTypeMessage(list.get(n), "property"));
        }
    }

    public static void checkThatArgumentIsAClassPropertyOrIndividual(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (!SWRLBuiltInUtil.isArgumentAClassPropertyOrIndividual(n, list)) {
            throw new InvalidBuiltInArgumentException(n, SWRLBuiltInUtil.makeInvalidArgumentTypeMessage(list.get(n), "class, property, or individual"));
        }
    }

    public static boolean isArgumentAClassPropertyOrIndividual(int n, List<BuiltInArgument> list) throws BuiltInException {
        return SWRLBuiltInUtil.isArgumentAClass(n, list) || SWRLBuiltInUtil.isArgumentAProperty(n, list) || SWRLBuiltInUtil.isArgumentAnIndividual(n, list);
    }

    public static boolean isArgumentAClass(int n, List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkThatArgumentIsBound(n, list);
        return list.get(n) instanceof ClassArgument;
    }

    public static void checkThatArgumentIsAClass(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (!SWRLBuiltInUtil.isArgumentAClass(n, list)) {
            throw new InvalidBuiltInArgumentException(n, SWRLBuiltInUtil.makeInvalidArgumentTypeMessage(list.get(n), "class"));
        }
    }

    public static OWLDatatypeValue getArgumentAsALiteral(int n, List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkThatArgumentIsALiteral(n, list);
        return (OWLDatatypeValue)list.get(n);
    }

    public static OWLDatatypeValue getArgumentAsALiteral(BuiltInArgument builtInArgument) throws BuiltInException {
        SWRLBuiltInUtil.checkThatArgumentIsALiteral(builtInArgument);
        return (OWLDatatypeValue)builtInArgument;
    }

    public static void checkThatArgumentIsALong(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (!SWRLBuiltInUtil.isArgumentALong(n, list)) {
            throw new InvalidBuiltInArgumentException(n, SWRLBuiltInUtil.makeInvalidArgumentTypeMessage(list.get(n), "long"));
        }
    }

    public static boolean isArgumentALong(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (SWRLBuiltInUtil.isArgumentALiteral(n, list)) {
            return SWRLBuiltInUtil.getArgumentAsALiteral(n, list).isLong();
        }
        return false;
    }

    public static long getArgumentAsALong(int n, List<BuiltInArgument> list) throws BuiltInException {
        return SWRLBuiltInUtil.getArgumentAsALiteral(n, list).getLong();
    }

    public static void checkThatArgumentIsAFloat(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (!SWRLBuiltInUtil.isArgumentAFloat(n, list)) {
            throw new InvalidBuiltInArgumentException(n, SWRLBuiltInUtil.makeInvalidArgumentTypeMessage(list.get(n), "float"));
        }
    }

    public static boolean isArgumentAFloat(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (SWRLBuiltInUtil.isArgumentALiteral(n, list)) {
            return SWRLBuiltInUtil.getArgumentAsALiteral(n, list).isFloat();
        }
        return false;
    }

    public static float getArgumentAsAFloat(int n, List<BuiltInArgument> list) throws BuiltInException {
        return SWRLBuiltInUtil.getArgumentAsALiteral(n, list).getFloat();
    }

    public static void checkThatArgumentIsADouble(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (!SWRLBuiltInUtil.isArgumentADouble(n, list)) {
            throw new InvalidBuiltInArgumentException(n, SWRLBuiltInUtil.makeInvalidArgumentTypeMessage(list.get(n), "double"));
        }
    }

    public static boolean isArgumentADouble(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (SWRLBuiltInUtil.isArgumentALiteral(n, list)) {
            return SWRLBuiltInUtil.getArgumentAsALiteral(n, list).isDouble();
        }
        return false;
    }

    public static double getArgumentAsADouble(int n, List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkArgumentNumber(n, list);
        return SWRLBuiltInUtil.getArgumentAsADouble(list.get(n));
    }

    public static double getArgumentAsADouble(BuiltInArgument builtInArgument) throws BuiltInException {
        return SWRLBuiltInUtil.getArgumentAsALiteral(builtInArgument).getDouble();
    }

    public static void checkThatArgumentIsABoolean(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (!SWRLBuiltInUtil.isArgumentABoolean(n, list)) {
            throw new InvalidBuiltInArgumentException(n, SWRLBuiltInUtil.makeInvalidArgumentTypeMessage(list.get(n), "boolean"));
        }
    }

    public static boolean isArgumentABoolean(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (SWRLBuiltInUtil.isArgumentALiteral(n, list)) {
            return SWRLBuiltInUtil.getArgumentAsALiteral(n, list).isBoolean();
        }
        return false;
    }

    public static boolean getArgumentAsABoolean(int n, List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkThatArgumentIsABoolean(n, list);
        return SWRLBuiltInUtil.getArgumentAsALiteral(n, list).getBoolean();
    }

    public static void checkThatArgumentIsAString(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (!SWRLBuiltInUtil.isArgumentAString(n, list)) {
            throw new InvalidBuiltInArgumentException(n, SWRLBuiltInUtil.makeInvalidArgumentTypeMessage(list.get(n), "string"));
        }
    }

    public static boolean isArgumentAString(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (SWRLBuiltInUtil.isArgumentALiteral(n, list)) {
            return SWRLBuiltInUtil.getArgumentAsALiteral(n, list).isString();
        }
        return false;
    }

    public static String getArgumentAsAString(int n, List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkThatArgumentIsAString(n, list);
        return SWRLBuiltInUtil.getArgumentAsALiteral(n, list).getString();
    }

    public static boolean hasUnboundArguments(List<BuiltInArgument> list) throws BuiltInException {
        for (BuiltInArgument builtInArgument : list) {
            if (!builtInArgument.isUnbound()) continue;
            return true;
        }
        return false;
    }

    public static void checkThatAllArgumentsAreBound(List<BuiltInArgument> list) throws BuiltInException {
        if (SWRLBuiltInUtil.hasUnboundArguments(list)) {
            throw new BuiltInException("all arguments must be bound");
        }
    }

    public static void checkThatArgumentIsBound(int n, List<BuiltInArgument> list) throws BuiltInException {
        if (SWRLBuiltInUtil.isUnboundArgument(n, list)) {
            throw new BuiltInException("not expecting an unbound argument for (0-offset) argument #" + n);
        }
    }

    public static boolean isUnboundArgument(int n, List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkArgumentNumber(n, list);
        return list.get(n).isUnbound();
    }

    public static int getFirstUnboundArgument(List<BuiltInArgument> list) throws BuiltInException {
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).isUnbound()) continue;
            return i;
        }
        return -1;
    }

    public static void checkForUnboundArguments(List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkForUnboundArguments(list, "built-in does not support variable binding - unbound argument '" + SWRLBuiltInUtil.getFirstUnboundArgument(list) + "'");
    }

    public static void checkForUnboundArguments(List<BuiltInArgument> list, String string) throws BuiltInException {
        if (SWRLBuiltInUtil.hasUnboundArguments(list)) {
            throw new BuiltInException(string + " '" + SWRLBuiltInUtil.getFirstUnboundArgument(list) + "'");
        }
    }

    public static void checkForNonVariableArguments(List<BuiltInArgument> list, String string) throws BuiltInException {
        for (BuiltInArgument builtInArgument : list) {
            if (builtInArgument.isVariable()) continue;
            throw new BuiltInException(string + " '" + builtInArgument + "'");
        }
    }

    public static void checkForUnboundNonFirstArguments(List<BuiltInArgument> list) throws BuiltInException {
        if (SWRLBuiltInUtil.hasUnboundArguments(list.subList(1, list.size()))) {
            throw new BuiltInException("built-in supports variable binding only for the first argument - unbound variables used as other arguments");
        }
    }

    public static String getVariableName(int n, List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkArgumentNumber(n, list);
        return list.get(n).getVariableName();
    }

    private static String makeInvalidArgumentTypeMessage(BuiltInArgument builtInArgument, String string) throws BuiltInException {
        String string2 = "expecting " + string + ", got ";
        if (builtInArgument.isUnbound()) {
            string2 = string2 + "unbound argument with variable name '" + builtInArgument.getVariableName() + "'";
        } else if (builtInArgument instanceof ClassArgument) {
            OWLClass oWLClass = (OWLClass)builtInArgument;
            string2 = string2 + "class with name '" + oWLClass.getClassName() + "'";
        } else if (builtInArgument instanceof PropertyArgument) {
            OWLProperty oWLProperty = (OWLProperty)((Object)builtInArgument);
            string2 = string2 + "property with name '" + oWLProperty.getPropertyName() + "'";
        } else if (builtInArgument instanceof IndividualArgument) {
            OWLIndividual oWLIndividual = (OWLIndividual)builtInArgument;
            string2 = string2 + "individual with name '" + oWLIndividual.getIndividualName() + "'";
        } else if (builtInArgument instanceof DatatypeValueArgument) {
            OWLDatatypeValue oWLDatatypeValue = (OWLDatatypeValue)builtInArgument;
            string2 = string2 + "literal with value '" + oWLDatatypeValue.toString() + "'";
        } else {
            string2 = string2 + "unknown type '" + builtInArgument.getClass().getName() + "'";
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object getArgumentAsAPropertyValue(int n, List<BuiltInArgument> list) throws BuiltInException {
        String string = null;
        SWRLBuiltInUtil.checkThatArgumentIsBound(n, list);
        Argument argument = list.get(n);
        if (argument instanceof ClassArgument) {
            OWLClass oWLClass = (OWLClass)argument;
            return oWLClass.getClassName();
        }
        if (argument instanceof PropertyArgument) {
            OWLProperty oWLProperty = (OWLProperty)argument;
            return oWLProperty.getPropertyName();
        }
        if (argument instanceof IndividualArgument) {
            OWLIndividual oWLIndividual = (OWLIndividual)argument;
            return oWLIndividual.getIndividualName();
        }
        if (!(argument instanceof DatatypeValueArgument)) throw new BuiltInException("argument '" + argument + "' of unknown type '" + argument.getClass().getName() + "'");
        OWLDatatypeValue oWLDatatypeValue = (OWLDatatypeValue)argument;
        if (oWLDatatypeValue.isNumeric()) {
            return oWLDatatypeValue.getNumber();
        }
        if (!oWLDatatypeValue.isString()) throw new BuiltInException("literal with value '" + oWLDatatypeValue.toString() + "' not supported - strings and number literals only");
        return oWLDatatypeValue.getString();
    }

    public static String createInvocationPattern(SWRLRuleEngineBridge sWRLRuleEngineBridge, String string, int n, List<BuiltInArgument> list) throws BuiltInException {
        String string2 = "" + sWRLRuleEngineBridge.hashCode() + "." + string + "." + n;
        for (int i = 0; i < list.size(); ++i) {
            string2 = string2 + "." + SWRLBuiltInUtil.getArgumentAsAPropertyValue(i, list);
        }
        return string2;
    }

    public static void checkForUnboundArguments(String string, String string2, List<BuiltInArgument> list) throws BuiltInException {
        int n = 0;
        for (BuiltInArgument builtInArgument : list) {
            if (builtInArgument.isUnbound()) {
                throw new BuiltInException("built-in '" + string2 + "' in rule '" + string + "' " + "returned with unbound argument ?" + builtInArgument.getVariableName());
            }
            if (builtInArgument instanceof MultiArgument && ((MultiArgument)builtInArgument).hasNoArguments()) {
                throw new BuiltInException("built-in '" + string2 + "' in rule '" + string + "' " + "returned with empty multi-argument ?" + builtInArgument.getVariableName());
            }
            ++n;
        }
    }

    public static void generateBuiltInBindings(SWRLRuleEngineBridge sWRLRuleEngineBridge, String string, String string2, int n, List<BuiltInArgument> list) throws BuiltInException {
        List<Integer> list2 = SWRLBuiltInUtil.getMultiArgumentIndexes(list);
        if (list2.isEmpty()) {
            sWRLRuleEngineBridge.generateBuiltInBinding(string, string2, n, list);
        } else {
            int n2;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            for (n2 = 0; n2 < list2.size(); ++n2) {
                arrayList.add(0);
            }
            for (n2 = 0; n2 < list2.size(); ++n2) {
                MultiArgument multiArgument = (MultiArgument)list.get(list2.get(n2));
                arrayList2.add(multiArgument.getNumberOfArguments());
            }
            do {
                List<BuiltInArgument> list3 = SWRLBuiltInUtil.generateArgumentsPattern(list, arrayList);
                sWRLRuleEngineBridge.generateBuiltInBinding(string, string2, n, list3);
            } while (!SWRLBuiltInUtil.nextMultiArgumentCounts(arrayList, arrayList2));
        }
    }

    public static List<BuiltInArgument> copyArguments(List<BuiltInArgument> list) throws BuiltInException {
        return new ArrayList<BuiltInArgument>(list);
    }

    private static boolean nextMultiArgumentCounts(List<Integer> list, List<Integer> list2) {
        if (list2.isEmpty()) {
            return true;
        }
        if (SWRLBuiltInUtil.nextMultiArgumentCounts(list.subList(1, list.size()), list2.subList(1, list2.size()))) {
            int n = list.get(0);
            int n2 = list2.get(0);
            if (++n == n2) {
                return true;
            }
            list.set(0, n);
            for (int i = 1; i < list.size(); ++i) {
                list.set(i, 0);
            }
        }
        return false;
    }

    private static List<BuiltInArgument> generateArgumentsPattern(List<BuiltInArgument> list, List<Integer> list2) {
        ArrayList<BuiltInArgument> arrayList = new ArrayList<BuiltInArgument>();
        int n = 0;
        for (BuiltInArgument builtInArgument : list) {
            if (builtInArgument instanceof MultiArgument) {
                MultiArgument multiArgument = (MultiArgument)builtInArgument;
                arrayList.add(multiArgument.getArguments().get(list2.get(n)));
                ++n;
                continue;
            }
            arrayList.add(builtInArgument);
        }
        return arrayList;
    }

    private static List<Integer> getMultiArgumentIndexes(List<BuiltInArgument> list) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof MultiArgument)) continue;
            arrayList.add(i);
        }
        return arrayList;
    }
}

