/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge.builtins;

import edu.stanford.smi.protegex.owl.swrl.bridge.BuiltInArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.SWRLRuleEngineBridge;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.SWRLBuiltInLibrary;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.BuiltInException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.IncompatibleBuiltInClassException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.IncompatibleBuiltInMethodException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidBuiltInLibraryNameException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.SWRLRuleEngineBridgeException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.UnresolvedBuiltInClassException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.UnresolvedBuiltInMethodException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BuiltInLibraryManager {
    private static String BuiltInLibraryPackageBaseName = "edu.stanford.smi.protegex.owl.swrl.bridge.builtins.";
    private static HashMap<String, SWRLBuiltInLibrary> builtInLibraries = new HashMap();

    public static boolean invokeSWRLBuiltIn(SWRLRuleEngineBridge sWRLRuleEngineBridge, String string, String string2, int n, List<BuiltInArgument> list) throws BuiltInException {
        String string3 = BuiltInLibraryManager.getPrefix(string2);
        String string4 = BuiltInLibraryManager.getBuiltInLibraryImplementationClassName(string3);
        String string5 = BuiltInLibraryManager.getBuiltInMethodName(string2);
        SWRLBuiltInLibrary sWRLBuiltInLibrary = BuiltInLibraryManager.loadBuiltInLibrary(sWRLRuleEngineBridge, string, string3, string4);
        Method method = BuiltInLibraryManager.resolveBuiltInMethod(string, sWRLBuiltInLibrary, string3, string5);
        BuiltInLibraryManager.checkBuiltInMethodSignature(string, string3, string5, method);
        return sWRLBuiltInLibrary.invokeBuiltInMethod(method, sWRLRuleEngineBridge, string, string3, string5, n, list);
    }

    private static SWRLBuiltInLibrary getBuiltInLibraryByPrefix(String string) throws InvalidBuiltInLibraryNameException {
        SWRLBuiltInLibrary sWRLBuiltInLibrary = null;
        if (!builtInLibraries.containsKey(string)) {
            throw new InvalidBuiltInLibraryNameException(string);
        }
        sWRLBuiltInLibrary = builtInLibraries.get(string);
        return sWRLBuiltInLibrary;
    }

    private static Set<String> getBuiltInLibraryPrefixes() {
        return builtInLibraries.keySet();
    }

    private static SWRLBuiltInLibrary loadBuiltInLibrary(SWRLRuleEngineBridge sWRLRuleEngineBridge, String string, String string2, String string3) throws BuiltInException {
        SWRLBuiltInLibrary sWRLBuiltInLibrary;
        if (builtInLibraries.containsKey(string2)) {
            sWRLBuiltInLibrary = builtInLibraries.get(string2);
        } else {
            sWRLBuiltInLibrary = BuiltInLibraryManager.loadBuiltInLibraryImpl(string, string2, string3);
            builtInLibraries.put(string2, sWRLBuiltInLibrary);
            BuiltInLibraryManager.invokeBuiltInLibraryResetMethod(sWRLRuleEngineBridge, sWRLBuiltInLibrary);
        }
        return sWRLBuiltInLibrary;
    }

    private static String getPrefix(String string) {
        int n = string.indexOf(58);
        if (n != -1) {
            return string.substring(0, n);
        }
        return "";
    }

    private static String getBuiltInLibraryImplementationClassName(String string) {
        if (string.equals("")) {
            return BuiltInLibraryPackageBaseName + "SWRLBuiltInLibraryImpl";
        }
        return BuiltInLibraryPackageBaseName + string + ".SWRLBuiltInLibraryImpl";
    }

    private static String getBuiltInMethodName(String string) {
        String string2 = string.indexOf(":") == -1 ? string : string.substring(string.indexOf(":") + 1, string.length());
        return string2;
    }

    private static void invokeBuiltInLibraryResetMethod(SWRLRuleEngineBridge sWRLRuleEngineBridge, SWRLBuiltInLibrary sWRLBuiltInLibrary) throws BuiltInException {
        try {
            sWRLBuiltInLibrary.invokeResetMethod(sWRLRuleEngineBridge);
        }
        catch (Exception exception) {
            throw new BuiltInException("error calling 'reset' method in built-in library '" + sWRLBuiltInLibrary.getClass().getName() + "'");
        }
    }

    public static void invokeAllBuiltInLibrariesResetMethod(SWRLRuleEngineBridge sWRLRuleEngineBridge) throws SWRLRuleEngineBridgeException {
        for (SWRLBuiltInLibrary sWRLBuiltInLibrary : builtInLibraries.values()) {
            BuiltInLibraryManager.invokeBuiltInLibraryResetMethod(sWRLRuleEngineBridge, sWRLBuiltInLibrary);
        }
    }

    private static Method resolveBuiltInMethod(String string, SWRLBuiltInLibrary sWRLBuiltInLibrary, String string2, String string3) throws UnresolvedBuiltInMethodException {
        Method method;
        try {
            method = sWRLBuiltInLibrary.getClass().getMethod(string3, List.class);
        }
        catch (Exception exception) {
            throw new UnresolvedBuiltInMethodException(string, string2, string3, exception.getMessage());
        }
        return method;
    }

    private static SWRLBuiltInLibrary loadBuiltInLibraryImpl(String string, String string2, String string3) throws UnresolvedBuiltInClassException, IncompatibleBuiltInClassException {
        SWRLBuiltInLibrary sWRLBuiltInLibrary;
        Class<?> clazz;
        try {
            clazz = Class.forName(string3);
        }
        catch (Exception exception) {
            throw new UnresolvedBuiltInClassException(string, string2, exception.getMessage());
        }
        BuiltInLibraryManager.checkBuiltInMethodsClassCompatibility(string, string2, clazz);
        try {
            sWRLBuiltInLibrary = (SWRLBuiltInLibrary)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new UnresolvedBuiltInClassException(string, string2, exception.getMessage());
        }
        return sWRLBuiltInLibrary;
    }

    private static void checkBuiltInMethodSignature(String string, String string2, String string3, Method method) throws IncompatibleBuiltInMethodException {
        if (method.getReturnType() != Boolean.TYPE) {
            throw new IncompatibleBuiltInMethodException(string, string2, string3, "Java method must return a boolean");
        }
        Class<?>[] classArray = method.getExceptionTypes();
        if (classArray.length != 1 || classArray[0] != BuiltInException.class) {
            throw new IncompatibleBuiltInMethodException(string, string2, string3, "Java method must throw a single exception of type BuiltInException");
        }
        Type[] typeArray = method.getGenericParameterTypes();
        if (typeArray.length != 1 || !(typeArray[0] instanceof ParameterizedType) || ((ParameterizedType)typeArray[0]).getRawType() != List.class || ((ParameterizedType)typeArray[0]).getActualTypeArguments().length != 1 || ((ParameterizedType)typeArray[0]).getActualTypeArguments()[0] != BuiltInArgument.class) {
            throw new IncompatibleBuiltInMethodException(string, string2, string3, "Java method must accept a single List of BuiltInArgument objects");
        }
    }

    private static void checkBuiltInMethodsClassCompatibility(String string, String string2, Class clazz) throws IncompatibleBuiltInClassException {
        if (!SWRLBuiltInLibrary.class.isAssignableFrom(clazz)) {
            throw new IncompatibleBuiltInClassException(string, string2, clazz.getName(), "Java class does not implement SWRLBuiltInLibrary");
        }
    }
}

