/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge.builtins;

import edu.stanford.smi.protegex.owl.swrl.bridge.BuiltInArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.SWRLRuleEngineBridge;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.SWRLBuiltInLibrary;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.BuiltInException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.BuiltInMethodRuntimeException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSWRLBuiltInLibrary
implements SWRLBuiltInLibrary {
    private String libraryName;
    private SWRLRuleEngineBridge invokingBridge;
    private String invokingRuleName = "";
    private int invokingBuiltInIndex = -1;

    public AbstractSWRLBuiltInLibrary(String string) {
        this.libraryName = string;
    }

    @Override
    public String getLibraryName() {
        return this.libraryName;
    }

    @Override
    public SWRLRuleEngineBridge getInvokingBridge() throws BuiltInException {
        if (this.invokingBridge == null) {
            throw new BuiltInException("invalid call to getInvokingBridge - should only be called from within a built-in");
        }
        return this.invokingBridge;
    }

    @Override
    public String getInvokingRuleName() throws BuiltInException {
        if (this.invokingRuleName.equals("")) {
            throw new BuiltInException("invalid call to getInvokingRuleName - should only be called from within a built-in");
        }
        return this.invokingRuleName;
    }

    @Override
    public int getInvokingBuiltInIndex() throws BuiltInException {
        if (this.invokingBuiltInIndex == -1) {
            throw new BuiltInException("invalid call to getInvokingBuiltInIndex - should only be called from within a built-in");
        }
        return this.invokingBuiltInIndex;
    }

    @Override
    public abstract void reset() throws BuiltInException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeResetMethod(SWRLRuleEngineBridge sWRLRuleEngineBridge) throws BuiltInException {
        AbstractSWRLBuiltInLibrary abstractSWRLBuiltInLibrary = this;
        synchronized (abstractSWRLBuiltInLibrary) {
            this.invokingBridge = sWRLRuleEngineBridge;
            this.reset();
            this.invokingBridge = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean invokeBuiltInMethod(Method method, SWRLRuleEngineBridge sWRLRuleEngineBridge, String string, String string2, String string3, int n, List<BuiltInArgument> list) throws BuiltInException {
        Boolean bl = null;
        String string4 = string2 + ":" + string3;
        AbstractSWRLBuiltInLibrary abstractSWRLBuiltInLibrary = this;
        synchronized (abstractSWRLBuiltInLibrary) {
            this.invokingBridge = sWRLRuleEngineBridge;
            this.invokingRuleName = string;
            this.invokingBuiltInIndex = n;
            try {
                bl = (Boolean)method.invoke((Object)this, list);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof BuiltInException) {
                    throw new BuiltInException("exception thrown by built-in '" + string4 + "' in rule '" + string + "': " + throwable.getMessage(), throwable);
                }
                if (throwable instanceof RuntimeException) {
                    throw new BuiltInMethodRuntimeException(string, string4, throwable.getMessage(), throwable);
                }
                throw new BuiltInException("unknown exception thrown by built-in method '" + string4 + "' in rule '" + string + "': " + invocationTargetException.toString(), invocationTargetException);
            }
            catch (Exception exception) {
                throw new BuiltInException("internal bridge exception when invoking built-in method '" + string4 + "' in rule '" + string + "': " + exception.getMessage(), exception);
            }
            this.invokingBridge = null;
            this.invokingRuleName = "";
            this.invokingBuiltInIndex = -1;
        }
        return bl;
    }
}

