/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge;

import edu.stanford.smi.protege.event.ProjectAdapter;
import edu.stanford.smi.protege.event.ProjectEvent;
import edu.stanford.smi.protege.event.ProjectListener;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.swrl.bridge.ui.SWRLPluginGUIAdapter;
import edu.stanford.smi.protegex.owl.swrl.ui.tab.SWRLTab;
import java.awt.Container;
import java.awt.GridLayout;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BridgePluginManager {
    private static HashMap<String, PluginRegistration> registeredPlugins = new HashMap();
    private static String visiblePluginName = "";
    private static String selectedRuleName = "";
    private static ProjectListener projectListener = new ProjectAdapter(){

        public void projectClosed(ProjectEvent projectEvent) {
            Project project = (Project)projectEvent.getSource();
            project.removeProjectListener(projectListener);
            visiblePluginName = "";
            selectedRuleName = "";
        }
    };

    public static String getSelectedRuleName() {
        return selectedRuleName;
    }

    public static boolean hasSelectedRule() {
        return !selectedRuleName.equals("");
    }

    public static void setSelectedRuleName(String string) {
        selectedRuleName = string;
    }

    public static Collection<PluginRegistration> getRegisteredPlugins() {
        return registeredPlugins.values();
    }

    public static void hideVisiblePlugin() {
        BridgePluginManager.hidePlugin(visiblePluginName, true);
    }

    public static boolean hidePlugin(String string) {
        return BridgePluginManager.hidePlugin(string, false);
    }

    public static boolean isVisible(String string) {
        return !visiblePluginName.equals("") && string.equals(visiblePluginName);
    }

    public static void registerPlugin(String string, String string2, Icon icon, SWRLPluginGUIAdapter sWRLPluginGUIAdapter) {
        if (registeredPlugins.containsKey(string)) {
            registeredPlugins.remove(string);
        }
        registeredPlugins.put(string, new PluginRegistration(string, string2, icon, sWRLPluginGUIAdapter));
        System.out.println("Plugin '" + string + "' registered with the SWRLTab plugin manager.");
    }

    public static void unregisterPlugin(String string) {
        if (registeredPlugins.containsKey(string)) {
            if (BridgePluginManager.isVisible(string)) {
                BridgePluginManager.hidePlugin(string, true);
            }
            registeredPlugins.remove(string);
        }
    }

    public static void showPlugin(String string, SWRLTab sWRLTab, OWLModel oWLModel) {
        if (!BridgePluginManager.isVisible(string) && BridgePluginManager.hidePlugin(visiblePluginName) && registeredPlugins.containsKey(string)) {
            PluginRegistration pluginRegistration = registeredPlugins.get(string);
            Container container = pluginRegistration.getGUIAdapter().createPluginGUI(oWLModel);
            pluginRegistration.setOWLModel(oWLModel);
            if (container != null) {
                sWRLTab.setVisible(false);
                sWRLTab.setLayout(new GridLayout(2, 1));
                sWRLTab.add(container);
                sWRLTab.setVisible(true);
                visiblePluginName = string;
            } else {
                BridgePluginManager.makeTextPanel(sWRLTab, "Unable to activate the " + string + " plugin.");
            }
        }
        oWLModel.getProject().addProjectListener(projectListener);
    }

    private static boolean hidePlugin(String string, boolean bl) {
        if (BridgePluginManager.isVisible(string)) {
            if (!bl && JOptionPane.showConfirmDialog(null, "Do you really want to disable the " + string + " plugin?", "Disable " + string, 0) != 0) {
                return false;
            }
            if (registeredPlugins.containsKey(string)) {
                PluginRegistration pluginRegistration = registeredPlugins.get(string);
                Container container = pluginRegistration.getGUIAdapter().getPluginGUI();
                SWRLTab sWRLTab = (SWRLTab)((Object)container.getParent());
                if (sWRLTab != null) {
                    sWRLTab.setVisible(false);
                    sWRLTab.remove(container);
                    sWRLTab.reconfigure();
                    sWRLTab.setVisible(true);
                }
                if (pluginRegistration.hasOWLModel()) {
                    pluginRegistration.getOWLModel().getProject().removeProjectListener(projectListener);
                }
                visiblePluginName = "";
            }
        }
        return true;
    }

    private static void makeTextPanel(SWRLTab sWRLTab, String string) {
        JPanel jPanel = new JPanel(false);
        JLabel jLabel = new JLabel(string);
        jLabel.setHorizontalAlignment(0);
        jPanel.setLayout(new GridLayout(1, 1));
        jPanel.add(jLabel);
        sWRLTab.add(jPanel);
    }

    static {
        try {
            Class.forName("jess.Rete");
            Class.forName("edu.stanford.smi.protegex.owl.swrl.bridge.jess.SWRLJessBridge");
            Class.forName("edu.stanford.smi.protegex.owl.swrl.bridge.jess.ui.SWRLJessTab");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("SWRLJessBridge load failed: could not find jess.Rete - or an error occured on initialization");
        }
        try {
            Class.forName("jess.Rete");
            Class.forName("edu.stanford.smi.protegex.owl.swrl.sqwrl.ui.SQWRLQueryTab");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("SQWRLQueryTab load failed: could not find jess.Rete - or an error occured on initialization");
        }
    }

    public static class PluginRegistration {
        private String pluginName;
        private String toolTip;
        private SWRLPluginGUIAdapter guiAdapter;
        private Icon icon;
        private OWLModel owlModel;

        public PluginRegistration(String string, String string2, Icon icon, SWRLPluginGUIAdapter sWRLPluginGUIAdapter) {
            this.pluginName = string;
            this.toolTip = string2;
            this.guiAdapter = sWRLPluginGUIAdapter;
            this.icon = icon;
            this.owlModel = null;
        }

        public void setOWLModel(OWLModel oWLModel) {
            this.owlModel = oWLModel;
        }

        public String getPluginName() {
            return this.pluginName;
        }

        public String getToolTip() {
            return this.toolTip;
        }

        public SWRLPluginGUIAdapter getGUIAdapter() {
            return this.guiAdapter;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public OWLModel getOWLModel() {
            return this.owlModel;
        }

        public boolean hasOWLModel() {
            return this.owlModel != null;
        }
    }
}

