/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.storage;

import edu.stanford.smi.protege.Application;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.plugin.AbstractCreateProjectPlugin;
import edu.stanford.smi.protege.plugin.CreateProjectWizard;
import edu.stanford.smi.protege.storage.clips.ClipsKnowledgeBaseFactory;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protege.util.Wizard;
import edu.stanford.smi.protege.util.WizardPage;
import edu.stanford.smi.protegex.owl.ProtegeOWL;
import edu.stanford.smi.protegex.owl.jena.JenaKnowledgeBaseFactory;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.jena.OWLFilesPlugin;
import edu.stanford.smi.protegex.owl.jena.importer.OWLImporter;
import edu.stanford.smi.protegex.owl.ui.jena.ProtegeFromOWLFilesWizardPage;
import java.net.URI;
import java.util.logging.Level;
import javax.swing.JOptionPane;

public class ProtegeFromOWLFilesCreateProjectPlugin
extends AbstractCreateProjectPlugin
implements OWLFilesPlugin {
    private String fileURI;

    public ProtegeFromOWLFilesCreateProjectPlugin() {
        super("OWL File (.owl)  -- Warning: conversion may be incomplete");
        JenaKnowledgeBaseFactory.useStandalone = false;
    }

    public void addImport(String string, String string2) {
    }

    protected Project buildNewProject(KnowledgeBaseFactory knowledgeBaseFactory) {
        Project project = super.buildNewProject(knowledgeBaseFactory);
        if (project != null) {
            try {
                JenaOWLModel jenaOWLModel = ProtegeOWL.createJenaOWLModelFromURI(this.fileURI);
                new OWLImporter(jenaOWLModel, project.getKnowledgeBase());
            }
            catch (Exception exception) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
                JOptionPane.showMessageDialog(Application.getMainWindow(), "Could not load " + this.fileURI + "\n" + exception, "Error", 0);
            }
        }
        return project;
    }

    public boolean canCreateProject(KnowledgeBaseFactory knowledgeBaseFactory, boolean bl) {
        return bl && knowledgeBaseFactory instanceof ClipsKnowledgeBaseFactory;
    }

    public WizardPage createCreateProjectWizardPage(CreateProjectWizard createProjectWizard, boolean bl) {
        return new ProtegeFromOWLFilesWizardPage((Wizard)createProjectWizard, this);
    }

    protected URI getBuildProjectURI() {
        int n;
        if (this.fileURI != null && this.fileURI.startsWith("file:") && (n = this.fileURI.lastIndexOf(46)) > 0) {
            String string = FileUtilities.replaceExtension((String)this.fileURI, (String)".pprj");
            try {
                return new URI(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.getBuildProjectURI();
    }

    protected void initializeSources(PropertyList propertyList) {
    }

    public void setDefaultClassView(Class clazz) {
    }

    public void setDefaultNamespace(String string) {
    }

    public void setDublinCoreRedirectToDLVersion(boolean bl) {
    }

    public void setFile(String string) {
        this.fileURI = string;
    }

    public void setLanguage(String string) {
    }

    public void setProfile(String string) {
    }
}

