/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.storage;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class KnowledgeBaseCopier {
    private KnowledgeBase source;
    private KnowledgeBase target;
    private Set doneSlots = new HashSet();
    private Hashtable frameMap = new Hashtable();
    private Map todoSlots = new HashMap();

    public KnowledgeBaseCopier(KnowledgeBase knowledgeBase, KnowledgeBase knowledgeBase2) {
        this.source = knowledgeBase;
        this.target = knowledgeBase2;
        this.doneSlots.add(":DIRECT-DOMAIN");
        this.doneSlots.add(":DIRECT-SUBCLASSES");
        this.doneSlots.add(":DIRECT-SUBSLOTS");
        this.doneSlots.add(":DIRECT-SUPERCLASSES");
        this.doneSlots.add(":DIRECT-SUPERSLOTS");
        this.doneSlots.add(":DIRECT-INSTANCES");
        this.doneSlots.add(":DIRECT-TEMPLATE-SLOTS");
        this.doneSlots.add(":DIRECT-TYPE");
        this.doneSlots.add(":SLOT-MAXIMUM-CARDINALITY");
        this.doneSlots.add(":SLOT-MINIMUM-CARDINALITY");
        this.doneSlots.add(":NAME");
        this.doneSlots.add(":SLOT-VALUE-TYPE");
    }

    public void run() {
        this.log("Creating Classes...");
        this.createClses();
        this.log("Creating Facets...");
        this.createFacets();
        this.createSlots();
        this.createInstances();
        this.createFacetOverrides();
        this.setOwnSlotValues();
        for (Slot slot : this.todoSlots.keySet()) {
            Slot slot2 = (Slot)this.todoSlots.get(slot);
            this.log("Setting value type of property: " + slot2 + " (Old slot: " + slot + ")");
            this.setValueType(slot, slot2);
        }
    }

    protected void addExtraDirectTypes(Instance instance, Instance instance2) {
        Collection collection = instance.getDirectTypes();
        Iterator iterator = collection.iterator();
        iterator.next();
        while (iterator.hasNext()) {
            Cls cls = (Cls)iterator.next();
            Cls cls2 = this.getNewCls(cls);
            if (instance2.hasDirectType(cls2)) continue;
            this.log("+ Adding direct type " + cls2.getBrowserText() + " to " + instance2.getBrowserText());
            instance2.addDirectType(cls2);
        }
    }

    protected Collection cloneValues(Collection collection) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object e : collection) {
            if (e instanceof Instance) {
                Instance instance = this.getNewInstance((Instance)e);
                if (instance == null) continue;
                arrayList.add(instance);
                continue;
            }
            arrayList.add(e);
        }
        return arrayList;
    }

    protected Cls createCls(String string, Cls cls) {
        this.log("+ Creating Class " + string + " of type " + cls);
        return this.target.createCls(string, this.target.getRootClses(), cls);
    }

    protected void createClses() {
        for (Cls cls : this.source.getClses()) {
            this.getNewCls(cls);
        }
    }

    private void createFacetOverrides() {
        for (Cls cls : this.source.getClses()) {
            if (!cls.isEditable() && (!cls.isIncluded() || cls.isSystem())) continue;
            this.createFacetOverrides(cls);
        }
    }

    protected void createFacetOverrides(Cls cls) {
        for (Slot slot : cls.getTemplateSlots()) {
            if (!cls.hasDirectlyOverriddenTemplateSlot(slot)) continue;
            this.createFacetOverrides(cls, slot);
        }
    }

    private void createFacetOverride(Cls cls, Slot slot, Facet facet) {
        Cls cls2 = this.getNewCls(cls);
        Slot slot2 = this.getNewSlot(slot);
        this.log("* Making facet override of " + slot.getBrowserText() + "." + facet.getBrowserText() + " at Cls " + cls.getBrowserText() + ", new: " + cls2.getBrowserText());
        if (facet.getName().equals(":VALUE-TYPE")) {
            ValueType valueType = cls.getTemplateSlotValueType(slot);
            cls2.setTemplateSlotValueType(slot2, valueType);
            if (valueType == ValueType.INSTANCE) {
                Collection collection = cls.getTemplateSlotAllowedClses(slot);
                Collection collection2 = this.cloneValues(collection);
                cls2.setTemplateSlotAllowedClses(slot2, collection2);
            } else if (valueType == ValueType.CLS) {
                Collection collection = cls.getTemplateSlotAllowedParents(slot);
                Collection collection3 = this.cloneValues(collection);
                cls2.setTemplateSlotAllowedParents(slot2, collection3);
            } else if (valueType == ValueType.SYMBOL) {
                Collection collection = cls.getTemplateSlotAllowedValues(slot);
                Collection collection4 = this.cloneValues(collection);
                cls2.setTemplateSlotAllowedValues(slot2, collection4);
            }
        } else {
            Collection collection = cls.getTemplateFacetValues(slot, facet);
            Collection collection5 = this.cloneValues(collection);
            Facet facet2 = this.getNewFacet(facet);
            cls2.setTemplateFacetValues(slot2, facet2, collection5);
        }
    }

    private void createFacetOverrides(Cls cls, Slot slot) {
        for (Facet facet : this.source.getFacets()) {
            if (!cls.hasDirectlyOverriddenTemplateFacet(slot, facet)) continue;
            this.createFacetOverride(cls, slot, facet);
        }
    }

    private void createFacets() {
        for (Facet facet : this.source.getFacets()) {
            this.getNewFacet(facet);
        }
    }

    protected Instance createInstance(String string, Cls cls) {
        return this.target.createInstance(string, cls);
    }

    private void createInstances() {
        for (Instance instance : this.source.getInstances()) {
            if (instance.getDirectType() == null || instance.getDirectType().isSystem()) continue;
            this.getNewInstance(instance);
        }
    }

    protected Slot createSlot(String string, ValueType valueType) {
        return this.target.createSlot(string);
    }

    private void createSlots() {
        for (Slot slot : this.source.getSlots()) {
            this.getNewSlot(slot);
        }
    }

    protected Cls getNewCls(Cls cls) {
        boolean bl = false;
        Cls cls2 = (Cls)this.frameMap.get(cls);
        cls2 = cls2 == null ? this.target.getCls(cls.getName()) : this.target.getCls(cls2.getName());
        if (cls2 == null) {
            Cls cls3;
            Cls cls4 = this.target.getCls("owl:Class");
            if (cls.equals(cls.getDirectType())) {
                System.err.println("Warning: Class " + cls + " is an instance of itself.");
                bl = true;
            } else {
                cls4 = this.getNewCls(cls.getDirectType());
            }
            if (cls4 == null) {
                System.err.println("ERROR: No type for " + cls);
                cls4 = cls.getKnowledgeBase().getCls("owl:Class");
                cls.setDirectType(cls4);
            }
            cls2 = this.createCls(cls.getName(), cls4);
            this.registerFrame((Frame)cls, (Frame)cls2);
            this.addExtraDirectTypes((Instance)cls, (Instance)cls2);
            if (bl) {
                cls2.addDirectType(cls2);
            }
            for (Cls cls5 : cls.getDirectSuperclasses()) {
                cls3 = this.getNewCls(cls5);
                if (cls2.hasDirectSuperclass(cls3)) continue;
                cls2.addDirectSuperclass(cls3);
                this.log("  + Adding " + cls3.getName() + " to superclasses of " + cls2.getName());
            }
            if (!cls.hasDirectSuperclass(this.source.getRootCls())) {
                cls2.removeDirectSuperclass(this.target.getRootCls());
            }
            for (Cls cls5 : cls.getDirectTemplateSlots()) {
                cls3 = this.getNewSlot((Slot)cls5);
                this.log("+ Added template slot " + cls3.getBrowserText() + " to " + cls2.getBrowserText());
                cls2.addDirectTemplateSlot((Slot)cls3);
            }
            this.setInitialOwnSlotValues((Instance)cls);
        }
        return cls2;
    }

    private Facet getNewFacet(Facet facet) {
        Facet facet2 = (Facet)this.frameMap.get(facet);
        if (facet2 == null) {
            facet2 = this.target.getFacet(facet.getName());
        }
        if (facet2 == null) {
            facet2 = this.target.createFacet(facet.getName());
            this.registerFrame((Frame)facet, (Frame)facet2);
            this.addExtraDirectTypes((Instance)facet, (Instance)facet2);
            this.setInitialOwnSlotValues((Instance)facet);
        }
        return facet2;
    }

    protected Instance getNewInstance(Instance instance) {
        if (instance instanceof Cls) {
            return this.getNewCls((Cls)instance);
        }
        if (instance instanceof Slot) {
            return this.getNewSlot((Slot)instance);
        }
        if (instance instanceof Facet) {
            return this.getNewFacet((Facet)instance);
        }
        Instance instance2 = (Instance)this.frameMap.get(instance);
        String string = instance.getName();
        if (instance2 == null) {
            instance2 = this.target.getInstance(string);
        }
        if (instance2 == null) {
            Cls cls = instance.getDirectType();
            if (cls == null) {
                System.err.println("Warning: Instance " + instance.getName() + " has no direct type [Ignored]");
                return null;
            }
            Cls cls2 = this.getNewCls(cls);
            instance2 = this.createInstance(string, cls2);
            this.registerFrame((Frame)instance, (Frame)instance2);
            this.addExtraDirectTypes(instance, instance2);
            this.setInitialOwnSlotValues(instance);
        }
        return instance2;
    }

    protected Slot getNewSlot(Slot slot) {
        Slot slot2 = (Slot)this.frameMap.get(slot);
        if (slot2 == null) {
            String string = slot.getName();
            slot2 = this.target.getSlot(string);
        }
        if (slot2 == null) {
            slot2 = this.createSlot(slot.getName(), slot.getValueType());
            this.registerFrame((Frame)slot, (Frame)slot2);
            this.addExtraDirectTypes((Instance)slot, (Instance)slot2);
            this.todoSlots.put(slot, slot2);
            this.setDirectType((Instance)slot, (Instance)slot2);
            slot2.setMinimumCardinality(slot.getMinimumCardinality());
            slot2.setMaximumCardinality(slot.getMaximumCardinality());
            for (Slot slot3 : slot.getDirectSuperslots()) {
                Slot slot4 = this.getNewSlot(slot3);
                if (slot2.getDirectSuperslots().contains(slot4)) continue;
                slot2.addDirectSuperslot(slot4);
            }
            this.setInitialOwnSlotValues((Instance)slot);
        }
        return slot2;
    }

    protected void log(String string) {
    }

    private void registerFrame(Frame frame, Frame frame2) {
        String string;
        String string2 = frame.getName();
        if (!string2.equals(string = frame2.getName())) {
            this.frameMap.put(frame, frame2);
        }
    }

    protected void setDirectType(Instance instance, Instance instance2) {
        Cls cls = instance.getDirectType();
        Cls cls2 = this.getNewCls(cls);
        if (!cls2.equals(instance2.getDirectType())) {
            instance2.setDirectType(cls2);
        }
    }

    protected void setInitialOwnSlotValues(Instance instance) {
    }

    private void setOwnSlotValues() {
        for (Instance instance : this.source.getInstances()) {
            if (instance.isSystem() || !instance.isEditable() && !instance.isIncluded()) continue;
            this.setOwnSlotValues(instance);
        }
    }

    private void setOwnSlotValues(Instance instance) {
        Instance instance2 = this.getNewInstance(instance);
        if (instance2 != null) {
            this.log("+ Setting own slot values of " + instance.getBrowserText() + " (new: " + instance2.getBrowserText() + ")");
            for (Slot slot : instance.getOwnSlots()) {
                if (this.doneSlots.contains(slot.getName())) continue;
                this.setOwnSlotValues((Frame)instance2, instance, slot);
            }
        }
    }

    protected void setOwnSlotValues(Frame frame, Instance instance, Slot slot) {
        Slot slot2 = this.getNewSlot(slot);
        Collection collection = instance.getOwnSlotValues(slot);
        if (collection.size() > 0) {
            this.log(" - " + slot + " (" + collection.size() + " values)");
            Collection collection2 = this.cloneValues(collection);
            if (!((Object)collection2).equals(frame.getOwnSlotValues(slot2))) {
                frame.setOwnSlotValues(slot2, collection2);
            }
        }
    }

    protected void setValueType(Slot slot, Slot slot2) {
        slot2.setValueType(slot.getValueType());
        if (slot.getValueType() == ValueType.INSTANCE) {
            Collection collection = this.cloneValues(slot.getAllowedClses());
            slot2.setAllowedClses(collection);
        } else if (slot.getValueType() == ValueType.CLS) {
            Collection collection = this.cloneValues(slot.getAllowedParents());
            slot2.setAllowedParents(collection);
        } else if (slot.getValueType() == ValueType.SYMBOL) {
            Collection collection = slot.getAllowedValues();
            slot2.setAllowedValues(collection);
        }
    }
}

