/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.repository.util;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.URIUtilities;
import edu.stanford.smi.protegex.owl.ProtegeOWL;
import edu.stanford.smi.protegex.owl.jena.JenaKnowledgeBaseFactory;
import edu.stanford.smi.protegex.owl.jena.parser.ProtegeOWLParser;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.RepositoryManager;
import edu.stanford.smi.protegex.owl.repository.factory.RepositoryFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class RepositoryFileManager {
    public static final String REPOSITORY_EXTENTION = ".repository";
    public static final String GLOBAL_REPOSITORY_FILE_NAME = "global.repository";
    private RepositoryManager manager;
    private OWLModel model;

    public RepositoryFileManager(OWLModel oWLModel) {
        this.model = oWLModel;
        this.manager = this.model.getRepositoryManager();
    }

    public void loadProjectRepositories() {
        URI uRI = this.getProjectRepositoryURI();
        if (uRI != null) {
            this.manager.removeAllProjectRepositories();
            this.loadRepositoriesFromURI(uRI);
        }
    }

    private void loadGlobalRepositories(File file) {
        if (file.exists()) {
            this.loadRepositoriesFromFile(file, true);
        }
    }

    public void loadGlobalRepositories() {
        File file = ProtegeOWL.getPluginFolder();
        if ((file = new File(file, GLOBAL_REPOSITORY_FILE_NAME)).exists()) {
            this.loadGlobalRepositories(file);
        }
    }

    public void saveProjectRepositories(URI uRI) {
        File file = this.getProjectRepositoryFile(uRI);
        if (file != null) {
            this.saveProjectRepositories(file);
        }
    }

    public void saveProjectRepositories() {
        File file;
        Project project = this.model.getProject();
        if (project != null && project.getProjectURI() != null && (file = this.getProjectRepositoryFile()) != null) {
            this.saveProjectRepositories(file);
        }
    }

    private void saveProjectRepositories(File file) {
        ArrayList<Repository> arrayList = new ArrayList<Repository>();
        for (Repository repository : this.manager.getProjectRepositories()) {
            if (repository.isSystem()) continue;
            arrayList.add(repository);
        }
        if (arrayList.size() > 0) {
            this.saveRepositories(arrayList, file);
        } else {
            file.delete();
        }
    }

    public void saveGlobalRepositories() {
        File file = PluginUtilities.getPluginsDirectory();
        if (file != null && file.exists()) {
            File file2 = ProtegeOWL.getPluginFolder();
            file2 = new File(file2, GLOBAL_REPOSITORY_FILE_NAME);
            this.saveRepositories(this.manager.getGlobalRepositories(), file2);
        }
    }

    private void saveRepositories(List list, File file) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            for (Repository repository : list) {
                String string;
                if (repository.isSystem() || (string = repository.getRepositoryDescriptor()) == null || string.length() <= 0) continue;
                bufferedWriter.write(string);
                bufferedWriter.write("\n");
            }
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println(fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
    }

    private void loadRepositoriesFromFile(File file, boolean bl) {
        try {
            String string;
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            while ((string = bufferedReader.readLine()) != null) {
                RepositoryFactory repositoryFactory;
                Repository repository;
                if ((string = string.trim()).length() <= 0 || (repository = (repositoryFactory = RepositoryFactory.getInstance()).createOntRepository(this.model, string)) == null) continue;
                if (bl) {
                    this.manager.addGlobalRepository(repository);
                    continue;
                }
                this.manager.addProjectRepository(repository);
            }
        }
        catch (IOException iOException) {
            Log.getLogger().warning("[Repository Manager] Could not find repository file: " + file.toString());
        }
    }

    private void loadRepositoriesFromURI(URI uRI) {
        try {
            String string;
            URL uRL = new URL(uRI.toString());
            InputStream inputStream = ProtegeOWLParser.getInputStream(uRL);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string = bufferedReader.readLine()) != null) {
                RepositoryFactory repositoryFactory;
                Repository repository;
                if ((string = string.trim()).length() <= 0 || (repository = (repositoryFactory = RepositoryFactory.getInstance()).createOntRepository(this.model, string)) == null) continue;
                this.manager.addProjectRepository(repository);
            }
            inputStream.close();
        }
        catch (IOException iOException) {
            Log.getLogger().warning("[Repository Manager] Could not find repository file: " + uRI.toString());
        }
    }

    private File getProjectRepositoryFile() {
        Project project = this.model.getProject();
        if (project != null) {
            URI uRI = project.getProjectURI();
            try {
                if (uRI == null && project.getKnowledgeBaseFactory() instanceof JenaKnowledgeBaseFactory) {
                    String string = JenaKnowledgeBaseFactory.getOWLFilePath(project.getSources());
                    uRI = URIUtilities.createURI((String)string);
                }
            }
            catch (Exception exception) {
                Log.getLogger().warning("Failed to find repository file for " + project);
            }
            if (uRI != null) {
                return this.getProjectRepositoryFile(uRI);
            }
        }
        return null;
    }

    private URI getProjectRepositoryURI() {
        Project project = this.model.getProject();
        if (project != null) {
            URI uRI = project.getProjectURI();
            try {
                if (uRI == null && project.getKnowledgeBaseFactory() instanceof JenaKnowledgeBaseFactory) {
                    String string = JenaKnowledgeBaseFactory.getOWLFilePath(project.getSources());
                    uRI = URIUtilities.createURI((String)string);
                }
            }
            catch (Exception exception) {
                Log.getLogger().warning("Failed to find repository file for " + project);
            }
            if (uRI != null) {
                return this.getProjectRepositoryURI(uRI);
            }
        }
        return null;
    }

    private URI getProjectRepositoryURI(URI uRI) {
        return URIUtilities.replaceExtension((URI)uRI, (String)REPOSITORY_EXTENTION);
    }

    private File getProjectRepositoryFile(URI uRI) {
        File file = new File(uRI);
        String string = file.getName();
        string = FileUtilities.replaceExtension((String)string, (String)REPOSITORY_EXTENTION);
        string = FileUtilities.ensureExtension((String)string, (String)REPOSITORY_EXTENTION);
        file = new File(file.getParentFile(), string);
        return file;
    }
}

