/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.repository.util;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.repository.util.XMLBaseExtractor;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class OntologyNameExtractor {
    private InputStream is;
    private URI uri;
    private URL url;
    private boolean rdfRootPresent;

    public OntologyNameExtractor(InputStream inputStream, URL uRL) {
        this.is = inputStream;
        this.url = uRL;
        this.uri = null;
        this.rdfRootPresent = false;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (this.is != null) {
            try {
                XMLBaseExtractor xMLBaseExtractor = new XMLBaseExtractor(this.is);
                this.uri = xMLBaseExtractor.getXMLBase();
                String string = xMLBaseExtractor.getRootElementName();
                if (string != null) {
                    this.rdfRootPresent = string.toLowerCase().equals("rdf:rdf");
                    if (this.rdfRootPresent && this.uri == null) {
                        try {
                            this.uri = this.url.toURI();
                            Log.getLogger().warning("Could not find the logical URI for the ontology located at " + this.url + ". Using the physical location as the ontology logical URI.");
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            Log.emptyCatchBlock((Throwable)uRISyntaxException);
                        }
                    }
                } else {
                    this.uri = null;
                }
            }
            finally {
                this.is = null;
            }
        }
    }

    public boolean isRDFRootElementPresent() {
        return this.rdfRootPresent;
    }

    public URI getOntologyName() throws IOException {
        return this.uri;
    }
}

