/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.repository.impl;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.factory.RepositoryFactoryPlugin;
import edu.stanford.smi.protegex.owl.repository.impl.LocalFileRepository;
import edu.stanford.smi.protegex.owl.repository.util.RepositoryUtil;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;

public class LocalFileRepositoryFactoryPlugin
implements RepositoryFactoryPlugin {
    public static final String FILE_PREFIX = "file:";

    public boolean isSuitable(OWLModel oWLModel, String string) {
        return this.getRepositoryFile(oWLModel, string) != null;
    }

    public Repository createRepository(OWLModel oWLModel, String string) {
        try {
            URI uRI = new URI(string);
            return new LocalFileRepository(this.getRepositoryFile(oWLModel, string), RepositoryUtil.isForcedToBeReadOnly(uRI.getQuery()));
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File getRepositoryFile(OWLModel oWLModel, String string) {
        if (!string.trim().startsWith(FILE_PREFIX)) {
        }
        try {
            File file = new File(new URI(string).getPath());
            if (file.isFile()) {
                if (file.canRead()) {
                    return file;
                }
            }
        }
        finally {
            return null;
        }
    }
}

