/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.repository.impl;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.jena.parser.ProtegeOWLParser;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.util.OntologyNameExtractor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;

public class ForcedURLRetrievalRepository
implements Repository {
    private URL url;
    private URI uri;
    private URI actualOntologyName;

    public ForcedURLRetrievalRepository(URL uRL) {
        this.url = uRL;
        this.uri = null;
        this.refresh();
    }

    public boolean contains(URI uRI) {
        if (this.uri != null) {
            return uRI.equals(this.uri);
        }
        return false;
    }

    public void refresh() {
        try {
            InputStream inputStream = ProtegeOWLParser.getInputStream(this.url);
            OntologyNameExtractor ontologyNameExtractor = new OntologyNameExtractor(inputStream, this.url);
            if (ontologyNameExtractor.isRDFRootElementPresent()) {
                this.actualOntologyName = ontologyNameExtractor.getOntologyName();
                try {
                    this.uri = new URI(this.url.toString());
                }
                catch (URISyntaxException uRISyntaxException) {
                    Log.getLogger().log(Level.SEVERE, "Exception caught", uRISyntaxException);
                }
            } else {
                this.uri = null;
            }
        }
        catch (IOException iOException) {
            this.uri = null;
        }
    }

    public Collection getOntologies() {
        return Collections.singleton(this.uri);
    }

    public InputStream getInputStream(URI uRI) throws IOException {
        if (this.uri != null) {
            return ProtegeOWLParser.getInputStream(this.url);
        }
        return null;
    }

    public boolean isWritable(URI uRI) {
        return false;
    }

    public OutputStream getOutputStream(URI uRI) throws IOException {
        return null;
    }

    public boolean isSystem() {
        return false;
    }

    public String getRepositoryDescription() {
        return "Forced HTTP retrieval";
    }

    public String getOntologyLocationDescription(URI uRI) {
        return this.url.toString() + " [actual ontology at this location: " + this.actualOntologyName + "]";
    }

    public String getRepositoryDescriptor() {
        return this.url.toString();
    }
}

