/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.repository.impl;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.util.OntologyNameExtractor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractLocalRepository
implements Repository {
    private File file;
    private boolean forceReadOnly;
    private Map ontologies;

    public AbstractLocalRepository(File file, boolean bl) {
        this.file = file;
        this.forceReadOnly = bl;
        this.ontologies = new HashMap();
    }

    protected File getFile() {
        return this.file;
    }

    public void refresh() {
        this.ontologies = new HashMap();
    }

    protected void putOntology(URI uRI, File file) {
        this.ontologies.put(uRI, file);
    }

    public boolean contains(URI uRI) {
        return this.ontologies.keySet().contains(uRI);
    }

    public Collection getOntologies() {
        return Collections.unmodifiableCollection(this.ontologies.keySet());
    }

    public InputStream getInputStream(URI uRI) throws IOException {
        File file = (File)this.ontologies.get(uRI);
        if (file != null) {
            return new FileInputStream(file);
        }
        return null;
    }

    public OutputStream getOutputStream(URI uRI) throws IOException {
        if (this.isWritable(uRI)) {
            File file = (File)this.ontologies.get(uRI);
            return new FileOutputStream(file);
        }
        return null;
    }

    public boolean isSystem() {
        return false;
    }

    public String getOntologyLocationDescription(URI uRI) {
        File file = (File)this.ontologies.get(uRI);
        if (file != null) {
            return file.getAbsolutePath();
        }
        return "";
    }

    public String getRepositoryDescriptor() {
        try {
            return this.file.toURI().toURL().toString() + "?" + "forceReadOnly" + "=" + Boolean.toString(this.forceReadOnly);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public boolean isWritable(URI uRI) {
        if (!this.forceReadOnly) {
            File file = (File)this.ontologies.get(uRI);
            if (file != null) {
                return file.canWrite();
            }
            return false;
        }
        return false;
    }

    public boolean isForceReadOnly() {
        return this.forceReadOnly;
    }

    public void setForceReadOnly(boolean bl) {
        this.forceReadOnly = bl;
    }

    protected URI processFile(File file) {
        URI uRI = null;
        try {
            PrintStream printStream = System.err;
            System.setErr(new PrintStream(new OutputStream(){

                public void write(int n) throws IOException {
                }
            }));
            FileInputStream fileInputStream = new FileInputStream(file);
            OntologyNameExtractor ontologyNameExtractor = new OntologyNameExtractor(fileInputStream, file.toURI().toURL());
            uRI = ontologyNameExtractor.getOntologyName();
            System.setErr(printStream);
        }
        catch (Exception exception) {
            Log.emptyCatchBlock((Throwable)exception);
        }
        return uRI;
    }
}

