/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.prose;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLCardinality;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ProseGen {
    private static boolean checked = false;
    private static int indentLevel = 0;
    private static boolean includePreText = true;
    private static boolean insertNoTabs = false;
    private static boolean setTags = false;

    ProseGen() {
        indentLevel = 0;
    }

    private static String insertTabSpaces() {
        if (!setTags) {
            return "";
        }
        String string = "";
        for (int i = 0; i < indentLevel; ++i) {
            string = string + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
        }
        if (indentLevel > 0) {
            string = string + "<b><FONT size=4>-&nbsp;</FONT></b>";
        }
        return string;
    }

    private static String makePluralIfNecessary(String string) {
        if (!string.toLowerCase().endsWith("s")) {
            return string + "s";
        }
        return string;
    }

    private static boolean isDemarcatingCharacter(char c) {
        return !Character.isLetterOrDigit(c) && c != '<' && c != '>' && c != '/' && c != '&' && c != ';' && c != '-';
    }

    private static boolean isDemarcatingCharacter(char c, char c2, char c3) {
        if (ProseGen.isDemarcatingCharacter(c2)) {
            return true;
        }
        return Character.isUpperCase(c2) && Character.isLowerCase(c) && Character.isLowerCase(c3);
    }

    private static boolean hasVowelStartChar(String string) {
        String string2 = string.toLowerCase().trim();
        return string2.length() > 1 && (string2.startsWith("a") || string2.startsWith("e") || string2.startsWith("i") || string2.startsWith("o") || string2.startsWith("u"));
    }

    private static String splitWordOnCapitals(String string) {
        if ((string = string.trim()).length() > 0) {
            int n;
            char[] cArray = string.toCharArray();
            String string2 = "";
            String string3 = "";
            if (!ProseGen.isDemarcatingCharacter(cArray[0])) {
                string3 = string3 + cArray[0];
            }
            for (n = 1; n < cArray.length - 1; ++n) {
                char c;
                if (ProseGen.isDemarcatingCharacter(cArray[n - 1], cArray[n], cArray[n + '\u0001']) && string3 != "") {
                    string2 = string2 + " " + string3;
                    string3 = "";
                }
                if (ProseGen.isDemarcatingCharacter(c = cArray[n])) continue;
                string3 = string3 + c;
            }
            n = cArray[cArray.length - 1];
            if (!ProseGen.isDemarcatingCharacter((char)n) && cArray.length > 1) {
                string3 = string3 + (char)n;
            }
            if (string2 != "") {
                string2 = string2 + " ";
            }
            string2 = string2 + string3;
            return string2;
        }
        return "";
    }

    private static String getProseFromIntersectionCls(OWLIntersectionClass oWLIntersectionClass) {
        Collection collection = oWLIntersectionClass.getOperands();
        String string = "";
        if (insertNoTabs) {
            string = string + "The intersection of";
        } else if (!includePreText && indentLevel != 0) {
            string = string + "<br>" + ProseGen.insertTabSpaces() + "The intersection of</br>";
            includePreText = true;
        } else if (indentLevel > 0 && includePreText) {
            string = string + "<br>" + ProseGen.insertTabSpaces() + "The intersection of</br>";
        } else if (includePreText) {
            string = string + "The intersection of";
        }
        ++indentLevel;
        if (collection.size() == 1) {
            Iterator iterator = collection.iterator();
            string = string + "<br>" + ProseGen.insertTabSpaces() + ((RDFSClass)iterator.next()).getBrowserText() + "</br>";
        }
        for (RDFSClass rDFSClass : collection) {
            String string2;
            if (!(rDFSClass instanceof OWLNamedClass || rDFSClass instanceof OWLIntersectionClass || rDFSClass instanceof OWLUnionClass)) {
                string2 = ProseGen.getProseFromCls(rDFSClass);
                if (string2.toLowerCase().startsWith("has")) {
                    string = string + "<br>" + ProseGen.insertTabSpaces() + "Any object that " + string2 + "</br>";
                    continue;
                }
                if (string2.toLowerCase().startsWith("is")) {
                    string = string + "<br>" + ProseGen.insertTabSpaces() + string2 + "</br>";
                    continue;
                }
                if (string2 == "") continue;
                string = string + "<br>" + ProseGen.insertTabSpaces() + "Any object where " + string2 + "</br>";
                continue;
            }
            string2 = ProseGen.splitWordOnCapitals(ProseGen.getProseFromCls(rDFSClass)).trim();
            if (string2 == "") continue;
            string = string + "<br>" + ProseGen.insertTabSpaces() + string2 + "</br>";
        }
        --indentLevel;
        return string;
    }

    private static String getProseFromUnionCls(OWLUnionClass oWLUnionClass) {
        Collection collection = oWLUnionClass.getOperands();
        String string = "";
        if (insertNoTabs) {
            string = string + "The union of";
        } else if (!includePreText && indentLevel != 0) {
            string = string + "<br>" + ProseGen.insertTabSpaces() + "The union of</br>";
            includePreText = true;
        } else if (indentLevel > 0 && includePreText) {
            string = string + "<br>" + ProseGen.insertTabSpaces() + "The intersection of</br>";
        } else if (includePreText) {
            string = string + "The union of";
        }
        ++indentLevel;
        if (collection.size() == 1) {
            Iterator iterator = collection.iterator();
            string = string + "<br>" + ProseGen.insertTabSpaces() + ((RDFSClass)iterator.next()).getBrowserText() + "</br>";
        }
        for (RDFSClass rDFSClass : collection) {
            String string2;
            if (!(rDFSClass instanceof OWLNamedClass || rDFSClass instanceof OWLIntersectionClass || rDFSClass instanceof OWLUnionClass)) {
                string2 = ProseGen.getProseFromCls(rDFSClass);
                if (string2.toLowerCase().startsWith("has")) {
                    string = string + "<br>" + ProseGen.insertTabSpaces() + "Any object that " + string2 + "</br>";
                    continue;
                }
                if (string2.toLowerCase().startsWith("is")) {
                    string = string + "<br>" + ProseGen.insertTabSpaces() + string2 + "</br>";
                    continue;
                }
                if (string2 == "") continue;
                string = string + "<br>" + ProseGen.insertTabSpaces() + "Any object where " + string2 + "</br>";
                continue;
            }
            string2 = ProseGen.splitWordOnCapitals(ProseGen.getProseFromCls(rDFSClass)).trim();
            if (string2 == "") continue;
            string = string + "<br>" + ProseGen.insertTabSpaces() + string2 + "</br>";
        }
        --indentLevel;
        return string;
    }

    private static String getProseFromComplementCls(OWLComplementClass oWLComplementClass) {
        RDFSClass rDFSClass = oWLComplementClass.getComplement();
        String string = "";
        String string2 = ProseGen.getProseFromCls(rDFSClass);
        if (string2.toLowerCase().startsWith("has")) {
            string2 = string2.replaceFirst("has", "have");
            string = string + "Does not " + string2;
        } else {
            string = string2.toLowerCase().indexOf(" is ") > 0 ? string + string2.replaceAll(" is ", " is not ") : (!ProseGen.hasVowelStartChar(string2) ? string + "Is not a " + ProseGen.splitWordOnCapitals(string2) : string + "Is not an " + ProseGen.splitWordOnCapitals(string2));
        }
        return string;
    }

    private static String getProseFromMaxCardiRestriction(OWLMaxCardinality oWLMaxCardinality) {
        int n = oWLMaxCardinality.getCardinality();
        String string = oWLMaxCardinality.getOnProperty().getName();
        String string2 = "";
        if (includePreText) {
            string2 = string2 + "the property ";
        }
        if (string.toLowerCase().startsWith("has")) {
            String string3 = string.substring(3);
            string2 = n == 1 || string3.endsWith("s") ? "has at most " + n + " " + ProseGen.splitWordOnCapitals(string3) : "has at most " + n + " " + ProseGen.splitWordOnCapitals(string3) + "s";
        } else if (string.toLowerCase().startsWith("is")) {
            String string4 = string.toLowerCase().substring(2);
            string2 = "is " + ProseGen.splitWordOnCapitals(string4) + " " + n;
        } else {
            string2 = n == 1 ? string2 + ProseGen.splitWordOnCapitals(string) + " has at most " + n + " value" : string2 + ProseGen.splitWordOnCapitals(string) + " has at most " + n + " values";
        }
        return string2;
    }

    private static String getProseFromMinCardiRestriction(OWLMinCardinality oWLMinCardinality) {
        int n = oWLMinCardinality.getCardinality();
        String string = oWLMinCardinality.getOnProperty().getName();
        String string2 = "";
        if (includePreText) {
            string2 = string2 + "the property ";
        }
        if (string.toLowerCase().startsWith("has")) {
            String string3 = string.substring(3);
            string2 = n == 1 || string3.endsWith("s") ? "has at least " + n + " " + ProseGen.splitWordOnCapitals(string3) : "has at least " + n + " " + ProseGen.splitWordOnCapitals(string3) + "s";
        } else {
            string2 = n == 1 ? string2 + ProseGen.splitWordOnCapitals(string) + " has at least " + n + " value" : string2 + ProseGen.splitWordOnCapitals(string) + " has at least " + n + " values";
        }
        return string2;
    }

    private static String getProseFromCardiRestriction(OWLCardinality oWLCardinality) {
        int n = oWLCardinality.getCardinality();
        String string = oWLCardinality.getOnProperty().getName();
        String string2 = "";
        if (includePreText) {
            string2 = string2 + "the property ";
        }
        if (string.toLowerCase().startsWith("has")) {
            String string3 = string.substring(3);
            string2 = n == 1 || string3.endsWith("s") ? "has exactly " + n + " " + ProseGen.splitWordOnCapitals(string3) : "has exactly " + n + " " + ProseGen.splitWordOnCapitals(string3) + "s";
        } else {
            string2 = n == 1 ? string2 + ProseGen.splitWordOnCapitals(string) + " has exactly " + n + " value" : string2 + ProseGen.splitWordOnCapitals(string) + " has exactly " + n + " values";
        }
        return string2;
    }

    private static String getProseFromHasRestriction(OWLHasValue oWLHasValue) {
        String string;
        Object object = oWLHasValue.getHasValue();
        String string2 = "";
        String string3 = object instanceof RDFResource ? ((RDFResource)object).getBrowserText() : object.toString();
        RDFProperty rDFProperty = oWLHasValue.getOnProperty();
        String string4 = string = rDFProperty.getName();
        if (string.toLowerCase().startsWith("has")) {
            String string5 = string.substring(3);
            string2 = string3.equalsIgnoreCase("true") ? "has " + ProseGen.splitWordOnCapitals(string5) : (string3.equalsIgnoreCase("false") ? "has no " + ProseGen.splitWordOnCapitals(string5) : "has " + ProseGen.splitWordOnCapitals(string3) + " " + ProseGen.splitWordOnCapitals(string5));
        } else if (string.toLowerCase().startsWith("is")) {
            String string6 = string.substring(2);
            string2 = string3.equalsIgnoreCase("false") ? "is not " + ProseGen.splitWordOnCapitals(string6) : (string3.equalsIgnoreCase("true") ? "is " + ProseGen.splitWordOnCapitals(string6) : "is " + ProseGen.splitWordOnCapitals(string6) + " " + ProseGen.splitWordOnCapitals(string3));
        } else {
            string2 = "the property " + ProseGen.splitWordOnCapitals(string4) + " has value " + ProseGen.splitWordOnCapitals(string3);
        }
        return string2;
    }

    private static String generatePreText(RDFSClass rDFSClass, RDFSClass rDFSClass2) {
        if (rDFSClass instanceof OWLIntersectionClass) {
            return "are";
        }
        if (rDFSClass instanceof OWLNamedClass) {
            if (rDFSClass2 instanceof OWLSomeValuesFrom) {
                return "is of type";
            }
            return "are of type";
        }
        if (rDFSClass instanceof OWLMaxCardinality) {
            return "must have at most";
        }
        if (rDFSClass instanceof OWLCardinality) {
            return "must be an object where";
        }
        if (rDFSClass instanceof OWLMinCardinality) {
            return "must be an object where";
        }
        if (rDFSClass instanceof OWLHasValue) {
            return "must be an object where";
        }
        if (rDFSClass instanceof OWLSomeValuesFrom) {
            return "must be an object where";
        }
        if (rDFSClass instanceof OWLAllValuesFrom) {
            return "must be an object where";
        }
        if (rDFSClass instanceof OWLEnumeratedClass) {
            return "are either";
        }
        if (rDFSClass instanceof OWLComplementClass) {
            return "must be an object that";
        }
        if (rDFSClass instanceof OWLUnionClass) {
            return "are";
        }
        return "";
    }

    private static String getProseFromSomeRestriction(OWLSomeValuesFrom oWLSomeValuesFrom) {
        String string = "";
        String string2 = "";
        String string3 = oWLSomeValuesFrom.getOnProperty().getName();
        RDFResource rDFResource = oWLSomeValuesFrom.getFiller();
        if (!(rDFResource instanceof RDFSClass)) {
            if (rDFResource instanceof OWLDataRange) {
                OWLDataRange oWLDataRange = (OWLDataRange)rDFResource;
                RDFList rDFList = oWLDataRange.getOneOf();
                if (rDFList != null) {
                    List list = rDFList.getValues();
                    Object object = list.iterator();
                    while (object.hasNext()) {
                        string2 = string2 + "\"" + object.next() + "\"";
                        if (!object.hasNext()) continue;
                        string2 = string2 + " or ";
                    }
                    if (list.size() == 0) {
                        string = "at least one of the values of the " + ProseGen.splitWordOnCapitals(string3) + " property has no type";
                    } else if (string3.toLowerCase().startsWith("has")) {
                        object = string3.substring(3);
                        string = "at least one of the values has either " + ProseGen.splitWordOnCapitals(string2) + " " + ProseGen.splitWordOnCapitals((String)object);
                    } else if (string3.toLowerCase().startsWith("is")) {
                        object = string3.substring(2);
                        string = "some of the values are " + ProseGen.splitWordOnCapitals((String)object) + " " + ProseGen.splitWordOnCapitals(string2);
                    } else {
                        string = "at least one of the values of the " + ProseGen.splitWordOnCapitals(string3) + " property is either " + ProseGen.splitWordOnCapitals(string2);
                    }
                } else {
                    string = "no value";
                }
            } else {
                string2 = rDFResource.getName();
                if (string3.toLowerCase().startsWith("has")) {
                    String string4 = string3.substring(3);
                    string = "at least one value has " + ProseGen.splitWordOnCapitals(string2) + " " + ProseGen.splitWordOnCapitals(string4);
                } else if (string3.toLowerCase().startsWith("is")) {
                    String string5 = string3.substring(2);
                    string = "some of the values are " + ProseGen.splitWordOnCapitals(string5) + " " + ProseGen.splitWordOnCapitals(string2);
                } else {
                    string = "at least one of the values of the " + ProseGen.splitWordOnCapitals(string3) + " property is of type " + string2;
                }
            }
        } else {
            RDFSClass rDFSClass = (RDFSClass)rDFResource;
            insertNoTabs = true;
            string2 = ProseGen.getProseFromCls(rDFSClass);
            insertNoTabs = false;
            if (string3.toLowerCase().startsWith("has")) {
                String string6 = string3.substring(3);
                String string7 = ProseGen.splitWordOnCapitals(string2);
                string = string7.toLowerCase().endsWith("s") ? "has " + string7 + " as its " + ProseGen.splitWordOnCapitals(string6) : "has " + (ProseGen.hasVowelStartChar(string7) ? "an " : "a ") + string7 + " as its " + ProseGen.splitWordOnCapitals(string6);
            } else if (string3.toLowerCase().startsWith("is")) {
                String string8 = string3.substring(2);
                string = "Some instances are " + ProseGen.splitWordOnCapitals(string8) + " " + string2;
            } else {
                string = "at least one of the values of the " + ProseGen.splitWordOnCapitals(string3) + " property " + ProseGen.generatePreText(rDFSClass, oWLSomeValuesFrom) + " " + ProseGen.splitWordOnCapitals(string2);
            }
        }
        return string;
    }

    private static String getProseFromAllRestriction(OWLAllValuesFrom oWLAllValuesFrom) {
        String string = "";
        String string2 = "";
        String string3 = oWLAllValuesFrom.getOnProperty().getName();
        RDFResource rDFResource = oWLAllValuesFrom.getFiller();
        if (!(rDFResource instanceof RDFSClass)) {
            if (rDFResource instanceof OWLDataRange) {
                RDFList rDFList = ((OWLDataRange)rDFResource).getOneOf();
                List list = rDFList == null ? Collections.EMPTY_LIST : rDFList.getValues();
                Object object = list.iterator();
                while (object.hasNext()) {
                    string = string + "\"" + object.next() + "\"";
                    if (!object.hasNext()) continue;
                    string = string + " or ";
                }
                if (string3.toLowerCase().startsWith("has")) {
                    object = string3.toLowerCase().split("has");
                    if (((String[])object).length > 1) {
                        string2 = "has " + string + " " + object[1];
                    }
                } else if (string3.toLowerCase().startsWith("is")) {
                    object = string3.toLowerCase().split("is");
                    if (((String[])object).length > 1) {
                        string2 = "is " + object[1] + " " + string;
                    }
                } else if (list.isEmpty()) {
                    string2 = "all values of the " + ProseGen.splitWordOnCapitals(string3) + " property have no type";
                } else if (string3.toLowerCase().startsWith("has")) {
                    object = string3.substring(3);
                    string2 = "all values have either " + ProseGen.splitWordOnCapitals(string) + " " + ProseGen.splitWordOnCapitals((String)object);
                } else if (string3.toLowerCase().startsWith("is")) {
                    object = string3.substring(2);
                    string2 = "all instances are " + ProseGen.splitWordOnCapitals((String)object) + " " + ProseGen.splitWordOnCapitals(string);
                } else {
                    string2 = "all values of the " + ProseGen.splitWordOnCapitals(string3) + " property are either " + ProseGen.splitWordOnCapitals(string);
                }
            } else {
                string = rDFResource.getName();
                if (string3.toLowerCase().startsWith("has")) {
                    String string4 = string3.substring(3);
                    string2 = "all values have " + ProseGen.splitWordOnCapitals(string) + " " + ProseGen.splitWordOnCapitals(string4);
                } else {
                    string2 = "all values of the " + ProseGen.splitWordOnCapitals(string3) + " property are of type " + ProseGen.splitWordOnCapitals(string);
                }
            }
        } else {
            RDFSClass rDFSClass = (RDFSClass)rDFResource;
            insertNoTabs = true;
            string = ProseGen.getProseFromCls(rDFSClass);
            insertNoTabs = false;
            if (string3.toLowerCase().startsWith("has")) {
                String string5 = string3.substring(3);
                string2 = "all " + ProseGen.makePluralIfNecessary(ProseGen.splitWordOnCapitals(string5)) + " are " + ProseGen.splitWordOnCapitals(string);
            } else if (string3.toLowerCase().startsWith("is")) {
                String string6 = string3.substring(2);
                string2 = "All instances are " + ProseGen.splitWordOnCapitals(string6) + " " + ProseGen.splitWordOnCapitals(string);
            } else {
                string2 = "all values of the " + ProseGen.splitWordOnCapitals(string3) + " property " + ProseGen.generatePreText(rDFSClass, oWLAllValuesFrom) + " " + string;
            }
        }
        return string2;
    }

    private static String getProseFromEnumerationCls(OWLEnumeratedClass oWLEnumeratedClass) {
        Collection collection = oWLEnumeratedClass.getOneOf();
        String string = "";
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Instance instance = (Instance)iterator.next();
            string = string + instance.getName();
            if (!iterator.hasNext()) continue;
            string = string + " or ";
        }
        string = string + "";
        return string;
    }

    private static String getProseFromNamedCls(OWLNamedClass oWLNamedClass) {
        String string = oWLNamedClass.getBrowserText();
        if (string.split(":").length > 1) {
            string = string.split(":")[1];
        }
        String string2 = "";
        if (!checked) {
            checked = true;
            string2 = string2 + string;
        } else if (string != null) {
            string2 = string2 + string;
        }
        return ProseGen.splitWordOnCapitals(string2).trim();
    }

    public static String getProseFromCls(RDFSClass rDFSClass) {
        String string = "";
        if (rDFSClass instanceof OWLIntersectionClass) {
            string = ProseGen.getProseFromIntersectionCls((OWLIntersectionClass)rDFSClass);
        } else if (rDFSClass instanceof OWLNamedClass) {
            string = ProseGen.getProseFromNamedCls((OWLNamedClass)rDFSClass);
        } else if (rDFSClass instanceof OWLMaxCardinality) {
            string = ProseGen.getProseFromMaxCardiRestriction((OWLMaxCardinality)rDFSClass);
        } else if (rDFSClass instanceof OWLCardinality) {
            string = ProseGen.getProseFromCardiRestriction((OWLCardinality)rDFSClass);
        } else if (rDFSClass instanceof OWLMinCardinality) {
            string = ProseGen.getProseFromMinCardiRestriction((OWLMinCardinality)rDFSClass);
        } else if (rDFSClass instanceof OWLHasValue) {
            string = ProseGen.getProseFromHasRestriction((OWLHasValue)rDFSClass);
        } else if (rDFSClass instanceof OWLSomeValuesFrom) {
            string = ProseGen.getProseFromSomeRestriction((OWLSomeValuesFrom)rDFSClass);
        } else if (rDFSClass instanceof OWLAllValuesFrom) {
            string = ProseGen.getProseFromAllRestriction((OWLAllValuesFrom)rDFSClass);
        } else if (rDFSClass instanceof OWLEnumeratedClass) {
            string = ProseGen.getProseFromEnumerationCls((OWLEnumeratedClass)rDFSClass);
        } else if (rDFSClass instanceof OWLComplementClass) {
            string = ProseGen.getProseFromComplementCls((OWLComplementClass)rDFSClass);
        } else if (rDFSClass instanceof OWLUnionClass) {
            string = ProseGen.getProseFromUnionCls((OWLUnionClass)rDFSClass);
        }
        return string;
    }

    public static String getProseAsString(RDFSClass rDFSClass) {
        return ProseGen.getProseAsString(rDFSClass, true);
    }

    private static boolean isCapsBlock(char c, char c2, char c3) {
        return Character.isUpperCase(c2) && Character.isUpperCase(c) || Character.isUpperCase(c2) && Character.isUpperCase(c3);
    }

    private static String alterStringForNewLine(String string) {
        int n = 0;
        int n2 = 0;
        char[] cArray = string.toCharArray();
        while ((n2 = string.indexOf("<br>", n)) >= 0 && n2 + 4 < string.length()) {
            cArray[n2 + 4] = Character.toUpperCase(string.charAt(n2 + 4));
            n = n2 + 1;
        }
        return new String(cArray);
    }

    private static String changeCase(String string) {
        if (string.length() == 0) {
            return "";
        }
        char[] cArray = string.toCharArray();
        String string2 = "" + Character.toLowerCase(cArray[0]);
        for (int i = 1; i < cArray.length - 1; ++i) {
            string2 = ProseGen.isCapsBlock(cArray[i - 1], cArray[i], cArray[i + 1]) ? string2 + cArray[i] : string2 + Character.toLowerCase(cArray[i]);
        }
        if (cArray.length > 1) {
            string2 = string2 + cArray[cArray.length - 1];
        }
        return ProseGen.alterStringForNewLine(string2);
    }

    public static String getProseAsString(RDFSClass rDFSClass, boolean bl) {
        setTags = bl;
        String string = "";
        indentLevel = 0;
        includePreText = true;
        if (rDFSClass instanceof OWLNamedClass) {
            Object object;
            if (rDFSClass.isSystem()) {
                return "";
            }
            Collection collection = rDFSClass.getEquivalentClasses();
            includePreText = false;
            int n = 1;
            Object object2 = collection.iterator();
            while (object2.hasNext()) {
                object = (Cls)object2.next();
                if (n == 1) {
                    string = "<html><b>Necessary and Sufficient Conditions:</b>";
                }
                if (n == 1 && object2.hasNext() || n > 1) {
                    string = string + "<br><b>Condition Set: " + n + "</b></br>";
                }
                if (object instanceof OWLIntersectionClass || object instanceof OWLUnionClass || object instanceof OWLComplementClass) {
                    if (object2.hasNext() || n > 1) {
                        ++indentLevel;
                        string = string + ProseGen.changeCase(ProseGen.getProseFromCls((RDFSClass)object));
                        --indentLevel;
                    } else {
                        string = string + ProseGen.changeCase(ProseGen.getProseFromCls((RDFSClass)object));
                    }
                } else {
                    ++indentLevel;
                    string = string + "<br>" + ProseGen.insertTabSpaces() + ProseGen.changeCase(ProseGen.getProseFromCls((RDFSClass)object)) + "</br>";
                    --indentLevel;
                }
                ++n;
            }
            if (string == "") {
                string = "<html>";
            }
            object2 = rDFSClass.getPureSuperclasses();
            n = 1;
            object = object2.iterator();
            while (object.hasNext()) {
                Cls cls = (Cls)object.next();
                if (n == 1) {
                    string = string.equalsIgnoreCase("<html>") ? string + "<b>Necessary Conditions:</b>" : string + "<br><b>Necessary Conditions:</b></br>";
                }
                if (cls instanceof OWLIntersectionClass || cls instanceof OWLUnionClass || cls instanceof OWLComplementClass) {
                    if (object.hasNext() || n > 1) {
                        ++indentLevel;
                        string = string + ProseGen.changeCase(ProseGen.getProseFromCls((RDFSClass)cls));
                        --indentLevel;
                    } else {
                        string = string + ProseGen.changeCase(ProseGen.getProseFromCls((RDFSClass)cls));
                    }
                } else if (cls instanceof RDFSClass) {
                    ++indentLevel;
                    String string2 = ProseGen.changeCase(ProseGen.getProseFromCls((RDFSClass)cls));
                    if (string2 != "") {
                        string = string + "<br>" + ProseGen.insertTabSpaces() + string2 + "</br>";
                    }
                    --indentLevel;
                }
                ++n;
            }
            if (n == 1) {
                string = string + "";
            }
            string = string.equalsIgnoreCase("<html>") ? "" : string + "</html>";
        } else {
            string = ProseGen.getProseFromCls(rDFSClass);
            if ((string = ProseGen.changeCase(string)).length() > 0) {
                String string3 = string.substring(0, 1).toUpperCase();
                string = string3 + string.substring(1) + " ";
                if (setTags) {
                    string = "<HTML><p>" + string + "</p></HTML>";
                } else {
                    string = string.replaceAll("<br>", " ");
                    string = string.replaceAll("</br>", " ");
                    string = string.replaceAll("<b>", " ");
                    string = string.replaceAll("</b>", " ");
                }
            }
        }
        return string;
    }
}

