/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.util;

import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.jena.parser.ProtegeOWLParser;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.menu.OWLMenuProjectPlugin;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;

public class ImportHelper {
    private JenaOWLModel owlModel;
    private Collection ontologyURIs;

    public ImportHelper(JenaOWLModel jenaOWLModel) {
        this.owlModel = jenaOWLModel;
        this.ontologyURIs = new ArrayList();
    }

    public void addImport(URI uRI) {
        this.ontologyURIs.add(uRI);
    }

    public void importOntologies() throws Exception {
        this.importOntologies(true);
    }

    public void importOntologies(boolean bl) throws Exception {
        ArrayList<URI> arrayList = new ArrayList<URI>();
        for (URI uRI : this.ontologyURIs) {
            if (this.owlModel.getAllImports().contains(uRI.toString())) continue;
            ProtegeOWLParser.addImport(this.owlModel, uRI);
            for (OWLOntology oWLOntology : this.owlModel.getOWLOntologies()) {
                TripleStore tripleStore = this.owlModel.getTripleStoreModel().getActiveTripleStore();
                if (this.owlModel.getTripleStoreModel().getHomeTripleStore(oWLOntology) != tripleStore) continue;
                oWLOntology.addImports(uRI);
                break;
            }
            arrayList.add(uRI);
        }
        if (arrayList.size() > 0 && OWLUtil.runsWithGUI(this.owlModel)) {
            this.owlModel.getTripleStoreModel().updateEditableResourceState();
            OWLMenuProjectPlugin.makeHiddenClsesWithSubclassesVisible(this.owlModel);
            if (bl) {
                ProtegeUI.reloadUI(this.owlModel);
            }
        }
    }
}

