/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.util;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.util.ResourceCopier;
import java.util.Collection;

public class CloneFactory {
    public static OWLNamedClass cloneOWLNamedClass(OWLNamedClass oWLNamedClass) {
        return CloneFactory.cloneOWLNamedClass(oWLNamedClass, CloneFactory.getNextAvailableCloneName(oWLNamedClass));
    }

    public static OWLNamedClass cloneOWLNamedClass(OWLNamedClass oWLNamedClass, String string) {
        if (string == null) {
            Log.getLogger().warning("Cannot create clone of " + oWLNamedClass + " Clone name should not be null.");
            return null;
        }
        OWLModel oWLModel = oWLNamedClass.getOWLModel();
        if (oWLModel.getRDFResource(string) != null) {
            Log.getLogger().warning("RDFResource with name " + string + " already exists.");
            return null;
        }
        OWLNamedClass oWLNamedClass2 = oWLModel.createOWLNamedClass(string);
        ResourceCopier resourceCopier = new ResourceCopier();
        resourceCopier.copyMultipleSlotValues(oWLNamedClass, oWLNamedClass2);
        Collection collection = oWLNamedClass.getSuperclasses(false);
        for (RDFSClass rDFSClass : collection) {
            rDFSClass.accept(resourceCopier);
            RDFSClass rDFSClass2 = (RDFSClass)resourceCopier.getCopy();
            oWLNamedClass2.addSuperclass(rDFSClass2);
            if (!rDFSClass.getSuperclasses(false).contains(oWLNamedClass)) continue;
            rDFSClass2.addSuperclass(oWLNamedClass2);
        }
        if (!collection.contains(oWLModel.getOWLThingClass())) {
            oWLNamedClass2.removeSuperclass(oWLModel.getOWLThingClass());
        }
        return oWLNamedClass2;
    }

    public static String getNextAvailableCloneName(OWLNamedClass oWLNamedClass) {
        OWLModel oWLModel = oWLNamedClass.getOWLModel();
        String string = null;
        int n = 2;
        do {
            string = oWLNamedClass.getName() + "_" + n;
            ++n;
        } while (oWLModel.getRDFResource(string) != null);
        return string;
    }
}

