/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.triplestore.impl;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.framestore.OWLFrameStore;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

class RDFPropertyPostProcessor {
    private KnowledgeBase kb;
    private OWLModel owlModel;
    private Set specialPropertyTypes = new HashSet();
    private RDFSNamedClass symmetricPropertyClass;
    private RDFSNamedClass transitivePropertyClass;

    RDFPropertyPostProcessor(OWLModel oWLModel) {
        this.owlModel = oWLModel;
        this.kb = oWLModel;
        this.symmetricPropertyClass = oWLModel.getRDFSNamedClass("owl:SymmetricProperty");
        this.transitivePropertyClass = oWLModel.getRDFSNamedClass("owl:TransitiveProperty");
        this.specialPropertyTypes.add(oWLModel.getOWLAnnotationPropertyClass());
        this.specialPropertyTypes.add(oWLModel.getOWLFunctionalPropertyClass());
        this.specialPropertyTypes.add(oWLModel.getRDFSNamedClass("owl:InverseFunctionalProperty"));
        this.specialPropertyTypes.add(this.symmetricPropertyClass);
        this.specialPropertyTypes.add(this.transitivePropertyClass);
        this.specialPropertyTypes.add(oWLModel.getRDFSNamedClass("owl:DeprecatedProperty"));
        for (RDFProperty rDFProperty : oWLModel.getUserDefinedRDFProperties()) {
            TripleStoreUtil.ensureActiveTripleStore(rDFProperty);
            rDFProperty = this.updatePrimaryDirectType(rDFProperty);
            this.updateValueType(rDFProperty);
            this.updateDirectDomain(rDFProperty);
        }
    }

    private void updateDirectDomain(Slot slot) {
        Object object;
        OWLFrameStore oWLFrameStore = this.owlModel.getOWLFrameStore();
        boolean bl = true;
        if (oWLFrameStore != null) {
            bl = oWLFrameStore.suppressUpdateRDFSDomain;
            this.owlModel.getOWLFrameStore().suppressUpdateRDFSDomain = true;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List list = slot.getDirectOwnSlotValues((Slot)this.owlModel.getRDFSDomainProperty());
        if (list.size() == 1) {
            object = (RDFSClass)list.iterator().next();
            if (object instanceof OWLUnionClass) {
                arrayList.addAll(((OWLUnionClass)object).getOperands());
            } else {
                arrayList.add(object);
            }
        }
        if (list.size() > 1) {
            object = (Cls)list.iterator().next();
            arrayList.add(object);
        }
        object = new ArrayList(slot.getDirectDomain());
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Cls cls = (Cls)iterator.next();
            if (arrayList.contains(cls)) continue;
            cls.removeDirectTemplateSlot(slot);
        }
        for (Cls cls : arrayList) {
            if (cls.hasDirectTemplateSlot(slot)) continue;
            cls.addDirectTemplateSlot(slot);
        }
        if (slot.getDirectSuperslotCount() == 0 && slot.getDirectDomain().isEmpty()) {
            this.kb.getRootCls().addDirectTemplateSlot(slot);
        }
        if (oWLFrameStore != null) {
            oWLFrameStore.suppressUpdateRDFSDomain = bl;
        }
    }

    private RDFProperty updatePrimaryDirectType(Slot slot) {
        Collection collection = slot.getDirectTypes();
        if (slot.getDirectTypes().size() > 1) {
            for (RDFSNamedClass rDFSNamedClass : this.specialPropertyTypes) {
                if (!collection.contains(rDFSNamedClass)) continue;
                slot.removeDirectType((Cls)rDFSNamedClass);
                slot.addDirectType((Cls)rDFSNamedClass);
                slot = this.owlModel.getRDFProperty(slot.getName());
            }
        }
        return (RDFProperty)slot;
    }

    private void updateValueType(RDFProperty rDFProperty) {
        RDFProperty rDFProperty2 = rDFProperty;
        Collection collection = rDFProperty.getRanges(false);
        if (collection.isEmpty()) {
            if (rDFProperty.getSuperpropertyCount() == 0) {
                if (rDFProperty instanceof OWLObjectProperty) {
                    rDFProperty2.setValueType(ValueType.INSTANCE);
                } else {
                    rDFProperty2.setValueType(ValueType.ANY);
                }
            } else {
                Slot slot = this.kb.getSlot(":SLOT-VALUE-TYPE");
                if (!rDFProperty2.getDirectOwnSlotValues(slot).isEmpty()) {
                    rDFProperty2.setOwnSlotValues(slot, Collections.EMPTY_LIST);
                }
            }
        } else {
            Object e = collection.iterator().next();
            if (e instanceof RDFSDatatype) {
                String string = ((RDFSDatatype)e).getURI();
                ValueType valueType = XMLSchemaDatatypes.getValueType(string);
                rDFProperty2.setValueType(valueType);
            } else if (e instanceof OWLDataRange) {
                OWLDataRange oWLDataRange = (OWLDataRange)e;
                List list = oWLDataRange.getOneOfValueLiterals();
                if (list.isEmpty()) {
                    rDFProperty2.setValueType(ValueType.ANY);
                } else {
                    RDFSLiteral rDFSLiteral = (RDFSLiteral)list.iterator().next();
                    String string = rDFSLiteral.getDatatype().getURI();
                    ValueType valueType = XMLSchemaDatatypes.getValueType(string);
                    rDFProperty2.setValueType(valueType);
                }
            } else {
                Collection collection2;
                if (rDFProperty2.getValueType() != ValueType.INSTANCE) {
                    rDFProperty2.setValueType(ValueType.INSTANCE);
                    collection2 = Collections.EMPTY_LIST;
                } else {
                    collection2 = rDFProperty2.getAllowedClses();
                }
                Collection collection3 = null;
                collection3 = e instanceof OWLUnionClass ? ((OWLUnionClass)e).getOperands() : Collections.singleton(e);
                if (!CollectionUtilities.containSameItems((Collection)collection2, collection3)) {
                    rDFProperty2.setAllowedClses(collection3);
                }
            }
        }
    }
}

