/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.triplestore.impl;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

class OWLAnonymousClassPostProcessor {
    private KnowledgeBase kb;
    private OWLModel owlModel;
    private Collection<RDFProperty> properties = new ArrayList<RDFProperty>();

    OWLAnonymousClassPostProcessor(OWLModel oWLModel) {
        this.owlModel = oWLModel;
        this.kb = oWLModel;
        this.properties.add(oWLModel.getRDFProperty("owl:onProperty"));
        this.properties.add(oWLModel.getRDFProperty("owl:allValuesFrom"));
        this.properties.add(oWLModel.getRDFProperty("owl:someValuesFrom"));
        this.properties.add(oWLModel.getRDFProperty("owl:hasValue"));
        this.properties.add(oWLModel.getRDFProperty("owl:minCardinality"));
        this.properties.add(oWLModel.getRDFProperty("owl:maxCardinality"));
        this.properties.add(oWLModel.getRDFProperty("owl:cardinality"));
        this.properties.add(oWLModel.getRDFProperty("owl:complementOf"));
        this.properties.add(oWLModel.getRDFProperty("owl:intersectionOf"));
        this.properties.add(oWLModel.getRDFProperty("owl:unionOf"));
        this.properties.add(oWLModel.getRDFProperty("owl:oneOf"));
        this.convertNamedClasses("owl:AllValuesFromRestriction");
        this.convertNamedClasses("owl:SomeValuesFromRestriction");
        this.convertNamedClasses("owl:HasValueRestriction");
        this.convertNamedClasses("owl:MinCardinalityRestriction");
        this.convertNamedClasses("owl:MaxCardinalityRestriction");
        this.convertNamedClasses("owl:CardinalityRestriction");
        this.convertNamedClasses("owl:ComplementClass");
        this.convertNamedClasses("owl:UnionClass");
        this.convertNamedClasses("owl:IntersectionClass");
        this.convertNamedEnumeratedClasses();
    }

    private void convertNamedEnumeratedClasses() {
        RDFSNamedClass rDFSNamedClass = this.owlModel.getRDFSNamedClass("owl:EnumeratedClass");
        RDFProperty rDFProperty = this.owlModel.getOWLOneOfProperty();
        Collection collection = this.owlModel.getOWLNamedClassClass().getInstances(false);
        for (OWLNamedClass oWLNamedClass : collection) {
            if (oWLNamedClass.getPropertyValueCount(rDFProperty) <= 0) continue;
            String string = oWLNamedClass.getName();
            if (this.owlModel.isAnonymousResourceName(string)) {
                TripleStoreUtil.ensureActiveTripleStore(oWLNamedClass);
                oWLNamedClass.setProtegeType(rDFSNamedClass);
                oWLNamedClass.setPropertyValue(this.owlModel.getRDFTypeProperty(), this.owlModel.getOWLNamedClassClass());
                continue;
            }
            this.convertNamedClass(oWLNamedClass, rDFSNamedClass);
        }
    }

    private void convertNamedClasses(String string) {
        Cls cls = this.kb.getCls(string);
        ArrayList arrayList = new ArrayList(cls.getDirectInstances());
        TripleStoreModel tripleStoreModel = this.owlModel.getTripleStoreModel();
        for (RDFSClass rDFSClass : arrayList) {
            String string2 = rDFSClass.getName();
            if (this.owlModel.isAnonymousResourceName(string2)) {
                TripleStore tripleStore = tripleStoreModel.getHomeTripleStore(rDFSClass);
                if (tripleStore.listTriplesWithObject(rDFSClass).hasNext()) continue;
                tripleStoreModel.setActiveTripleStore(tripleStore);
                String string3 = this.owlModel.createNewResourceName("Axiom");
                tripleStore.setRDFResourceName(rDFSClass, string3);
                this.convertNamedClass(rDFSClass, cls);
                continue;
            }
            this.convertNamedClass(rDFSClass, cls);
        }
    }

    private void convertNamedClass(Cls cls, Cls cls2) {
        String string = this.owlModel.getNextAnonymousResourceName();
        TripleStore tripleStore = TripleStoreUtil.ensureActiveTripleStore((RDFResource)cls);
        Cls cls3 = (Cls)cls2.createDirectInstance(string);
        for (RDFProperty rDFProperty : this.properties) {
            List list = cls.getDirectOwnSlotValues((Slot)rDFProperty);
            if (list.isEmpty()) continue;
            tripleStore.getNarrowFrameStore().setValues((Frame)cls3, (Slot)rDFProperty, null, false, (Collection)list);
            tripleStore.getNarrowFrameStore().setValues((Frame)cls, (Slot)rDFProperty, null, false, (Collection)Collections.EMPTY_LIST);
        }
        String string2 = cls.getName();
        cls.setDirectType((Cls)this.owlModel.getOWLNamedClassClass());
        cls = this.owlModel.getOWLNamedClass(string2);
        cls.addDirectSuperclass(cls3);
        cls3.addDirectSuperclass(cls);
    }
}

