/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.triplestore.impl;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Model;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFProperty;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.AbstractAddPropertyValueHandler;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.ProtegeTripleAdder;
import java.util.Iterator;
import java.util.logging.Level;

class AddAnonymousClassPropertyPropertyHandler
extends AbstractAddPropertyValueHandler {
    private RDFProperty directInstancesSlot;
    private RDFProperty directTypesSlot;
    private Class javaType;
    private KnowledgeBase kb;
    private Cls newType;
    private TripleStoreModel tripleStoreModel;

    AddAnonymousClassPropertyPropertyHandler(ProtegeTripleAdder protegeTripleAdder, Cls cls, Class clazz, TripleStoreModel tripleStoreModel) {
        super(protegeTripleAdder);
        this.javaType = clazz;
        this.kb = cls.getKnowledgeBase();
        this.newType = cls;
        this.tripleStoreModel = tripleStoreModel;
        KnowledgeBase knowledgeBase = cls.getKnowledgeBase();
        this.directInstancesSlot = new DefaultRDFProperty(knowledgeBase, Model.SlotID.DIRECT_INSTANCES);
        this.directTypesSlot = new DefaultRDFProperty(knowledgeBase, Model.SlotID.DIRECT_TYPES);
    }

    public void handleAdd(RDFResource rDFResource, Object object) {
        this.removeDirectTypes(rDFResource);
        if (rDFResource.getClass() != this.javaType) {
            try {
                rDFResource = (RDFResource)this.javaType.getConstructor(KnowledgeBase.class, FrameID.class).newInstance(this.kb, rDFResource.getFrameID());
            }
            catch (Exception exception) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
            }
            this.tripleStoreModel.replaceJavaObject(rDFResource);
        }
        if (this.adder.addValue(rDFResource, this.directTypesSlot, this.newType)) {
            this.adder.addValueFast((Instance)this.newType, this.directInstancesSlot, rDFResource);
        }
    }

    private void removeDirectTypes(RDFResource rDFResource) {
        for (TripleStore tripleStore : this.tripleStoreModel.getTripleStores()) {
            Iterator iterator = tripleStore.listObjects(rDFResource, this.directTypesSlot);
            while (iterator.hasNext()) {
                RDFResource rDFResource2 = (RDFResource)iterator.next();
                iterator.remove();
                tripleStore.remove(rDFResource, this.directTypesSlot, rDFResource2);
                tripleStore.remove(rDFResource2, this.directInstancesSlot, rDFResource);
            }
        }
    }
}

