/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSDatatypeFactory;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.XSPNames;
import java.util.Collections;

public class DefaultRDFSDatatypeFactory
implements RDFSDatatypeFactory {
    private OWLModel owlModel;

    public DefaultRDFSDatatypeFactory(OWLModel oWLModel) {
        this.owlModel = oWLModel;
    }

    public RDFSDatatype createAnonymousDatatype(RDFSDatatype rDFSDatatype) {
        String string = this.owlModel.getNextAnonymousResourceName();
        return this.createDatatype(rDFSDatatype, string);
    }

    public RDFSDatatype createDatatype(RDFSDatatype rDFSDatatype, String string) {
        RDFSDatatype rDFSDatatype2 = this.owlModel.createRDFSDatatype(string);
        RDFProperty rDFProperty = XSPNames.getRDFProperty(this.owlModel, 0);
        rDFSDatatype2.setPropertyValue(rDFProperty, rDFSDatatype);
        return rDFSDatatype2;
    }

    public void setLength(RDFSDatatype rDFSDatatype, int n) {
        RDFProperty rDFProperty = XSPNames.getRDFProperty(this.owlModel, 2);
        if (n >= 0) {
            rDFSDatatype.setPropertyValue(rDFProperty, new Integer(n));
        } else {
            rDFSDatatype.setPropertyValues(rDFProperty, Collections.EMPTY_LIST);
        }
    }

    public void setMaxExclusive(RDFSDatatype rDFSDatatype, RDFSLiteral rDFSLiteral) {
        RDFProperty rDFProperty = XSPNames.getRDFProperty(this.owlModel, 5);
        rDFSDatatype.setPropertyValue(rDFProperty, rDFSLiteral);
    }

    public void setMaxInclusive(RDFSDatatype rDFSDatatype, RDFSLiteral rDFSLiteral) {
        RDFProperty rDFProperty = XSPNames.getRDFProperty(this.owlModel, 6);
        rDFSDatatype.setPropertyValue(rDFProperty, rDFSLiteral);
    }

    public void setMaxLength(RDFSDatatype rDFSDatatype, int n) {
        RDFProperty rDFProperty = XSPNames.getRDFProperty(this.owlModel, 8);
        if (n >= 0) {
            rDFSDatatype.setPropertyValue(rDFProperty, new Integer(n));
        } else {
            rDFSDatatype.setPropertyValues(rDFProperty, Collections.EMPTY_LIST);
        }
    }

    public void setMinExclusive(RDFSDatatype rDFSDatatype, RDFSLiteral rDFSLiteral) {
        RDFProperty rDFProperty = XSPNames.getRDFProperty(this.owlModel, 3);
        rDFSDatatype.setPropertyValue(rDFProperty, rDFSLiteral);
    }

    public void setMinInclusive(RDFSDatatype rDFSDatatype, RDFSLiteral rDFSLiteral) {
        RDFProperty rDFProperty = XSPNames.getRDFProperty(this.owlModel, 4);
        rDFSDatatype.setPropertyValue(rDFProperty, rDFSLiteral);
    }

    public void setMinLength(RDFSDatatype rDFSDatatype, int n) {
        RDFProperty rDFProperty = XSPNames.getRDFProperty(this.owlModel, 7);
        if (n >= 0) {
            rDFSDatatype.setPropertyValue(rDFProperty, new Integer(n));
        } else {
            rDFSDatatype.setPropertyValues(rDFProperty, Collections.EMPTY_LIST);
        }
    }

    public void setPattern(RDFSDatatype rDFSDatatype, String string) {
        RDFProperty rDFProperty = XSPNames.getRDFProperty(this.owlModel, 9);
        rDFSDatatype.setPropertyValue(rDFProperty, string);
    }
}

