/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultSlot;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.event.PropertyAdapter;
import edu.stanford.smi.protegex.owl.model.event.PropertyListener;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueListener;
import edu.stanford.smi.protegex.owl.model.event.ResourceListener;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.model.visitor.OWLModelVisitor;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class DefaultRDFProperty
extends DefaultSlot
implements RDFProperty {
    public DefaultRDFProperty(KnowledgeBase knowledgeBase, FrameID frameID) {
        super(knowledgeBase, frameID);
    }

    public DefaultRDFProperty() {
    }

    public void addPropertyListener(PropertyListener propertyListener) {
        if (!(propertyListener instanceof PropertyAdapter)) {
            throw new IllegalArgumentException("Listener must be subclass of PropertyAdapter");
        }
        this.addSlotListener(propertyListener);
    }

    public void addSuperproperty(RDFProperty rDFProperty) {
        this.getKnowledgeBase().addDirectSuperslot((Slot)this, (Slot)rDFProperty);
    }

    public void addEquivalentProperty(RDFProperty rDFProperty) {
        RDFProperty rDFProperty2 = this.getOWLModel().getOWLEquivalentPropertyProperty();
        this.addOwnSlotValue(rDFProperty2, rDFProperty);
    }

    public void addUnionDomainClass(RDFSClass rDFSClass) {
        Collection collection = this.getDirectDomain();
        if (collection.isEmpty()) {
            this.setDomain(rDFSClass);
        } else {
            OWLUnionClass oWLUnionClass = this.getOWLModel().createOWLUnionClass(collection);
            oWLUnionClass.addOperand(rDFSClass);
            this.setDomain(oWLUnionClass);
        }
    }

    public boolean equalsStructurally(RDFObject rDFObject) {
        return this.equals(rDFObject);
    }

    public ImageIcon getBaseImageIcon() {
        return OWLIcons.getImageIcon("RDFProperty");
    }

    public RDFSClass getDomain(boolean bl) {
        Collection collection = this.getDomains(bl);
        if (collection.isEmpty()) {
            return null;
        }
        return (RDFSClass)collection.iterator().next();
    }

    public Collection getDomains(boolean bl) {
        if (bl) {
            List list = this.getDirectOwnSlotValues(this.getOWLModel().getRDFSDomainProperty());
            if (list.isEmpty()) {
                ArrayList arrayList = new ArrayList();
                for (RDFProperty rDFProperty : this.getSuperproperties(false)) {
                    Collection collection = rDFProperty.getDomains(true);
                    arrayList.addAll(collection);
                }
                return arrayList;
            }
            return list;
        }
        return this.getDirectOwnSlotValues(this.getOWLModel().getRDFSDomainProperty());
    }

    public Collection getEquivalentProperties() {
        RDFProperty rDFProperty = this.getOWLModel().getOWLEquivalentPropertyProperty();
        return this.getOwnSlotValues(rDFProperty);
    }

    public RDFProperty getFirstSuperproperty() {
        return (RDFProperty)this.getPropertyValue(this.getOWLModel().getRDFSSubPropertyOfProperty());
    }

    public Icon getInheritedIcon() {
        return OWLIcons.getImageIcon("RDFPropertyInherited");
    }

    public Icon getIcon() {
        if (this.isEditable()) {
            return this.getBaseImageIcon();
        }
        return OWLIcons.getReadOnlyPropertyIcon(OWLIcons.getImageIcon("RDFProperty"));
    }

    public String getIconName() {
        return "RDFProperty";
    }

    public RDFProperty getInverseProperty() {
        return (RDFProperty)this.getKnowledgeBase().getInverseSlot((Slot)this);
    }

    public RDFResource getRange() {
        return this.getRange(false);
    }

    public RDFResource getRange(boolean bl) {
        Object object = this.getPropertyValue(this.getOWLModel().getRDFSRangeProperty());
        if (object instanceof RDFResource) {
            return (RDFResource)object;
        }
        if (object == null && bl) {
            for (RDFProperty rDFProperty : this.getSuperproperties(false)) {
                RDFResource rDFResource = rDFProperty.getRange(true);
                if (rDFResource == null) continue;
                return rDFResource;
            }
        }
        return null;
    }

    public RDFSDatatype getRangeDatatype() {
        RDFResource rDFResource = this.getRange();
        if (rDFResource instanceof RDFSDatatype) {
            return (RDFSDatatype)rDFResource;
        }
        if (rDFResource instanceof OWLDataRange) {
            return ((OWLDataRange)rDFResource).getRDFDatatype();
        }
        return null;
    }

    public Collection getRanges(boolean bl) {
        Collection collection = this.getPropertyValues(this.getOWLModel().getRDFSRangeProperty());
        if (collection.isEmpty() && bl) {
            for (RDFProperty rDFProperty : this.getSuperproperties(false)) {
                collection = rDFProperty.getRanges(true);
                if (collection == null) continue;
                return collection;
            }
        }
        return collection;
    }

    public Collection getSubproperties(boolean bl) {
        if (bl) {
            return this.getKnowledgeBase().getSubslots((Slot)this);
        }
        return this.getKnowledgeBase().getDirectSubslots((Slot)this);
    }

    public int getSubpropertyCount() {
        return this.getKnowledgeBase().getDirectSubslotCount((Slot)this);
    }

    public Collection getSuperproperties(boolean bl) {
        if (bl) {
            return this.getKnowledgeBase().getSuperslots((Slot)this);
        }
        return this.getKnowledgeBase().getDirectSuperslots((Slot)this);
    }

    public int getSuperpropertyCount() {
        return this.getKnowledgeBase().getDirectSuperslotCount((Slot)this);
    }

    public Collection getUnionDomain() {
        return this.getKnowledgeBase().getDirectDomain((Slot)this);
    }

    public Collection getUnionDomain(boolean bl) {
        if (bl) {
            return this.getKnowledgeBase().getDomain((Slot)this);
        }
        return this.getKnowledgeBase().getDirectDomain((Slot)this);
    }

    public Collection getUnionRangeClasses() {
        return AbstractOWLModel.getRDFResources(this.getOWLModel(), this.getKnowledgeBase().getAllowedClses((Slot)this));
    }

    public boolean hasDatatypeRange() {
        RDFResource rDFResource = this.getRange(true);
        return rDFResource instanceof RDFSDatatype || rDFResource instanceof OWLDataRange;
    }

    public boolean hasObjectRange() {
        RDFResource rDFResource = this.getRange(true);
        return rDFResource instanceof RDFSClass;
    }

    public boolean hasRange(boolean bl) {
        Collection collection = this.getRanges(bl);
        return !collection.isEmpty();
    }

    public boolean isSubpropertyOf(RDFProperty rDFProperty, boolean bl) {
        if (bl) {
            return this.getKnowledgeBase().hasSuperslot((Slot)this, (Slot)rDFProperty);
        }
        return this.getKnowledgeBase().hasDirectSuperslot((Slot)this, (Slot)rDFProperty);
    }

    public boolean isAnnotationProperty() {
        return this.hasProtegeType(this.getOWLModel().getOWLAnnotationPropertyClass());
    }

    public boolean isDomainDefined() {
        if (this.getDirectOwnSlotValue(this.getKnowledgeBase().getSlot(":DIRECT-DOMAIN")) == null) {
            return this.getDirectSuperslotCount() == 0;
        }
        return !this.getKnowledgeBase().getRootCls().getDirectTemplateSlots().contains(this);
    }

    public boolean isDomainDefined(boolean bl) {
        if (!bl) {
            return this.isDomainDefined();
        }
        if (this.getDirectOwnSlotValue(this.getKnowledgeBase().getSlot(":DIRECT-DOMAIN")) == null) {
            if (this.getDirectSuperslotCount() == 0) {
                return false;
            }
            return this.isDomainDefined(new HashSet());
        }
        return !this.getKnowledgeBase().getRootCls().hasDirectTemplateSlot((Slot)this);
    }

    private boolean isDomainDefined(Set set) {
        set.add(this);
        if (this.getDirectOwnSlotValue(this.getKnowledgeBase().getSlot(":DIRECT-DOMAIN")) == null) {
            for (Slot slot : this.getDirectSuperslots()) {
                if (set.contains(slot) || !(slot instanceof DefaultRDFProperty) || !((DefaultRDFProperty)slot).isDomainDefined(set)) continue;
                return true;
            }
            return false;
        }
        return !this.getKnowledgeBase().getRootCls().hasDirectTemplateSlot((Slot)this);
    }

    public boolean isFunctional() {
        if (this.hasProtegeType(this.getOWLModel().getOWLFunctionalPropertyClass())) {
            return true;
        }
        for (RDFProperty rDFProperty : this.getSuperproperties(false)) {
            if (!rDFProperty.isFunctional()) continue;
            return true;
        }
        return false;
    }

    public boolean isRangeDefined() {
        return this.getDirectOwnSlotValue(this.getKnowledgeBase().getSlot(":SLOT-VALUE-TYPE")) != null;
    }

    public boolean isReadOnly() {
        OWLDatatypeProperty oWLDatatypeProperty = ((OWLModel)this.getKnowledgeBase()).getProtegeReadOnlyProperty();
        if (oWLDatatypeProperty != null) {
            Object object = this.getDirectOwnSlotValue(oWLDatatypeProperty);
            return Boolean.TRUE.equals(object);
        }
        return false;
    }

    public void removeEquivalentProperty(OWLProperty oWLProperty) {
        RDFProperty rDFProperty = this.getOWLModel().getOWLEquivalentPropertyProperty();
        this.removeOwnSlotValue(rDFProperty, oWLProperty);
    }

    public void removePropertyListener(PropertyListener propertyListener) {
        if (!(propertyListener instanceof PropertyAdapter)) {
            throw new IllegalArgumentException("Listener must be subclass of PropertyAdapter");
        }
        this.removeSlotListener(propertyListener);
    }

    public void removeSuperproperty(RDFProperty rDFProperty) {
        this.getKnowledgeBase().removeDirectSuperslot((Slot)this, (Slot)rDFProperty);
    }

    public void removeUnionDomainClass(RDFSClass rDFSClass) {
        ArrayList arrayList = new ArrayList(this.getDirectDomain());
        arrayList.remove(rDFSClass);
        if (arrayList.isEmpty()) {
            OWLNamedClass oWLNamedClass = rDFSClass.getOWLModel().getOWLThingClass();
            if (rDFSClass != oWLNamedClass && this.getSuperpropertyCount() == 0) {
                this.setDomain(oWLNamedClass);
            } else {
                this.setDomain(null);
            }
        } else if (arrayList.size() == 1) {
            this.setDomain((RDFSClass)arrayList.iterator().next());
        } else {
            OWLUnionClass oWLUnionClass = this.getOWLModel().createOWLUnionClass(arrayList);
            this.setDomain(oWLUnionClass);
        }
    }

    public void setDomainDefined(boolean bl) {
        if (bl != this.isDomainDefined()) {
            if (bl) {
                this.setDomain(null);
            } else if (this.getSuperpropertyCount() > 0) {
                this.setDomain(null);
            } else {
                this.setDomain(this.getOWLModel().getOWLThingClass());
            }
        } else if (!bl && this.getSuperpropertyCount() > 0) {
            this.setDomain(null);
        }
    }

    public void setEquivalentProperties(Collection collection) {
        RDFProperty rDFProperty = this.getOWLModel().getOWLEquivalentPropertyProperty();
        this.setOwnSlotValues(rDFProperty, collection);
    }

    public void setFunctional(boolean bl) {
        this.updateRDFType(bl, this.getOWLModel().getOWLFunctionalPropertyClass());
    }

    public void setInverseProperty(RDFProperty rDFProperty) {
        this.getKnowledgeBase().setInverseSlot((Slot)this, (Slot)rDFProperty);
    }

    public void setRange(RDFResource rDFResource) {
        this.setPropertyValue(this.getOWLModel().getRDFSRangeProperty(), rDFResource);
    }

    public void setRanges(Collection collection) {
        this.setPropertyValues(this.getOWLModel().getRDFSRangeProperty(), collection);
    }

    public void setRDFTypeOfSubproperties(RDFSNamedClass rDFSNamedClass) {
        this.getKnowledgeBase().setDirectTypeOfSubslots((Slot)this, (Cls)rDFSNamedClass);
    }

    public void setUnionRangeClasses(Collection collection) {
        RDFResource rDFResource = null;
        if (collection.size() == 1) {
            rDFResource = (RDFResource)collection.iterator().next();
        } else if (collection.size() > 1) {
            rDFResource = this.getOWLModel().createOWLUnionClass(collection);
        }
        this.setRange(rDFResource);
    }

    public void synchronizeDomainAndRangeOfInverse() {
        Slot slot;
        if (this.getValueType() == ValueType.INSTANCE && (slot = this.getInverseSlot()) != null && slot.getValueType() == ValueType.INSTANCE) {
            this.synchronizeRangeOfInverseWithDomainOfThis();
            this.synchronizeDomainOfInverseWithRangeOfThis();
        }
    }

    private void synchronizeDomainOfInverseWithRangeOfThis() {
        RDFProperty rDFProperty = this.getInverseProperty();
        Slot slot = this.getKnowledgeBase().getSlot(":DIRECT-DOMAIN");
        Set<OWLNamedClass> set = this.getUnionRangeClasses();
        if (set.isEmpty() && rDFProperty.getSuperpropertyCount() == 0) {
            set = Collections.singleton(this.getOWLModel().getOWLThingClass());
        }
        ArrayList arrayList = new ArrayList(rDFProperty.getDirectOwnSlotValues(slot));
        if (set.isEmpty()) {
            for (RDFSClass rDFSClass : arrayList) {
                rDFProperty.removeUnionDomainClass(rDFSClass);
            }
        } else {
            for (RDFSClass rDFSClass : arrayList) {
                if (set.contains(rDFSClass)) continue;
                rDFProperty.removeUnionDomainClass(rDFSClass);
            }
            for (RDFSClass rDFSClass : set) {
                if (rDFSClass.hasDirectTemplateSlot(rDFProperty)) continue;
                rDFProperty.addUnionDomainClass(rDFSClass);
            }
        }
    }

    private void synchronizeRangeOfInverseWithDomainOfThis() {
        RDFProperty rDFProperty = this.getInverseProperty();
        Slot slot = this.getKnowledgeBase().getSlot(":DIRECT-DOMAIN");
        ArrayList arrayList = new ArrayList(this.getDirectOwnSlotValues(slot));
        arrayList.remove(this.getKnowledgeBase().getRootCls());
        Collection collection = rDFProperty.getUnionRangeClasses();
        if (arrayList.isEmpty()) {
            rDFProperty.setRange(null);
        } else {
            HashSet hashSet = new HashSet(collection);
            for (Cls cls : collection) {
                if (arrayList.contains(cls)) continue;
                hashSet.remove(cls);
            }
            hashSet.addAll(arrayList);
            rDFProperty.setUnionRangeClasses(hashSet);
        }
    }

    protected void updateRDFType(boolean bl, RDFSClass rDFSClass) {
        if (this.hasProtegeType(rDFSClass) != bl) {
            if (bl) {
                this.addProtegeType(rDFSClass);
            } else {
                this.removeProtegeType(rDFSClass);
            }
        }
    }

    public void addComment(String string) {
        OWLUtil.addComment(this, string);
    }

    public void addDifferentFrom(RDFResource rDFResource) {
        OWLUtil.addDifferentFrom(this, rDFResource);
    }

    public void addIsDefinedBy(RDFResource rDFResource) {
        OWLUtil.addIsDefinedBy(this, rDFResource);
    }

    public void addLabel(String string, String string2) {
        OWLUtil.addLabel(this, string, string2);
    }

    public void addPropertyValue(RDFProperty rDFProperty, Object object) {
        OWLUtil.addPropertyValue(this, rDFProperty, object);
    }

    public void addPropertyValueListener(PropertyValueListener propertyValueListener) {
        OWLUtil.addPropertyValueListener(this, propertyValueListener);
    }

    public void addProtegeType(RDFSClass rDFSClass) {
        OWLUtil.addProtegeType(this, rDFSClass);
    }

    public void addRDFType(RDFSClass rDFSClass) {
        OWLUtil.addRDFType(this, rDFSClass);
    }

    public void addResourceListener(ResourceListener resourceListener) {
        OWLUtil.addResourceListener(this, resourceListener);
    }

    public void addSameAs(RDFResource rDFResource) {
        OWLUtil.addSameAs(this, rDFResource);
    }

    public void addVersionInfo(String string) {
        OWLUtil.addVersionInfo(this, string);
    }

    public RDFResource as(Class clazz) {
        return OWLUtil.as(this, clazz);
    }

    public boolean canAs(Class clazz) {
        return OWLUtil.canAs(this, clazz);
    }

    public RDFResource getAllValuesFromOnTypes(RDFProperty rDFProperty) {
        return OWLUtil.getAllValuesFromOnTypes(this, rDFProperty);
    }

    public Collection getComments() {
        return OWLUtil.getComments(this);
    }

    public Collection getDifferentFrom() {
        return OWLUtil.getDifferentFrom(this);
    }

    public Collection getHasValuesOnTypes(RDFProperty rDFProperty) {
        return OWLUtil.getHasValuesOnTypes(this, rDFProperty);
    }

    public Class getIconLocation() {
        return OWLIcons.class;
    }

    public RDFSClass getProtegeType() {
        return OWLUtil.getDirectRDFType(this);
    }

    public Collection getProtegeTypes() {
        return OWLUtil.getDirectRDFTypes(this);
    }

    public Collection getDocumentation() {
        return OWLUtil.getComments(this);
    }

    public Collection getInferredTypes() {
        return OWLUtil.getInferredDirectTypes(this);
    }

    public Collection getIsDefinedBy() {
        return OWLUtil.getIsDefinedBy(this);
    }

    public Collection getLabels() {
        return OWLUtil.getLabels(this);
    }

    public String getLocalName() {
        String string = this.getName();
        OWLModel oWLModel = (OWLModel)this.getKnowledgeBase();
        return oWLModel.getLocalNameForResourceName(string);
    }

    public String getNamespace() {
        OWLModel oWLModel = (OWLModel)this.getKnowledgeBase();
        String string = this.getName();
        return oWLModel.getNamespaceForResourceName(string);
    }

    public String getNamespacePrefix() {
        OWLModel oWLModel = (OWLModel)this.getKnowledgeBase();
        String string = this.getName();
        return oWLModel.getPrefixForResourceName(string);
    }

    public OWLModel getOWLModel() {
        return (OWLModel)this.getKnowledgeBase();
    }

    public Collection getPossibleRDFProperties() {
        return OWLUtil.getPossibleRDFProperties(this);
    }

    public Object getPropertyValue(RDFProperty rDFProperty) {
        return OWLUtil.getPropertyValue(this, rDFProperty, false);
    }

    public RDFResource getPropertyValueAs(RDFProperty rDFProperty, Class clazz) {
        return OWLUtil.getPropertyValueAs(this, rDFProperty, clazz);
    }

    public Object getPropertyValue(RDFProperty rDFProperty, boolean bl) {
        return OWLUtil.getPropertyValue(this, rDFProperty, bl);
    }

    public int getPropertyValueCount(RDFProperty rDFProperty) {
        return OWLUtil.getPropertyValueCount(this, rDFProperty);
    }

    public RDFSLiteral getPropertyValueLiteral(RDFProperty rDFProperty) {
        return OWLUtil.getPropertyValueLiteral(this, rDFProperty);
    }

    public Collection getPropertyValueLiterals(RDFProperty rDFProperty) {
        return OWLUtil.getPropertyValueLiterals(this, rDFProperty);
    }

    public Collection getPropertyValues(RDFProperty rDFProperty) {
        return OWLUtil.getPropertyValues(this, rDFProperty, false);
    }

    public Collection getPropertyValuesAs(RDFProperty rDFProperty, Class clazz) {
        return OWLUtil.getPropertyValuesAs(this, rDFProperty, clazz);
    }

    public Collection getPropertyValues(RDFProperty rDFProperty, boolean bl) {
        return OWLUtil.getPropertyValues(this, rDFProperty, bl);
    }

    public Collection getRDFProperties() {
        return OWLUtil.getRDFProperties(this);
    }

    public RDFSClass getRDFType() {
        return OWLUtil.getRDFType(this);
    }

    public Collection getRDFTypes() {
        return OWLUtil.getRDFTypes(this);
    }

    public Set getReferringAnonymousClasses() {
        return OWLUtil.getReferringAnonymousClses(this);
    }

    public Collection getSameAs() {
        return OWLUtil.getSameAs(this);
    }

    public String getURI() {
        return this.getOWLModel().getURIForResourceName(this.getName());
    }

    public Collection getVersionInfo() {
        return OWLUtil.getVersionInfo(this);
    }

    public boolean hasPropertyValue(RDFProperty rDFProperty) {
        return OWLUtil.hasPropertyValue(this, rDFProperty);
    }

    public boolean hasPropertyValue(RDFProperty rDFProperty, boolean bl) {
        return OWLUtil.hasPropertyValue(this, rDFProperty, bl);
    }

    public boolean hasPropertyValue(RDFProperty rDFProperty, Object object) {
        return this.hasPropertyValue(rDFProperty, object, false);
    }

    public boolean hasPropertyValue(RDFProperty rDFProperty, Object object, boolean bl) {
        return OWLUtil.hasPropertyValue(this, rDFProperty, object, bl);
    }

    public boolean hasProtegeType(RDFSClass rDFSClass) {
        return OWLUtil.hasProtegeType(this, rDFSClass);
    }

    public boolean hasProtegeType(RDFSClass rDFSClass, boolean bl) {
        return OWLUtil.hasProtegeType(this, rDFSClass, bl);
    }

    public boolean hasRDFType(RDFSClass rDFSClass) {
        return OWLUtil.hasRDFType(this, rDFSClass);
    }

    public boolean hasRDFType(RDFSClass rDFSClass, boolean bl) {
        return OWLUtil.hasRDFType(this, rDFSClass, bl);
    }

    public boolean isAnonymous() {
        return this.getOWLModel().isAnonymousResourceName(this.getName());
    }

    public boolean isValidPropertyValue(RDFProperty rDFProperty, Object object) {
        return OWLUtil.isValidPropertyValue(this, rDFProperty, object);
    }

    public Iterator listPropertyValues(RDFProperty rDFProperty) {
        return OWLUtil.listPropertyValues(this, rDFProperty, false);
    }

    public Iterator listPropertyValuesAs(RDFProperty rDFProperty, Class clazz) {
        return OWLUtil.listPropertyValuesAs(this, rDFProperty, clazz);
    }

    public Iterator listPropertyValues(RDFProperty rDFProperty, boolean bl) {
        return OWLUtil.listPropertyValues(this, rDFProperty, bl);
    }

    public Iterator listRDFTypes() {
        return this.getRDFTypes().iterator();
    }

    public void removeComment(String string) {
        OWLUtil.removeComment(this, string);
    }

    public void removeDifferentFrom(RDFResource rDFResource) {
        OWLUtil.removeDifferentFrom(this, rDFResource);
    }

    public void removeIsDefinedBy(RDFResource rDFResource) {
        OWLUtil.removeIsDefinedBy(this, rDFResource);
    }

    public void removeLabel(String string, String string2) {
        OWLUtil.removeLabel(this, string, string2);
    }

    public void removePropertyValue(RDFProperty rDFProperty, Object object) {
        OWLUtil.removePropertyValue(this, rDFProperty, object);
    }

    public void removePropertyValueListener(PropertyValueListener propertyValueListener) {
        OWLUtil.removePropertyValueListener(this, propertyValueListener);
    }

    public void removeProtegeType(RDFSClass rDFSClass) {
        OWLUtil.removeProtegeType(this, rDFSClass);
    }

    public void removeRDFType(RDFSClass rDFSClass) {
        OWLUtil.removeRDFType(this, rDFSClass);
    }

    public void removeResourceListener(ResourceListener resourceListener) {
        OWLUtil.removeResourceListener(this, resourceListener);
    }

    public void removeSameAs(RDFResource rDFResource) {
        OWLUtil.removeSameAs(this, rDFResource);
    }

    public void removeVersionInfo(String string) {
        OWLUtil.removeVersionInfo(this, string);
    }

    public void setComment(String string) {
        OWLUtil.setComment(this, string);
    }

    public void setComments(Collection collection) {
        OWLUtil.setComments(this, collection);
    }

    public void setDomain(RDFSClass rDFSClass) {
        if (rDFSClass == null) {
            this.setDomains(Collections.EMPTY_LIST);
        } else {
            this.setDomains(Collections.singleton(rDFSClass));
        }
    }

    public void setDomains(Collection collection) {
        this.setDirectOwnSlotValues(this.getOWLModel().getRDFSDomainProperty(), collection);
    }

    public void setInferredTypes(Collection collection) {
        OWLUtil.setInferredTypes(this, collection);
    }

    public void setDocumentation(String string) {
        OWLUtil.setComment(this, string);
    }

    public void setPropertyValue(RDFProperty rDFProperty, Object object) {
        OWLUtil.setPropertyValue(this, rDFProperty, object);
    }

    public void setPropertyValues(RDFProperty rDFProperty, Collection collection) {
        OWLUtil.setPropertyValues(this, rDFProperty, collection);
    }

    public void setProtegeType(RDFSClass rDFSClass) {
        OWLUtil.setProtegeType(this, rDFSClass);
    }

    public void setProtegeTypes(Collection collection) {
        OWLUtil.setProtegeTypes(this, collection);
    }

    public void setRDFType(RDFSClass rDFSClass) {
        OWLUtil.setRDFType(this, rDFSClass);
    }

    public void setRDFTypes(Collection collection) {
        OWLUtil.setRDFTypes(this, collection);
    }

    public boolean isDeprecated() {
        RDFSNamedClass rDFSNamedClass = this.getOWLModel().getRDFSNamedClass("owl:DeprecatedProperty");
        return this.getProtegeTypes().contains(rDFSNamedClass);
    }

    public void setDeprecated(boolean bl) {
        if (this.isDeprecated() != bl) {
            RDFSNamedClass rDFSNamedClass = this.getOWLModel().getRDFSNamedClass("owl:DeprecatedProperty");
            if (bl) {
                this.addProtegeType(rDFSNamedClass);
            } else {
                this.removeProtegeType(rDFSNamedClass);
            }
        }
    }

    public void accept(OWLModelVisitor oWLModelVisitor) {
        oWLModelVisitor.visitRDFProperty(this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getSimpleName());
        stringBuffer.append("(");
        stringBuffer.append(this.getName());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

