/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.RDFExternalResource;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFUntypedResource;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFIndividual;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreUtil;
import edu.stanford.smi.protegex.owl.model.visitor.OWLModelVisitor;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.RepositoryManager;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;

public class DefaultOWLOntology
extends DefaultRDFIndividual
implements OWLOntology {
    public DefaultOWLOntology(KnowledgeBase knowledgeBase, FrameID frameID) {
        super(knowledgeBase, frameID);
    }

    public DefaultOWLOntology() {
    }

    public void accept(OWLModelVisitor oWLModelVisitor) {
        oWLModelVisitor.visitOWLOntology(this);
    }

    public void addBackwardCompatibleWith(String string) {
        Slot slot = this.getKnowledgeBase().getSlot("owl:backwardCompatibleWith");
        this.addOwnSlotValue(slot, string);
    }

    public void addImports(String string) {
        TripleStore tripleStore = this.getOWLModel().getTripleStoreModel().getTripleStore(string);
        if (tripleStore != null) {
            OWLOntology oWLOntology = (OWLOntology)TripleStoreUtil.getFirstOntology(this.getOWLModel(), tripleStore);
            this.addImportsHelper(oWLOntology);
        } else {
            RDFUntypedResource rDFUntypedResource = this.getOWLModel().getRDFUntypedResource(string, true);
            this.addImportsHelper(rDFUntypedResource);
        }
    }

    public void addImports(URI uRI) {
        this.addImports(uRI.toString());
    }

    public void addImports(RDFExternalResource rDFExternalResource) {
        this.addImportsHelper(rDFExternalResource);
    }

    public void addImports(RDFUntypedResource rDFUntypedResource) {
        this.addImportsHelper(rDFUntypedResource);
    }

    public void addImports(OWLOntology oWLOntology) {
        this.addImportsHelper(oWLOntology);
    }

    private void addImportsHelper(Object object) {
        Slot slot = this.getKnowledgeBase().getSlot("owl:imports");
        this.addOwnSlotValue(slot, object);
    }

    public void addIncompatibleWith(String string) {
        Slot slot = this.getKnowledgeBase().getSlot("owl:incompatibleWith");
        this.addOwnSlotValue(slot, string);
    }

    public void addPriorVersion(String string) {
        Slot slot = this.getKnowledgeBase().getSlot("owl:priorVersion");
        this.addOwnSlotValue(slot, string);
    }

    public boolean equalsStructurally(RDFObject rDFObject) {
        if (rDFObject instanceof OWLOntology) {
            OWLOntology oWLOntology = (OWLOntology)rDFObject;
            return this.getURI().equals(oWLOntology.getURI());
        }
        return false;
    }

    public Collection getBackwardCompatibleWith() {
        Slot slot = this.getKnowledgeBase().getSlot("owl:backwardCompatibleWith");
        return this.getOwnSlotValues(slot);
    }

    public String getBrowserText() {
        String string = this.getOntologyURI();
        if (string == null) {
            return "DefaultOntology";
        }
        return "Ontology(" + string + ")";
    }

    public Icon getIcon() {
        Icon icon = OWLIcons.getImageIcon("OWLOntology");
        if (!this.isAssociatedTriplestoreEditable() || !this.isActive()) {
            icon = OWLIcons.getReadOnlyIcon(icon, "RDFIndividualFrame");
        }
        return icon;
    }

    public Collection getImports() {
        Collection collection = this.getImportResources();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object e : collection) {
            if (!(e instanceof RDFResource)) continue;
            arrayList.add(((RDFResource)e).getURI());
        }
        return arrayList;
    }

    public Collection getImportResources() {
        Slot slot = this.getKnowledgeBase().getSlot("owl:imports");
        return this.getOwnSlotValues(slot);
    }

    public Collection getIncompatibleWith() {
        Slot slot = this.getKnowledgeBase().getSlot("owl:incompatibleWith");
        return this.getOwnSlotValues(slot);
    }

    public String getOntologyURI() {
        return this.getURI();
    }

    public Collection getPriorVersions() {
        Slot slot = this.getKnowledgeBase().getSlot("owl:priorVersion");
        return this.getOwnSlotValues(slot);
    }

    public void removeBackwardCompatibleWith(String string) {
        Slot slot = this.getKnowledgeBase().getSlot("owl:backwardCompatibleWith");
        this.removeOwnSlotValue(slot, string);
    }

    public void removeImports(String string) {
        Object var2_2 = null;
        Collection collection = this.getImportResources();
        for (Object e : collection) {
            String string2 = ((RDFResource)e).getURI();
            if (!string2.equals(string)) continue;
            var2_2 = e;
            break;
        }
        Slot slot = this.getKnowledgeBase().getSlot("owl:imports");
        this.removeOwnSlotValue(slot, var2_2);
    }

    public void removeIncompatibleWith(String string) {
        Slot slot = this.getKnowledgeBase().getSlot("owl:incompatibleWith");
        this.removeOwnSlotValue(slot, string);
    }

    public void removePriorVersion(String string) {
        Slot slot = this.getKnowledgeBase().getSlot("owl:priorVersion");
        this.removeOwnSlotValue(slot, string);
    }

    public boolean isAssociatedTriplestoreEditable() {
        TripleStore tripleStore;
        boolean bl = false;
        OWLModel oWLModel = this.getOWLModel();
        if (this.equals(TripleStoreUtil.getFirstOntology(oWLModel, tripleStore = oWLModel.getTripleStoreModel().getTopTripleStore()))) {
            bl = true;
        } else {
            RepositoryManager repositoryManager = oWLModel.getRepositoryManager();
            URI uRI = null;
            try {
                uRI = new URI(this.getURI());
                Repository repository = repositoryManager.getRepository(uRI);
                if (repository != null) {
                    bl = repository.isWritable(uRI);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
            }
        }
        return bl;
    }

    private boolean isActive() {
        TripleStore tripleStore = this.getOWLModel().getTripleStoreModel().getActiveTripleStore();
        return this.equals(TripleStoreUtil.getFirstOntology(this.getOWLModel(), tripleStore));
    }
}

