/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protegex.owl.model.OWLCardinalityBase;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParseException;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParser;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLRestriction;
import edu.stanford.smi.protegex.owl.ui.profiles.OWLProfiles;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfilesManager;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public abstract class AbstractOWLCardinalityBase
extends AbstractOWLRestriction
implements OWLCardinalityBase {
    public AbstractOWLCardinalityBase(KnowledgeBase knowledgeBase, FrameID frameID, char c) {
        super(knowledgeBase, frameID);
    }

    AbstractOWLCardinalityBase(char c) {
    }

    public void checkFillerText(String string) throws Exception {
        AbstractOWLCardinalityBase.checkFillerText(string, this.getOnProperty());
    }

    public static void checkFillerText(String string, RDFProperty rDFProperty) throws OWLClassParseException, NumberFormatException {
        int n;
        string = string.trim();
        if (ProfilesManager.isFeatureSupported(rDFProperty.getOWLModel(), OWLProfiles.Qualified_Cardinality_Restrictions) && (n = string.indexOf(32)) > 0) {
            String string2 = string.substring(n + 1);
            OWLClassParser oWLClassParser = rDFProperty.getOWLModel().getOWLClassDisplay().getParser();
            oWLClassParser.checkClass(rDFProperty.getOWLModel(), string2);
            string = string.substring(0, n);
        }
        if ((n = Integer.valueOf(string).intValue()) < 0) {
            throw new NumberFormatException("Negative cardinality: " + n);
        }
    }

    public boolean equalsStructurally(RDFObject rDFObject) {
        if (rDFObject instanceof AbstractOWLCardinalityBase) {
            AbstractOWLCardinalityBase abstractOWLCardinalityBase = (AbstractOWLCardinalityBase)rDFObject;
            return this.getOperator() == abstractOWLCardinalityBase.getOperator() && this.getCardinality() == abstractOWLCardinalityBase.getCardinality() && this.getOnProperty().equalsStructurally(abstractOWLCardinalityBase.getOnProperty()) && this.getQualifier().equalsStructurally(abstractOWLCardinalityBase.getQualifier());
        }
        return false;
    }

    public int getCardinality() {
        Object object = this.getPropertyValue(this.getFillerProperty());
        if (object instanceof RDFSLiteral) {
            return ((RDFSLiteral)object).getInt();
        }
        Integer n = (Integer)object;
        return n == null ? 0 : n;
    }

    public RDFSClass getQualifier() {
        RDFSClass rDFSClass = this.getValuesFrom();
        if (rDFSClass == null) {
            return this.getOWLModel().getOWLThingClass();
        }
        return rDFSClass;
    }

    public RDFSClass getValuesFrom() {
        return (RDFSClass)this.getPropertyValue(this.getOWLModel().getOWLValuesFromProperty());
    }

    public String getFillerText() {
        if (this.isQualified()) {
            return Integer.toString(this.getCardinality()) + " " + this.getValuesFrom().getNestedBrowserText();
        }
        return Integer.toString(this.getCardinality());
    }

    public void getNestedNamedClasses(Set set) {
    }

    public boolean isQualified() {
        return this.getValuesFrom() != null;
    }

    public void setCardinality(int n) {
        this.setDirectOwnSlotValue(this.getFillerProperty(), new Integer(n));
    }

    public void setFillerText(String string) throws Exception {
        if (string.length() > 0) {
            Object object;
            int n = string.indexOf(32);
            if (n > 0) {
                object = string.substring(n + 1);
                OWLClassParser oWLClassParser = this.getOWLModel().getOWLClassDisplay().getParser();
                RDFSClass rDFSClass = oWLClassParser.parseClass(this.getOWLModel(), (String)object);
                this.setValuesFrom(rDFSClass);
                string = string.substring(0, n);
            }
            if ((Integer)(object = Integer.valueOf(string)) >= 0) {
                this.setCardinality((Integer)object);
            }
        } else {
            this.setDirectOwnSlotValue(this.getFillerProperty(), null);
        }
    }

    public void setValuesFrom(RDFSClass rDFSClass) {
        this.setPropertyValue(this.getOWLModel().getOWLValuesFromProperty(), rDFSClass);
    }

    public Collection getDependingClasses() {
        RDFSClass rDFSClass;
        if (this.isQualified() && (rDFSClass = this.getQualifier()).isAnonymous()) {
            return Collections.singleton(rDFSClass);
        }
        return Collections.EMPTY_LIST;
    }
}

